/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ParameterManager {
    private HashMap _params = new HashMap();
    private Vector _req = new Vector();
    private Vector _stickies = new Vector();

    public void clear() {
        this._params.clear();
    }

    public void add(Byte by, Object object) {
        this._params.put(by, object);
    }

    public void addRequest(Byte by, boolean bl) {
        if (bl && !this._stickies.contains(by)) {
            this._stickies.add(by);
        } else if (!bl && !this._req.contains(by)) {
            this._req.add(by);
        }
    }

    void serialiseRequest(OutputStream outputStream) throws IOException {
        if (!this.hasRequest()) {
            return;
        }
        Utils.writeInt(this._req.size() + this._stickies.size(), outputStream);
        Iterator iterator = this._req.iterator();
        while (iterator.hasNext()) {
            outputStream.write(((Byte)iterator.next()).byteValue());
        }
        iterator = this._stickies.iterator();
        while (iterator.hasNext()) {
            outputStream.write(((Byte)iterator.next()).byteValue());
        }
    }

    void deserialiseRequest(InputStream inputStream) throws IOException {
        this._req.clear();
        int n = Utils.readInt(inputStream);
        for (int i = 0; i < n; ++i) {
            this._req.add(new Byte((byte)inputStream.read()));
        }
    }

    public boolean hasRequest() {
        return this._req.isEmpty() || this._stickies.isEmpty();
    }

    public void clearRequests() {
        this._req.clear();
    }

    public void clearAllRequests() {
        this._stickies.clear();
        this._req.clear();
    }

    private byte getByteForClass(Object object) {
        if (object instanceof Boolean) {
            return 0;
        }
        if (object instanceof Integer) {
            return 1;
        }
        if (object instanceof String) {
            return 2;
        }
        if (object instanceof byte[]) {
            return 3;
        }
        if (object instanceof Date) {
            return 4;
        }
        return -1;
    }

    private void serialise(Boolean bl, OutputStream outputStream) throws IOException {
        Utils.writeInt(bl != false ? 1 : 0, outputStream);
    }

    private void serialise(String string, OutputStream outputStream) throws IOException {
        Utils.writeString(string, outputStream);
    }

    private void serialise(Integer n, OutputStream outputStream) throws IOException {
        Utils.writeInt(n, outputStream);
    }

    private void serialise(Date date, OutputStream outputStream) throws IOException {
        Utils.writeDate(date, outputStream);
    }

    private void serialise(byte[] byArray, OutputStream outputStream) throws IOException {
        Utils.writeByteArray(byArray, outputStream);
    }

    private void serialise(Object object, OutputStream outputStream) throws IOException {
        if (object instanceof String) {
            this.serialise((String)object, outputStream);
        } else if (object instanceof Integer) {
            this.serialise((Integer)object, outputStream);
        } else if (object instanceof Date) {
            this.serialise((Date)object, outputStream);
        } else if (object instanceof byte[]) {
            this.serialise((byte[])object, outputStream);
        } else if (object instanceof Boolean) {
            this.serialise((Boolean)object, outputStream);
        }
    }

    private void serialiseParameter(Byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by.byteValue());
        Object v = this._params.get(by);
        outputStream.write(this.getByteForClass(v));
        this.serialise(v, outputStream);
    }

    void serialiseParameters(boolean bl, OutputStream outputStream) throws IOException {
        if (bl) {
            Utils.writeInt(this._params.size(), outputStream);
            Set set = this._params.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.serialiseParameter((Byte)iterator.next(), outputStream);
            }
        } else {
            Utils.writeInt(this._req.size(), outputStream);
            Iterator iterator = this._req.iterator();
            while (iterator.hasNext()) {
                this.serialiseParameter((Byte)iterator.next(), outputStream);
            }
        }
    }

    private Object deserialiseParameter(InputStream inputStream) throws IOException {
        byte by = (byte)inputStream.read();
        if (by == 0) {
            return this.deserialiseBoolean(inputStream);
        }
        if (by == 1) {
            return this.deserialiseInteger(inputStream);
        }
        if (by == 2) {
            return this.deserialiseString(inputStream);
        }
        if (by == 4) {
            return this.deserialiseDate(inputStream);
        }
        if (by == 3) {
            return this.deserialiseByteArray(inputStream);
        }
        return null;
    }

    private byte[] deserialiseByteArray(InputStream inputStream) throws IOException {
        return Utils.readByteArray(inputStream);
    }

    private Date deserialiseDate(InputStream inputStream) throws IOException {
        return Utils.readSizedDate(inputStream);
    }

    private String deserialiseString(InputStream inputStream) throws IOException {
        return Utils.readString(inputStream);
    }

    private Integer deserialiseInteger(InputStream inputStream) throws IOException {
        return new Integer(Utils.readSizedInt(inputStream));
    }

    private Boolean deserialiseBoolean(InputStream inputStream) throws IOException {
        return new Boolean(Utils.readSizedInt(inputStream) != 0);
    }

    void deserialiseParameters(InputStream inputStream) throws IOException {
        int n = Utils.readInt(inputStream);
        for (int i = 0; i < n; ++i) {
            byte by = (byte)inputStream.read();
            Object object = this.deserialiseParameter(inputStream);
            this._params.put(new Byte(by), object);
        }
    }

    public Object get(Byte by) {
        return this._params.get(by);
    }
}

