/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.InputOutputStream;
import com.cryptomathic.ss.customer.NoMoreFreeSessionsException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class ServletInputOutputStream
extends InputOutputStream {
    protected byte[] sessionID = null;
    protected URL servlet = null;
    protected URLConnection conn = null;
    protected String url;

    public ServletInputOutputStream(String string) throws MalformedURLException {
        super(null, null);
        this.url = string;
        this.servlet = new URL(string);
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public void commandDone() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    public int read() throws IOException {
        this.prepareRead();
        this.checkEOS();
        int n = this.in.read();
        this.in.available();
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        this.prepareRead();
        this.checkEOS();
        int n = super.read(byArray);
        this.in.available();
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.prepareRead();
        this.checkEOS();
        int n3 = super.read(byArray, n, n2);
        this.in.available();
        return n3;
    }

    public void flush() throws IOException {
    }

    public void write(byte[] byArray) throws IOException {
        this.prepareWrite();
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.prepareWrite();
        this.out.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.prepareWrite();
        this.out.write(n);
    }

    private void checkEOS() throws IOException {
    }

    protected void prepareWrite() throws IOException {
        if (this.out == null) {
            this.conn = this.servlet.openConnection();
            this.conn.setDoInput(true);
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty("Connection", "Keep-Alive");
            this.conn.setUseCaches(false);
            this.conn.setRequestProperty("Content-Type", "java-internal/bytearray");
            this.out = this.conn.getOutputStream();
            if (this.sessionID == null) {
                this.sessionID = new byte[4];
                for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
                    this.sessionID[n] = 0;
                }
            }
            this.out.write(this.sessionID);
        }
    }

    protected void prepareRead() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.in = this.conn.getInputStream();
            if (this.isZero(this.sessionID)) {
                this.checkEOS();
                this.in.read(this.sessionID, 0, 4);
                this.in.available();
                if (this.isZero(this.sessionID)) {
                    throw new NoMoreFreeSessionsException();
                }
            }
            this.out = null;
        }
    }

    protected boolean isZero(byte[] byArray) {
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(byte[] byArray) {
        this.sessionID = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.sessionID, 0, byArray.length);
    }
}

