/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.util;

import java.io.StringWriter;

public class ByteArray
implements Comparable {
    private byte[] value;

    public ByteArray() {
    }

    public ByteArray(byte[] val) {
        this.value = val;
    }

    public ByteArray(String val) {
        this(ByteArray.toByteArray(val));
    }

    public void append(byte[] app) {
        if (this.value == null) {
            this.value = app;
        } else {
            byte[] res = new byte[app.length + this.value.length];
            System.arraycopy(this.value, 0, res, 0, this.value.length);
            System.arraycopy(app, 0, res, this.value.length, app.length);
            this.value = res;
        }
    }

    public void resize(int size) {
        byte[] newvalue = new byte[size];
        System.arraycopy(this.value, 0, newvalue, 0, Math.min(size, this.value.length));
        this.value = newvalue;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.value.length; ++i) {
            hashCode = 31 * hashCode + (this.value[i] & 0xFF);
        }
        return hashCode;
    }

    public static final boolean equals(byte[] arr1, byte[] arr2) {
        if (arr1 == null) {
            return arr2 == null;
        }
        if (arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return false;
        }
        return true;
    }

    public static final int compareTo(byte[] arr1, byte[] arr2) {
        if (arr1.length != arr2.length) {
            return arr1.length - arr2.length;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return arr1[i] - arr2[i];
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArray)) {
            return false;
        }
        return ByteArray.equals(this.value, ((ByteArray)obj).value);
    }

    public int compareTo(ByteArray arr) {
        return ByteArray.compareTo(this.value, arr.value);
    }

    public int compareTo(Object obj) {
        return this.compareTo((ByteArray)obj);
    }

    public static final String toString(byte[] arr) {
        StringWriter string = new StringWriter();
        for (int i = 0; i < arr.length; ++i) {
            int intvalhigh = (arr[i] & 0xF0) >> 4;
            int intvallow = arr[i] & 0xF;
            string.write(Integer.toHexString(intvalhigh));
            string.write(Integer.toHexString(intvallow));
        }
        return string.toString();
    }

    public static final byte[] toByteArray(String hex) {
        if (hex.length() % 2 != 0) {
            throw new NumberFormatException();
        }
        byte[] res = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            int upper = hex.charAt(i);
            if (upper >= 48 && upper <= 57) {
                upper -= 48;
            } else if (upper >= 97 && upper <= 102) {
                upper = upper - 97 + 10;
            } else if (upper >= 65 && upper <= 70) {
                upper = upper - 65 + 10;
            } else {
                throw new NumberFormatException();
            }
            int lower = hex.charAt(i + 1);
            if (lower >= 48 && lower <= 57) {
                lower -= 48;
            } else if (lower >= 97 && lower <= 102) {
                lower = lower - 97 + 10;
            } else if (lower >= 65 && lower <= 70) {
                lower = lower - 65 + 10;
            } else {
                throw new NumberFormatException();
            }
            res[i / 2] = (byte)((upper << 4) + lower);
        }
        return res;
    }

    public String toString() {
        return ByteArray.toString(this.value);
    }

    public static final byte[] copyBytes(byte[] arr, int off, int len) {
        byte[] res = new byte[len];
        System.arraycopy(arr, off, res, 0, len);
        return res;
    }

    public byte[] toByteArray() {
        return this.value;
    }
}

