/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESKeySpec;

public class DESedeKeySpec
implements KeySpec {
    public static int DES_EDE_KEY_LENGTH = 24;
    private byte[] _key_material = new byte[DES_EDE_KEY_LENGTH];

    public DESedeKeySpec(byte[] key) throws InvalidKeyException {
        if (key == null || key.length < DES_EDE_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        System.arraycopy(key, 0, this._key_material, 0, DES_EDE_KEY_LENGTH);
    }

    public DESedeKeySpec(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < DES_EDE_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        System.arraycopy(key, offset, this._key_material, 0, DES_EDE_KEY_LENGTH);
    }

    public byte[] getKey() {
        byte[] copy_off_key_material = new byte[DES_EDE_KEY_LENGTH];
        System.arraycopy(this._key_material, 0, copy_off_key_material, 0, DES_EDE_KEY_LENGTH);
        return copy_off_key_material;
    }

    public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < DES_EDE_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        for (int i = 0; i < 3; ++i) {
            if (DESKeySpec.isParityAdjusted(key, offset + i * 8)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWeak(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < DES_EDE_KEY_LENGTH) {
            throw new InvalidKeyException("Not enough key material.");
        }
        for (int i = 0; i < 3; ++i) {
            if (!DESKeySpec.isWeak(key, offset + i * 8)) continue;
            return true;
        }
        return false;
    }
}

