/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private String _algorithm;
    private byte[] _key;

    public SecretKeySpec(byte[] key, String algorithm) {
        if (key == null) {
            throw new IllegalArgumentException("key is null!");
        }
        this._key = new byte[key.length];
        System.arraycopy(key, 0, this._key, 0, key.length);
        this._algorithm = algorithm;
    }

    public SecretKeySpec(byte[] key, int offset, int len, String algorithm) {
        if (key == null) {
            throw new IllegalArgumentException("key is null!");
        }
        this._key = new byte[len];
        System.arraycopy(key, offset, this._key, 0, len);
        this._algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        byte[] tmp = new byte[this._key.length];
        System.arraycopy(this._key, 0, tmp, 0, this._key.length);
        return tmp;
    }
}

