/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import lu.luxtrust.cryptomathic.CIC_CTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_Certificate;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_Certificate
implements CryptoTI_Certificate {
    private static Log logger = Logger.getLogger(CIC_CTI_Certificate.class);
    private X509Certificate certificate = null;

    public CIC_CTI_Certificate() {
    }

    public CIC_CTI_Certificate(X509Certificate certificate) throws CryptoTI_Exception {
        if (certificate == null) {
            logger.error("Argument \"Certificate\" cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Certificate cannot be null");
        }
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        logger.debug("GET X509CERTIFICATE /");
        return this.certificate;
    }

    public boolean isAuthority() throws CryptoTI_Exception {
        logger.debug("IS AUTHORITY /");
        logger.warn("Attribute \"isAuthority\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute is not available");
    }

    public boolean isCategorySpecified() throws CryptoTI_Exception {
        logger.debug("IS CATEGORY SPECIFIED /");
        logger.warn("Attribute \"isCategorySpecified\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute is not available");
    }

    public boolean isOtherEntity() throws CryptoTI_Exception {
        logger.debug("IS OTHER ENTITY /");
        logger.warn("Attribute \"isOtherEntity\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute is not available");
    }

    public boolean isUserToken() throws CryptoTI_Exception {
        logger.debug("IS USER TOKEN /");
        logger.warn("Attribute \"isUserToken\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Attribute is not available");
    }

    public CryptoTI_Alias getAlias() throws CryptoTI_Exception {
        logger.debug("GET ALIAS /");
        return new CIC_CTI_Alias("CSS_Certificate");
    }

    public byte[] getEncoded() throws CryptoTI_Exception {
        logger.debug("GET ENCODED /");
        if (this.certificate != null) {
            try {
                return this.certificate.getEncoded();
            }
            catch (CertificateEncodingException e) {
                logger.error("Certificate encoding exception", (Throwable)e, 131082);
                throw new CryptoTI_Exception(131082, "Certificate encoding exception");
            }
        }
        logger.warn("Encoded certificate value is not available", 131082);
        throw new CryptoTI_Exception(131082, "Value is not available");
    }

    public String toString() {
        logger.debug("TO STRING /");
        if (this.certificate == null) {
            return "NULL";
        }
        logger.debug(this.certificate.toString());
        return this.certificate.toString();
    }

    public int hashCode() {
        logger.debug("HASH CODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_Certificate other = (CIC_CTI_Certificate)obj;
        return !(this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate));
    }
}

