/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import lu.luxtrust.cryptoti.CryptoTI_Mechanism;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class CIC_CTI_Mechanism
implements CryptoTI_Mechanism {
    private Log logger = Logger.getLogger(CIC_CTI_Mechanism.class);
    public static final String SHA1_RSA_PKCS = "CKM_SHA1_RSA_PKCS";
    public static final String RSA_PKCS = "CKM_RSA_PKCS";
    public static final String SHA256_RSA_PKCS = "CKM_SHA256_RSA_PKCS";
    private String mechanismName = null;

    public CIC_CTI_Mechanism() throws CryptoTI_Exception {
        this.logger.debug("Cryptomathic mechanism: CKM_SHA1_RSA_PKCS");
        this.mechanismName = SHA1_RSA_PKCS;
    }

    public CIC_CTI_Mechanism(String mechanism) throws CryptoTI_Exception {
        this.logger.debug("Cryptomathic mechanism: " + mechanism);
        if (mechanism.equals(RSA_PKCS)) {
            this.mechanismName = RSA_PKCS;
        }
        if (mechanism.equals(SHA1_RSA_PKCS)) {
            this.mechanismName = SHA1_RSA_PKCS;
        }
        if (mechanism.equals(SHA256_RSA_PKCS)) {
            this.mechanismName = SHA256_RSA_PKCS;
        }
    }

    public String getName() throws CryptoTI_Exception {
        this.logger.debug("GET MECHANISM NAME /");
        return this.mechanismName;
    }

    public boolean isSigningEnabled() throws CryptoTI_Exception {
        this.logger.debug("IS SIGNING ENABLED /");
        return true;
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        this.logger.debug("Mechanism: " + this.mechanismName);
        return "Mechanism: " + this.mechanismName;
    }
}

