/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.cryptomathic;

import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandler;
import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;
import com.cryptomathic.luxtrust.signinglibrary.general.VersionWebServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Properties;
import lu.luxtrust.cryptomathic.CIC_CTI_Token;
import lu.luxtrust.cryptoti.CryptoTI_Module;
import lu.luxtrust.cryptoti.CryptoTI_Token;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_SessionException;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;
import lu.luxtrust.utils.TextUtils;

public class CIC_CTI_Module
implements CryptoTI_Module {
    private final String LUXTRUSTVERSION = "1.5.0 //";
    private final String JAVAVERSION = "// Java 1.5";
    private final String VERSION = " ";
    private final String DESCRIPTION = "LuxTrust CryptoTI Adapter for the Cryptomathic supporting LuxTrust Signing Server Token and SMS.";
    private final String VENDOR = "LuxTrust S.A. // Cryptomathic";
    private static final String SUPPORTED_OS_ALL = "ALL";
    private static final String PROPERTY_SUPPORTED_OS = "SUPPORTED_OS";
    private static final String PROPERTY_AUTH_TYPE = "AUTH_TYPE";
    private static final String PROPERTY_CHECK_PWD_FORMAT = "CHECK_PWD_FORMAT";
    private static final String PROPERTY_MIN_PIN_LENGTH = "MIN_PIN_LENGTH";
    private static final String PROPERTY_MAX_PIN_LENGTH = "MAX_PIN_LENGTH";
    private static final String PROPERTY_PIN_FORMAT_MODULE = "PIN_FORMAT_MODULE";
    private static final String PROPERTY_PIN_FORMAT_SESSION = "PIN_FORMAT_SESSION";
    private static final String PROPERTY_IMPORT_LTGR = "IMPORT_LTGR";
    private static final String PROPERTY_AUTH_TYPE_SMS = "SMS";
    private static final String PROPERTY_AUTH_TYPE_VASCO = "VASCO";
    private static final String PROPERTY_AUTH_TYPE_TOTP = "TOTP";
    private static final String PATH_TO_CONFIG_FILE = "/adapterCIC.conf";
    private String PATH_LTGR_CERTIFICATE = "/LTGBRT.crt";
    private Log logger = Logger.getLogger(CIC_CTI_Module.class);
    private static CSSignatureHandlerInterface.AuthenticationType authType = null;
    private AdvancedCSSignatureHandler cssh = null;
    private String supportedOS = null;
    private boolean isLoggedIn = false;
    private long maximumPinLength = -1L;
    private long minimumPinLength = -1L;
    private String pinFormatSession = null;
    private String pinFormatModule = null;
    private boolean checkPWDFormat = false;
    private boolean importLTGR = false;
    private static final String VERSION_SIGNER4 = "4.0";
    private boolean signer4 = false;

    public void initialise(InputStream configurationFile) throws CryptoTI_Exception {
        block47: {
            this.logger.debug("INITIALISE / INPUTSTREAM");
            if (this.cssh != null) {
                this.logger.error("CryptoTI Module already initialised", 131080);
                throw new CryptoTI_Exception(131080, "CryptoTI Module already initialised");
            }
            if (configurationFile == null) {
                this.logger.debug("Loading Default CIC Adapter Configuration File: /adapterCIC.conf");
                configurationFile = CIC_CTI_Module.class.getResourceAsStream(PATH_TO_CONFIG_FILE);
            }
            this.logger.debug("Loading Configuration File...");
            Properties properties = new Properties();
            try {
                try {
                    properties.load(configurationFile);
                    this.supportedOS = properties.getProperty(PROPERTY_SUPPORTED_OS);
                    this.pinFormatSession = properties.getProperty(PROPERTY_PIN_FORMAT_SESSION);
                    this.pinFormatModule = properties.getProperty(PROPERTY_PIN_FORMAT_MODULE);
                    if (properties.getProperty(PROPERTY_MAX_PIN_LENGTH) != null) {
                        if (!TextUtils.matchRegEx(properties.getProperty(PROPERTY_MAX_PIN_LENGTH), "[-]?[0-9]{1,10}")) {
                            this.logger.error("MAX_PIN_LENGTH is not a valid number", 131075);
                            throw new CryptoTI_Exception(131075, "MAX_PIN_LENGTH is not a valid number");
                        }
                    } else {
                        this.logger.error("MAX_PIN_LENGTH cannot be null", 131075);
                        throw new CryptoTI_Exception(131075, "MAX_PIN_LENGTH cannot be null");
                    }
                    this.maximumPinLength = Integer.parseInt(properties.getProperty(PROPERTY_MAX_PIN_LENGTH));
                    if (properties.getProperty(PROPERTY_MIN_PIN_LENGTH) != null) {
                        if (!TextUtils.matchRegEx(properties.getProperty(PROPERTY_MIN_PIN_LENGTH), "[-]?[0-9]{1,10}")) {
                            this.logger.error("MIN_PIN_LENGTH is not a valid number", 131075);
                            throw new CryptoTI_Exception(131075, "MIN_PIN_LENGTH is not a valid number");
                        }
                    } else {
                        this.logger.error("MIN_PIN_LENGTH cannot be null", 131075);
                        throw new CryptoTI_Exception(131075, "MIN_PIN_LENGTH cannot be null");
                    }
                    this.minimumPinLength = Integer.parseInt(properties.getProperty(PROPERTY_MIN_PIN_LENGTH));
                    if (properties.get(PROPERTY_CHECK_PWD_FORMAT) != null) {
                        if (properties.get(PROPERTY_CHECK_PWD_FORMAT).toString().toLowerCase().trim().equals("true") || properties.get(PROPERTY_CHECK_PWD_FORMAT).toString().toLowerCase().trim().equals("false")) {
                            this.checkPWDFormat = Boolean.parseBoolean(properties.get(PROPERTY_CHECK_PWD_FORMAT).toString());
                        } else {
                            this.logger.error("CHECK_PWD_FORMAT is not valid", 131075);
                            throw new CryptoTI_Exception(131075, "CHECK_PWD_FORMAT is not valid");
                        }
                    }
                    if (properties.get(PROPERTY_IMPORT_LTGR) != null) {
                        if (properties.get(PROPERTY_IMPORT_LTGR).toString().toLowerCase().trim().equals("true") || properties.get(PROPERTY_IMPORT_LTGR).toString().toLowerCase().trim().equals("false")) {
                            this.importLTGR = Boolean.parseBoolean(properties.get(PROPERTY_IMPORT_LTGR).toString());
                        } else {
                            this.logger.error("IMPORT_LTGR is not valid", 131075);
                            throw new CryptoTI_Exception(131075, "IMPORT_LTGR is not valid");
                        }
                    }
                    if (this.minimumPinLength > 0L && this.maximumPinLength > 0L) {
                        if (this.minimumPinLength > this.maximumPinLength) {
                            this.logger.error("Minimum pin length must be < then maximum pin length", 131075);
                            throw new CryptoTI_Exception(131075, "Minimum pin length must be < then maximum pin length");
                        }
                    } else {
                        this.logger.error("Minimum and maximum pin length must be > 0: minimumPinLength=" + this.minimumPinLength + ",maximumPinLength=" + this.maximumPinLength, 131075);
                        throw new CryptoTI_Exception(131075, "Minimum and maximum pin length must be > 0");
                    }
                    if (this.pinFormatSession == null) {
                        this.logger.error("Session pin format cannot be null", 131082);
                        throw new CryptoTI_Exception(131082, "Session pin format cannot be null");
                    }
                    this.pinFormatSession = this.pinFormatSession.trim();
                    if (this.pinFormatModule == null) {
                        this.logger.error("Module pin format cannot be null", 131082);
                        throw new CryptoTI_Exception(131082, "Module pin format cannot be null");
                    }
                    this.pinFormatModule = this.pinFormatModule.trim();
                    if (!this.isConfigValid(this.pinFormatSession, this.minimumPinLength, this.maximumPinLength)) {
                        this.logger.error("Configuration file PIN length attributes don't match regular expression", 131082);
                        throw new CryptoTI_Exception(131082, "Configuration file PIN length attributes don't match regular expression");
                    }
                    String authTypeStr = properties.getProperty(PROPERTY_AUTH_TYPE);
                    if (authTypeStr != null && (authTypeStr = authTypeStr.trim()).length() > 0) {
                        if (authTypeStr.equals(PROPERTY_AUTH_TYPE_SMS)) {
                            authType = CSSignatureHandlerInterface.AuthenticationType.SMS;
                        }
                        if (authTypeStr.equals(PROPERTY_AUTH_TYPE_VASCO)) {
                            authType = CSSignatureHandlerInterface.AuthenticationType.VASCO;
                        }
                        if (authTypeStr.equals(PROPERTY_AUTH_TYPE_TOTP)) {
                            authType = CSSignatureHandlerInterface.AuthenticationType.TOTP;
                        }
                    }
                    if (authType == null) {
                        this.logger.error("No authentication type could be selected", 131082);
                        throw new CryptoTI_Exception(131082, "No authentication type could be selected");
                    }
                    if (this.supportedOS == null) {
                        this.logger.error("No supported OS information provided in configuration file", 131082);
                        throw new CryptoTI_Exception(131082, "No supported OS information provided in configuration file");
                    }
                    this.supportedOS = this.supportedOS.trim();
                    this.logger.debug("Supported Operating System: " + this.supportedOS);
                    this.logger.debug("Authentication type: " + (Object)((Object)authType));
                    this.logger.debug("Maximum Pin length: " + this.maximumPinLength);
                    this.logger.debug("Minimum Pin length: " + this.minimumPinLength);
                    this.logger.debug("Pin format session: " + this.pinFormatSession);
                    this.logger.debug("Pin format module: " + this.pinFormatModule);
                    this.logger.debug("Is format to check: " + this.checkPWDFormat);
                    if (this.supportedOS.equals(SUPPORTED_OS_ALL)) {
                        this.cssh = new AdvancedCSSignatureHandler();
                        if (this.cssh != null) {
                            Result result = this.cssh.initialise();
                            if (result.getResultCode() != ResultCodes.OK) {
                                this.logger.error("Library could not be initialised: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131079);
                                throw new CryptoTI_Exception(131079, "Library could not be initialised");
                            }
                            this.logger.debug("Initialize of Cryptomathic library completed.");
                            this.logger.debug("Cryptomathic library version: " + this.cssh.getVersion());
                            this.logger.debug("Result Code: " + (Object)((Object)result.getResultCode()));
                            this.logger.debug("Result Description: " + result.getErrorDescription());
                            this.signer4 = this.isSigner4();
                            this.logger.debug("Is Signer 4 Used ?: " + this.signer4);
                        } else {
                            this.logger.debug("Cryptomathic module is null");
                        }
                        break block47;
                    }
                    if (this.supportedOS.equals("")) {
                        this.logger.error("Supported Operating System value is missing", 131075);
                        throw new CryptoTI_Exception(131075, "Supported Operating System value is missing");
                    }
                    this.logger.error("Operating System \"" + this.supportedOS + "\"is not supported. Use \"ALL\" as value", 131075);
                    throw new CryptoTI_Exception(131075, "Operating System \"" + this.supportedOS + "\" is not supported");
                }
                catch (IOException e) {
                    this.logger.error("An error occured while loading the properties file" + e, 131072);
                    throw new CryptoTI_Exception(131072, "An error occured while loading the properties file");
                }
            }
            finally {
                if (configurationFile != null) {
                    try {
                        configurationFile.close();
                    }
                    catch (IOException e) {
                        this.logger.error("An error occured while closing the configuration file stream" + e, 131072);
                        throw new CryptoTI_Exception(131072, "An error occured while closing the configuration file stream");
                    }
                }
            }
        }
        if (this.importLTGR) {
            try {
                String pathCaCerts = String.valueOf(System.getProperty("java.home")) + "/lib/security/cacerts".replace('/', File.separatorChar);
                File fileCaCerts = new File(pathCaCerts);
                if (fileCaCerts.isFile() && fileCaCerts.canRead() && fileCaCerts.canWrite()) {
                    String aliasLTGR = "luxtrust global root";
                    InputStream certificateFile = CIC_CTI_Module.class.getResourceAsStream(this.PATH_LTGR_CERTIFICATE);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    X509Certificate certificateLTGR = (X509Certificate)factory.generateCertificate(certificateFile);
                    certificateFile.close();
                    FileInputStream fisCaCerts = new FileInputStream(fileCaCerts);
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    String password = "changeit";
                    keystore.load(fisCaCerts, password.toCharArray());
                    fisCaCerts.close();
                    fisCaCerts = null;
                    PKIXParameters params = new PKIXParameters(keystore);
                    boolean found = false;
                    for (TrustAnchor ta : params.getTrustAnchors()) {
                        if (!ta.getTrustedCert().equals(certificateLTGR)) continue;
                        found = true;
                        break;
                    }
                    params = null;
                    Iterator<TrustAnchor> it = null;
                    if (!found) {
                        keystore.setCertificateEntry(aliasLTGR, certificateLTGR);
                        FileOutputStream os = new FileOutputStream(pathCaCerts);
                        keystore.store(os, password.toCharArray());
                        os.close();
                        os = null;
                    }
                    certificateLTGR = null;
                    certificateFile = null;
                    keystore = null;
                    params = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initialise(String pathToConfigurationFile) throws CryptoTI_Exception {
        this.logger.debug("INIT  / CONFIGURATION FILE PATH");
        if (this.cssh != null) {
            this.logger.error("CryptoTI Module already initialised", 131080);
            throw new CryptoTI_Exception(131080, "CryptoTI Module already initialised");
        }
        InputStream is = null;
        if (pathToConfigurationFile == null) {
            is = CIC_CTI_Module.class.getResourceAsStream(PATH_TO_CONFIG_FILE);
        } else {
            if (pathToConfigurationFile.equals("")) {
                this.logger.error("Path to configuration cannot be blank.", 131075);
                throw new CryptoTI_Exception(131075, "Path to configuration cannot be blank.");
            }
            try {
                is = new FileInputStream(new File(pathToConfigurationFile));
            }
            catch (FileNotFoundException e) {
                this.logger.error("Configuration File could not be found!", (Throwable)e, 131072);
                throw new CryptoTI_Exception(131072, "Configuration File could not be found");
            }
        }
        if (is == null) {
            this.logger.error("Inputstream cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Inputstream cannot be null");
        }
        this.initialise(is);
    }

    public String getDescription() throws CryptoTI_Exception {
        this.logger.debug("GET DESCRIPTION /");
        this.logger.debug("LuxTrust CryptoTI Adapter for the Cryptomathic supporting LuxTrust Signing Server Token and SMS.");
        return "LuxTrust CryptoTI Adapter for the Cryptomathic supporting LuxTrust Signing Server Token and SMS.";
    }

    public String getVendor() throws CryptoTI_Exception {
        this.logger.debug("GET VENDOR /");
        this.logger.debug("LuxTrust S.A. // Cryptomathic");
        return "LuxTrust S.A. // Cryptomathic";
    }

    public String getVersion() throws CryptoTI_Exception {
        this.logger.debug("GET VERSION /");
        if (this.cssh != null) {
            return "1.5.0 // Cryptomathic " + this.cssh.getVersion() + " " + "// Java 1.5";
        }
        return "1.5.0 // // Java 1.5";
    }

    public boolean isLoggedIn() throws CryptoTI_Exception {
        this.logger.debug("IS LOGGED IN /");
        return this.isLoggedIn;
    }

    public CryptoTI_Token[] listTokens() throws CryptoTI_Exception {
        this.logger.debug("LIST TOKENS /ONLY ONE TOKEN AVAILABLE");
        if (this.cssh == null) {
            this.logger.error("CryptoTI Module not initialised", 131079);
            throw new CryptoTI_Exception(131079, "CryptoTI Module not initialised");
        }
        CryptoTI_Token[] _tokens = null;
        CIC_CTI_Token token = new CIC_CTI_Token(this.cssh, this.pinFormatSession, this.maximumPinLength, this.minimumPinLength, this.checkPWDFormat, this.signer4);
        if (token == null) {
            this.logger.error("CryptoTI Token could not be created", 131072);
            throw new CryptoTI_Exception(131072, "CryptoTI Token could not be created");
        }
        _tokens = new CIC_CTI_Token[]{token};
        return _tokens;
    }

    public void login(String userName, char[] password) throws CryptoTI_Exception {
        this.logger.debug("LOGIN /");
        boolean isPasswordConform = true;
        if (userName == null) {
            this.logger.error("Username cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Username cannot be null");
        }
        if (password == null) {
            this.logger.error("Password cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Password cannot be null");
        }
        if (this.checkPWDFormat) {
            isPasswordConform = TextUtils.matchRegEx(String.valueOf(password), this.pinFormatModule);
        }
        if (isPasswordConform) {
            Result result = this.cssh.logIn(authType, userName.toUpperCase(), String.valueOf(password));
            if (result.getResultCode() == ResultCodes.OK) {
                this.isLoggedIn = true;
                this.logger.debug("Successfully logged in: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")");
            } else {
                this.isLoggedIn = false;
                if (result.getResultCode() == ResultCodes.ERROR_INCORRECT_AUTHENTICATION) {
                    this.logger.error("The login was incorrect: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 143368);
                    throw new CryptoTI_SessionException(143368, "The login was incorrect");
                }
                if (result.getResultCode() == ResultCodes.ERROR_USER_SUSPENDED) {
                    this.logger.error("The user was suspended: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 143372);
                    throw new CryptoTI_SessionException(143372, "The user was suspended");
                }
                if (result.getResultCode() == ResultCodes.ERROR_CONNECTION) {
                    this.logger.error("A problem connecting to the server occurred: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131072);
                    throw new CryptoTI_Exception(131072, "A problem connecting to the server occurred");
                }
                if (result.getResultCode() == ResultCodes.ERROR_PASSWORD_MUST_BE_RENEWED) {
                    this.logger.error("Password has expired or initial password must be changed: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 143371);
                    throw new CryptoTI_SessionException(143371, "Password has expired or initial password must be changed");
                }
                if (result.getResultCode() == ResultCodes.ERROR_SIGNER_CONNECTION_NOT_INITIALISED) {
                    this.logger.error("Connection to the signing server is not initilalsed: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131079);
                    throw new CryptoTI_Exception(131079, "Connection to the signing server is not initilalsed");
                }
                if (result.getResultCode() == ResultCodes.ERROR_BAD_PARAMETER) {
                    this.logger.error("A wrong parameter has been passed to the method: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131075);
                    throw new CryptoTI_Exception(131075, "A wrong parameter has been passed to the method");
                }
                if (result.getResultCode() == ResultCodes.ERROR_NO_CERTIFICATE_FOUND) {
                    this.logger.error("Signer certificate has not been found: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131082);
                    throw new CryptoTI_Exception(131082, "Signer certificate has not been found");
                }
                if (result.getResultCode() == ResultCodes.ERROR_UNKNOWN_PROBLEM) {
                    this.logger.error("An unknown error occured: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131074);
                    throw new CryptoTI_Exception(131074, "An unknown error occured");
                }
            }
        } else {
            this.logger.warn("Password does not match required PWD format: " + this.pinFormatModule, 143368);
            throw new CryptoTI_SessionException(143368, "Password does not match PWD format");
        }
    }

    public void logoff() throws CryptoTI_Exception {
        this.logger.debug("LOGOFF /");
        Result result = null;
        if (this.cssh != null) {
            result = this.cssh.logOut();
            if (result.getResultCode() == ResultCodes.OK) {
                this.logger.debug("Successfully logged off: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")");
                this.isLoggedIn = false;
            } else {
                this.isLoggedIn = false;
                this.logger.error("Not successfully logged off: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131072);
            }
        } else {
            this.isLoggedIn = false;
            this.logger.debug("Successfully logged off - module was already null");
        }
    }

    public boolean requiresPreAuthentication() throws CryptoTI_Exception {
        this.logger.debug("REQUIRES PRE AUTHENTICATION /");
        return true;
    }

    public void terminate() throws CryptoTI_Exception {
        this.logger.debug("TERMINATE /");
        if (this.cssh != null) {
            Result result = this.cssh.terminate();
            if (result.getResultCode() == ResultCodes.OK) {
                this.logger.debug("Successfully closed connections: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")");
            } else {
                if (result.getResultCode() == ResultCodes.ERROR_CONNECTION) {
                    this.logger.error("Terminate has failed: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131072);
                    throw new CryptoTI_Exception(131072, "Terminate has failed");
                }
                if (result.getResultCode() == ResultCodes.ERROR_LIBRARY_NOT_INITIALISED) {
                    this.logger.error("Connection to the signing server is not initilalsed: " + result.getErrorDescription() + " (" + (Object)((Object)result.getResultCode()) + ")", 131079);
                    throw new CryptoTI_Exception(131079, "Connection to the signing server is not initilalsed");
                }
            }
        }
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        StringBuffer sb = new StringBuffer();
        sb.append("LuxTrust CryptoTI Adapter for the Cryptomathic supporting LuxTrust Signing Server Token and SMS.");
        sb.append(" ");
        sb.append("1.5.0 // // Java 1.5");
        sb.append(" ");
        sb.append("LuxTrust S.A. // Cryptomathic");
        return sb.toString();
    }

    public int hashCode() {
        this.logger.debug("HASH CODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isLoggedIn ? 1231 : 1237);
        result = 31 * result + (this.supportedOS == null ? 0 : this.supportedOS.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIC_CTI_Module other = (CIC_CTI_Module)obj;
        if (this.isLoggedIn != other.isLoggedIn) {
            return false;
        }
        return !(this.supportedOS == null ? other.supportedOS != null : !this.supportedOS.equals(other.supportedOS));
    }

    public String getPINFormat() throws CryptoTI_Exception {
        this.logger.debug("GET MODULE PIN FORMAT /");
        return this.pinFormatModule;
    }

    private boolean isConfigValid(String regex, long minPinLength, long maxPinLength) {
        int endIndex = regex.length();
        int startIndex = regex.indexOf("{");
        boolean hasMore = true;
        if (startIndex > 0) {
            while (hasMore) {
                int tempIndex = regex.indexOf("{", startIndex + 1);
                if (tempIndex < 0) {
                    hasMore = false;
                    continue;
                }
                startIndex = tempIndex;
            }
        }
        return regex.substring(++startIndex, --endIndex).equals(String.valueOf(minPinLength) + "," + maxPinLength);
    }

    private boolean isSigner4() throws CryptoTI_Exception {
        try {
            boolean result = false;
            InputStream is = CIC_CTI_Module.class.getResourceAsStream("/settings.signer.selector.properties");
            Properties prop = new Properties();
            prop.load(is);
            String version = VersionWebServiceUtil.getVersionFromWebService(prop.getProperty("signer.versionUrl"));
            this.logger.debug("Running Signer Version: " + version);
            if (version.equals(VERSION_SIGNER4)) {
                result = true;
            }
            if (version != null) {
                version = null;
            }
            if (is != null) {
                is.close();
                is = null;
            }
            if (prop != null) {
                prop.clear();
                prop = null;
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("A problem connecting to the server occurred.", 131072);
            throw new CryptoTI_Exception(131072, "A problem connecting to the server occurred");
        }
    }
}

