/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.exceptions.ErrorCodeResponseException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class LaunchDownload {
    private static boolean updateAvailable = false;
    private static int numThread = 0;
    private static Object syncObj = new Object();
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";

    private static boolean compareByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean updateLaunchDescInCache(LaunchDesc launchDesc) {
        URL uRL = launchDesc.getLocation();
        if (uRL == null) {
            uRL = launchDesc.getCanonicalHome();
        }
        if (uRL != null) {
            try {
                DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(uRL);
                if (diskCacheEntry != null) {
                    File file = diskCacheEntry.getFile();
                    byte[] byArray = LaunchDescFactory.readBytes(new FileInputStream(file), file.length());
                    byte[] byArray2 = launchDesc.getBytes();
                    if (byArray != null && byArray2 != null && LaunchDownload.compareByteArray(byArray, byArray2)) {
                        return false;
                    }
                }
                Cache.putCanonicalLaunchDesc(uRL, launchDesc);
                return true;
            }
            catch (JNLPException jNLPException) {
                Trace.ignoredException((Exception)jNLPException);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return false;
    }

    static LaunchDesc getUpdatedLaunchDesc(LaunchDesc launchDesc) throws JNLPException, IOException {
        if (launchDesc.getLocation() == null) {
            return null;
        }
        boolean bl = DownloadProtocol.isLaunchFileUpdateAvailable(launchDesc.getLocation());
        if (!bl) {
            return null;
        }
        Trace.println((String)("Downloading updated JNLP descriptor from: " + launchDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getLaunchFile(launchDesc.getLocation(), false);
        try {
            return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
        }
        catch (JNLPException jNLPException) {
            Cache.removeEntry(diskCacheEntry);
            throw jNLPException;
        }
    }

    public static boolean isInCache(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        try {
            DiskCacheEntry diskCacheEntry;
            if (launchDesc.getLocation() != null && (diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation())) == null) {
                return false;
            }
            boolean bl = LaunchDownload.getCachedExtensions(launchDesc);
            if (!bl) {
                return false;
            }
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
            for (int i = 0; i < jARDescArray.length; ++i) {
                int n;
                int n2 = n = jARDescArray[i].isJavaFile() ? 0 : 1;
                if (DownloadProtocol.isInCache(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n)) continue;
                return false;
            }
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
            return false;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCheck(final URL uRL, final String string, final int n, final boolean bl) {
        Object object = syncObj;
        synchronized (object) {
            ++numThread;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object;
                    boolean bl2 = DownloadProtocol.isUpdateAvailable(uRL, string, n);
                    if (bl2 && bl && (object = DownloadProtocol.getCachedVersion(uRL, string, n).getFile()) != null) {
                        ((File)object).delete();
                    }
                    object = syncObj;
                    synchronized (object) {
                        if (bl2 && !updateAvailable) {
                            updateAvailable = true;
                        }
                    }
                }
                catch (JNLPException jNLPException) {
                    Trace.ignoredException((Exception)jNLPException);
                }
                finally {
                    Object object = syncObj;
                    synchronized (object) {
                        numThread--;
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        Object object;
        boolean bl;
        URL uRL = launchDesc.getLocation();
        if (uRL != null && (bl = DownloadProtocol.isLaunchFileUpdateAvailable(uRL))) {
            return true;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return false;
        }
        ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
        for (int i = 0; i < extensionDescArray.length; ++i) {
            URL uRL2 = extensionDescArray[i].getLocation();
            if (uRL2 == null) continue;
            LaunchDownload.updateCheck(uRL2, extensionDescArray[i].getVersion(), 4, false);
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            int n;
            URL uRL3 = jARDescArray[i].getLocation();
            object = jARDescArray[i].getVersion();
            int n2 = n = jARDescArray[i].isJavaFile() ? 0 : 1;
            if (!DownloadProtocol.isInCache(uRL3, (String)object, n)) continue;
            LaunchDownload.updateCheck(uRL3, (String)object, n, jARDescArray[i].isLazyDownload());
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int i = 0; i < iconDescArray.length; ++i) {
                int n;
                String string;
                object = iconDescArray[i].getLocation();
                if (!DownloadProtocol.isInCache((URL)object, string = iconDescArray[i].getVersion(), n = 2)) continue;
                LaunchDownload.updateCheck((URL)object, string, n, false);
            }
        }
        while (numThread > 0) {
            Object object2 = syncObj;
            synchronized (object2) {
                if (updateAvailable) {
                    break;
                }
            }
        }
        return updateAvailable;
    }

    public static File[] getNativeDirectories(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return new File[0];
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < jARDescArray.length; ++i) {
            String string;
            URL uRL;
            DiskCacheEntry diskCacheEntry;
            if (!jARDescArray[i].isNativeLib() || (diskCacheEntry = DownloadProtocol.getCachedVersion(uRL = jARDescArray[i].getLocation(), string = jARDescArray[i].getVersion(), 1)) == null) continue;
            arrayList.add(diskCacheEntry.getDirectory());
        }
        File[] fileArray = new File[arrayList.size()];
        return arrayList.toArray(fileArray);
    }

    static void downloadExtensions(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, ArrayList arrayList) throws IOException, JNLPException {
        LaunchDownload.downloadExtensionsHelper(launchDesc, downloadProgress, n, false, arrayList);
    }

    private static boolean getCachedExtensions(LaunchDesc launchDesc) throws IOException, JNLPException {
        return LaunchDownload.downloadExtensionsHelper(launchDesc, null, 0, true, null);
    }

    private static boolean downloadExtensionsHelper(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        String string = JREInfo.getKnownPlatforms();
        final ArrayList arrayList2 = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList2.add(extensionDesc);
            }
        });
        n += arrayList2.size();
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n2;
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList2.get(i);
            String string2 = extensionDesc.getName();
            if (string2 == null && (n2 = (string2 = extensionDesc.getLocation().toString()).lastIndexOf(47)) > 0) {
                string2 = string2.substring(n2 + 1, string2.length());
            }
            --n;
            if (downloadProgress != null) {
                downloadProgress.extensionDownload(string2, n);
            }
            DiskCacheEntry diskCacheEntry = null;
            if (!bl) {
                diskCacheEntry = DownloadProtocol.getExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), string, false);
            } else {
                diskCacheEntry = DownloadProtocol.getCachedExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), string);
                if (diskCacheEntry == null) {
                    return false;
                }
            }
            Trace.println((String)("Downloaded extension: " + extensionDesc.getLocation() + ": " + diskCacheEntry.getFile()), (TraceLevel)TraceLevel.NETWORK);
            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
            boolean bl2 = false;
            if (launchDesc2.getLaunchType() == 3) {
                bl2 = true;
            } else if (launchDesc2.getLaunchType() == 4) {
                extensionDesc.setInstaller(true);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), launchDesc, false);
                boolean bl3 = bl2 = !localApplicationProperties.isLocallyInstalled();
                if (arrayList != null && (LaunchDownload.isUpdateAvailable(launchDesc2) || bl2)) {
                    arrayList.add(diskCacheEntry.getFile());
                }
                if (bl && bl2) {
                    return false;
                }
            } else {
                throw new MissingFieldException(launchDesc2.getSource(), "<component-desc>|<installer-desc>");
            }
            if (!bl2) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            boolean bl4 = LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, n, bl, arrayList);
            if (bl4) continue;
            return false;
        }
        return true;
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2) {
        return DownloadProtocol.getAvailableVersion(uRL, string, bl, string2);
    }

    public static void downloadJRE(LaunchDesc launchDesc, DownloadProgress downloadProgress, ArrayList arrayList) throws JNLPException, IOException {
        String string;
        boolean bl;
        JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
        String string2 = jREDesc.getVersion();
        URL uRL = jREDesc.getHref();
        boolean bl2 = bl = uRL == null;
        if (uRL == null && (string = Config.getProperty((String)"deployment.javaws.installURL")) != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (downloadProgress != null) {
            downloadProgress.jreDownload(string2, uRL);
        }
        string = JREInfo.getKnownPlatforms();
        DiskCacheEntry diskCacheEntry = null;
        try {
            diskCacheEntry = DownloadProtocol.getJRE(uRL, string2, bl, string);
        }
        catch (ErrorCodeResponseException errorCodeResponseException) {
            errorCodeResponseException.setJreDownload(true);
            throw errorCodeResponseException;
        }
        LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
        if (launchDesc2.getLaunchType() != 4) {
            throw new MissingFieldException(launchDesc2.getSource(), "<installer-desc>");
        }
        if (arrayList != null) {
            arrayList.add(diskCacheEntry.getFile());
        }
        jREDesc.setExtensionDesc(launchDesc2);
        LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, 0, false, arrayList);
    }

    public static void downloadResource(LaunchDesc launchDesc, URL uRL, String string, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadParts(LaunchDesc launchDesc, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadExtensionPart(LaunchDesc launchDesc, URL uRL, String string, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadEagerorAll(LaunchDesc launchDesc, boolean bl, DownloadProgress downloadProgress, boolean bl2) throws IOException, JNLPException {
        JARDesc[] jARDescArray;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray2 = resourcesDesc.getEagerOrAllJarDescs(bl);
        if (!bl && (jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true)).length != jARDescArray2.length) {
            HashSet<JARDesc> hashSet = new HashSet<JARDesc>(Arrays.asList(jARDescArray2));
            int n = 0;
            for (int i = 0; i < jARDescArray.length; ++i) {
                int n2;
                URL uRL = jARDescArray[i].getLocation();
                String string = jARDescArray[i].getVersion();
                int n3 = n2 = jARDescArray[i].isJavaFile() ? 0 : 1;
                if (!hashSet.contains(jARDescArray[i]) && DownloadProtocol.isInCache(uRL, string, n2)) {
                    ++n;
                    continue;
                }
                jARDescArray[i] = null;
            }
            if (n > 0) {
                JARDesc[] jARDescArray3 = new JARDesc[jARDescArray2.length + n];
                System.arraycopy(jARDescArray2, 0, jARDescArray3, 0, jARDescArray2.length);
                int n4 = jARDescArray2.length;
                for (int i = 0; i < jARDescArray.length; ++i) {
                    if (jARDescArray[i] == null) continue;
                    jARDescArray3[n4++] = jARDescArray[i];
                }
                jARDescArray2 = jARDescArray3;
            }
        }
        LaunchDownload.downloadJarFiles(jARDescArray2, downloadProgress, bl2);
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        if (jARDescArray == null) {
            return;
        }
        Trace.println((String)"Contacting server for JAR file sizes", (TraceLevel)TraceLevel.NETWORK);
        long l = 0L;
        for (int i = 0; i < jARDescArray.length && l != -1L; ++i) {
            try {
                JARDesc jARDesc = jARDescArray[i];
                int n = jARDesc.isNativeLib() ? 1 : 0;
                long l2 = jARDesc.getSize();
                if (l2 == 0L) {
                    l2 = DownloadProtocol.getDownloadSize(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n);
                }
                Trace.println((String)("Size of " + jARDescArray[i].getLocation() + ": " + l2), (TraceLevel)TraceLevel.NETWORK);
                if (l2 == -1L) {
                    l = -1L;
                    continue;
                }
                l += l2;
                continue;
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDescArray[i].getLocation(), jARDescArray[i].getVersion());
                }
                throw jNLPException;
            }
        }
        Trace.println((String)("Total size to download: " + l), (TraceLevel)TraceLevel.NETWORK);
        if (l == 0L) {
            return;
        }
        DownloadCallbackHelper downloadCallbackHelper = new DownloadCallbackHelper(downloadProgress, l);
        for (int i = 0; i < jARDescArray.length; ++i) {
            JARDesc jARDesc = jARDescArray[i];
            try {
                int n = jARDesc.isNativeLib() ? 1 : 0;
                DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), n, bl, downloadCallbackHelper);
                Trace.println((String)("Downloaded " + jARDescArray[i].getLocation() + ": " + diskCacheEntry), (TraceLevel)TraceLevel.NETWORK);
                if (diskCacheEntry != null) continue;
                throw new FailedDownloadingResourceException(null, jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), null);
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDesc.getLocation(), jARDesc.getVersion());
                }
                throw jNLPException;
            }
        }
    }

    static void checkJNLPSecurity(LaunchDesc launchDesc) throws MultipleHostsException, NativeLibViolationException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
        if (jARDesc == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, jARDesc.getLocation().getHost(), blArray2, blArray);
        if (blArray2[0]) {
            throw new MultipleHostsException();
        }
        if (blArray[0]) {
            throw new NativeLibViolationException();
        }
    }

    private static void checkJNLPSecurityHelper(LaunchDesc launchDesc, final String string, final boolean[] blArray, final boolean[] blArray2) {
        if (launchDesc.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                String string2 = jARDesc.getLocation().getHost();
                blArray[0] = blArray[0] || !string.equals(string2);
                blArray2[0] = blArray2[0] || jARDesc.isNativeLib();
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                LaunchDesc launchDesc;
                if (!blArray[0] && !blArray2[0] && (launchDesc = extensionDesc.getExtensionDesc()) != null && launchDesc.getSecurityModel() == 0) {
                    String string2 = extensionDesc.getLocation().getHost();
                    boolean bl = blArray[0] = blArray[0] || !string.equals(string2);
                    if (!blArray[0]) {
                        LaunchDownload.checkJNLPSecurityHelper(launchDesc, string, blArray, blArray2);
                    }
                }
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }
        });
    }

    public static long getCachedSize(LaunchDesc launchDesc) {
        long l = 0L;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return l;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            boolean bl = jARDescArray[i].isNativeLib();
            l += DownloadProtocol.getCachedSize(jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), 0);
        }
        return l;
    }

    static String getMainClassName(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException, LaunchDescException {
        Object object;
        AppletDesc appletDesc;
        InstallerDesc installerDesc;
        String string = null;
        ApplicationDesc applicationDesc = launchDesc.getApplicationDescriptor();
        if (applicationDesc != null) {
            string = applicationDesc.getMainClass();
        }
        if ((installerDesc = launchDesc.getInstallerDescriptor()) != null) {
            string = installerDesc.getMainClass();
        }
        if ((appletDesc = launchDesc.getAppletDescriptor()) != null) {
            string = appletDesc.getAppletClass();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDesc.getLocation(), jARDesc.getVersion(), 0, true, null);
        JarFile jarFile = new JarFile(diskCacheEntry.getFile());
        if (string == null && launchDesc.getLaunchType() != 2) {
            object = jarFile.getManifest();
            String string2 = string = object != null ? ((Manifest)object).getMainAttributes().getValue("Main-Class") : null;
        }
        if (string == null) {
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclassspec"), null);
        }
        object = string.replace('.', '/') + ".class";
        if (jarFile.getEntry((String)object) == null) {
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclass", (String)string, (String)jARDesc.getLocation().toString()), null);
        }
        return string;
    }

    static void checkSignedLaunchDesc(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(i);
            LaunchDownload.checkSignedLaunchDescHelper(launchDesc2);
        }
    }

    static void checkSignedResources(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(i);
            LaunchDownload.checkSignedResourcesHelper(launchDesc2);
        }
    }

    private static void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitJREDesc(JREDesc jREDesc) {
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        LaunchDownload.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private static void checkSignedLaunchDescHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        boolean bl = launchDesc.isApplicationDescriptor();
        byte[] byArray = null;
        try {
            byArray = LaunchDownload.getSignedJNLPFile(launchDesc, bl);
            if (byArray != null) {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray);
                Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)launchDesc2.toString(), (TraceLevel)TraceLevel.BASIC);
                launchDesc.checkSigning(launchDesc2);
                byArray = null;
            }
        }
        catch (LaunchDescException launchDescException) {
            launchDescException.setIsSignedLaunchDesc();
            throw launchDescException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
    }

    private static void checkSignedResourcesHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl = true;
        Certificate[] certificateArray = null;
        CodeSource codeSource = null;
        URL uRL = launchDesc.getCanonicalHome();
        int n = 0;
        URL uRL2 = null;
        for (int i = 0; i < jARDescArray.length; ++i) {
            JARDesc jARDesc = jARDescArray[i];
            int n2 = jARDesc.isJavaFile() ? 0 : 1;
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(jARDesc.getLocation(), jARDesc.getVersion(), n2);
            if (diskCacheEntry == null) continue;
            ++n;
            JarFile jarFile = new JarFile(diskCacheEntry.getFile());
            CodeSource codeSource2 = SigningInfo.getCodeSource(uRL, jarFile);
            if (codeSource2 == null) continue;
            Certificate[] certificateArray2 = codeSource2.getCertificates();
            if (certificateArray2 == null) {
                Trace.println((String)("getCertChain returned null for: " + diskCacheEntry.getFile()), (TraceLevel)TraceLevel.BASIC);
                bl = false;
                uRL2 = jARDesc.getLocation();
            }
            if (certificateArray == null) {
                certificateArray = certificateArray2;
                codeSource = codeSource2;
                continue;
            }
            if (certificateArray2 == null || SigningInfo.equalChains(certificateArray, certificateArray2)) continue;
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
        }
        if (launchDesc.getSecurityModel() != 0) {
            if (!bl) {
                throw new UnsignedAccessViolationException(launchDesc, uRL2, true);
            }
            if (n > 0) {
                AppPolicy.getInstance().grantUnrestrictedAccess(launchDesc, codeSource);
            }
        }
    }

    private static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException {
        Object object;
        Object object2;
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDesc.getLocation(), jARDesc.getVersion(), 0, true, null);
        JarFile jarFile = new JarFile(diskCacheEntry.getFile());
        Object object3 = jarFile.getJarEntry(SIGNED_JNLP_ENTRY);
        if (object3 == null) {
            object2 = jarFile.entries();
            while (object2.hasMoreElements() && object3 == null) {
                object = (JarEntry)object2.nextElement();
                if (!((ZipEntry)object).getName().equalsIgnoreCase(SIGNED_JNLP_ENTRY)) continue;
                object3 = object;
            }
        }
        if (object3 == null) {
            if (jarFile != null) {
                jarFile.close();
            }
            return null;
        }
        object2 = new byte[(int)((ZipEntry)object3).getSize()];
        object = new DataInputStream(jarFile.getInputStream((ZipEntry)object3));
        ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
        ((FilterInputStream)object).close();
        jarFile.close();
        return object2;
    }

    private static class DownloadCallbackHelper
    implements DownloadProtocol.DownloadDelegate {
        DownloadProgress _downloadProgress;
        long _totalSize;
        long _downloadedSoFar;
        long _currentTotal;

        public DownloadCallbackHelper(DownloadProgress downloadProgress, long l) {
            this._downloadProgress = downloadProgress;
            this._totalSize = l;
            this._downloadedSoFar = 0L;
        }

        public void downloading(URL uRL, String string, int n, int n2, boolean bl) {
            int n3 = -1;
            if (this._totalSize != -1L) {
                double d = bl ? 0.8 : 0.9;
                double d2 = (double)this._downloadedSoFar + d * (double)n;
                n3 = this.getPercent(d2);
                this._currentTotal = n2;
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.progress(uRL, string, this._downloadedSoFar + (long)n, this._totalSize, n3);
            }
        }

        public void patching(URL uRL, String string, int n) {
            int n2 = -1;
            if (this._totalSize != -1L) {
                double d = (double)this._downloadedSoFar + (double)this._currentTotal * (0.8 + (double)n / 1000.0);
                n2 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.patching(uRL, string, n, n2);
            }
        }

        public void validating(URL uRL, int n, int n2) {
            int n3 = -1;
            if (this._totalSize != -1L && n2 != 0) {
                double d = (double)this._downloadedSoFar + 0.9 * (double)this._currentTotal + 0.1 * (double)this._currentTotal * ((double)n / (double)n2);
                n3 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.validating(uRL, null, n, n2, n3);
            }
            if (n == n2) {
                this._downloadedSoFar += this._currentTotal;
            }
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._downloadProgress != null) {
                this._downloadProgress.downloadFailed(uRL, string);
            }
        }

        private int getPercent(double d) {
            if (d > (double)this._totalSize) {
                this._totalSize = -1L;
                return -1;
            }
            double d2 = d * 100.0 / (double)this._totalSize;
            return (int)(d2 + 0.5);
        }
    }

    public static interface DownloadProgress {
        public void jreDownload(String var1, URL var2);

        public void extensionDownload(String var1, int var2);

        public void progress(URL var1, String var2, long var3, long var5, int var7);

        public void validating(URL var1, String var2, long var3, long var5, int var7);

        public void patching(URL var1, String var2, int var3, int var4);

        public void downloadFailed(URL var1, String var2);
    }
}

