/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.ui.CacheObject;
import com.sun.javaws.ui.CacheViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class CacheTable
extends JTable {
    private static final TableCellRenderer _defaultRenderer = new DefaultTableCellRenderer();
    private static final int MIN_ROW_HEIGHT = 36;
    private boolean _system;
    private int _filter = 0;
    static /* synthetic */ Class class$javax$swing$JLabel;

    public CacheTable(final CacheViewer cacheViewer, boolean bl) {
        this._system = bl;
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        int n = this.getRowHeight();
        if (n < 36) {
            this.setRowHeight(36);
        }
        this.setPreferredScrollableViewportSize(new Dimension(640, 280));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = mouseEvent.getY();
                    int n2 = n / CacheTable.this.getRowHeight();
                    CacheTable.this.getSelectionModel().clearSelection();
                    CacheTable.this.getSelectionModel().addSelectionInterval(n2, n2);
                    cacheViewer.popupApplicationMenu(CacheTable.this, mouseEvent.getX(), n);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = mouseEvent.getY();
                    int n2 = n / CacheTable.this.getRowHeight();
                    CacheTable.this.getSelectionModel().clearSelection();
                    CacheTable.this.getSelectionModel().addSelectionInterval(n2, n2);
                    cacheViewer.popupApplicationMenu(CacheTable.this, mouseEvent.getX(), n);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                Point point = mouseEvent.getPoint();
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (n = CacheTable.this.getColumnModel().getColumnIndexAtX(point.x)) < 3) {
                    cacheViewer.launchApplication();
                }
            }
        });
        this.reset();
    }

    public void setFilter(int n) {
        if (n != this._filter) {
            this._filter = n;
            this.reset();
        }
    }

    public void reset() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof CacheTableModel) {
            ((CacheTableModel)tableModel).removeMouseListenerFromHeaderInTable(this);
        }
        CacheTableModel cacheTableModel = new CacheTableModel(this._system, this._filter);
        this.setModel(cacheTableModel);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setHeaderRenderer(new CacheTableHeaderRenderer());
            int n = cacheTableModel.getPreferredWidth(i);
            tableColumn.setPreferredWidth(n);
            tableColumn.setMinWidth(n);
        }
        this.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = CacheTable.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, cacheTableModel);
        cacheTableModel.addMouseListenerToHeaderInTable(this);
    }

    public CacheObject getCacheObject(int n) {
        return ((CacheTableModel)this.getModel()).getCacheObject(n);
    }

    public String[] getAllHrefs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableModel tableModel = this.getModel();
        if (tableModel instanceof CacheTableModel) {
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                String string = ((CacheTableModel)tableModel).getRowHref(i);
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CacheTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private CacheTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (jTable != null && (object2 = jTable.getTableHeader()) != null) {
                this.setForeground(((Component)object2).getForeground());
                this.setBackground(((Component)object2).getBackground());
                this.setFont(((Component)object2).getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            object2 = CacheObject.getHeaderToolTipText(n2);
            if (object2 != null && ((String)object2).length() > 0) {
                this.setToolTipText((String)object2);
            }
            return this;
        }
    }

    private class CacheTableModel
    extends AbstractTableModel
    implements TableCellRenderer {
        private boolean _system;
        private CacheObject[] _rows;
        private int _filter;
        private int _sortColumn;
        private boolean _sortAscending;
        private MouseListener _mouseListener = null;

        public CacheTableModel(boolean bl, int n) {
            this._system = bl;
            this._filter = n;
            this._rows = new CacheObject[0];
            this._sortColumn = -1;
            this._sortAscending = true;
            this.refresh();
            this.fireTableDataChanged();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Component) {
                Component component = (Component)object;
                if (bl) {
                    component.setForeground(jTable.getSelectionForeground());
                    component.setBackground(jTable.getSelectionBackground());
                } else {
                    component.setForeground(jTable.getForeground());
                    component.setBackground(jTable.getBackground());
                }
                CacheObject.hasFocus(component, bl2);
                return component;
            }
            return _defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public void refresh() {
            ArrayList<CacheObject> arrayList = new ArrayList<CacheObject>();
            Iterator iterator = Cache.getJnlpCacheEntries(this._system);
            while (iterator.hasNext()) {
                CacheObject cacheObject = new CacheObject((DiskCacheEntry)iterator.next(), this);
                if (!cacheObject.inFilter(this._filter) || cacheObject.getLaunchDesc() == null) continue;
                arrayList.add(cacheObject);
            }
            this._rows = arrayList.toArray(new CacheObject[0]);
            if (this._sortColumn != -1) {
                this.sort();
            }
        }

        CacheObject getCacheObject(int n) {
            return this._rows[n];
        }

        public Object getValueAt(int n, int n2) {
            return this._rows[n].getObject(n2);
        }

        public int getRowCount() {
            return this._rows.length;
        }

        public String getRowHref(int n) {
            return this._rows[n].getHref();
        }

        public int getColumnCount() {
            return CacheObject.getColumnCount();
        }

        public boolean isCellEditable(int n, int n2) {
            return this._rows[n].isEditable(n2);
        }

        public Class getColumnClass(int n) {
            return CacheObject.getClass(n);
        }

        public String getColumnName(int n) {
            return CacheObject.getColumnName(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            this._rows[n].setValue(n2, object);
        }

        public int getPreferredWidth(int n) {
            return CacheObject.getPreferredWidth(n);
        }

        public void removeMouseListenerFromHeaderInTable(JTable jTable) {
            if (this._mouseListener != null) {
                jTable.getTableHeader().removeMouseListener(this._mouseListener);
            }
        }

        public void addMouseListenerToHeaderInTable(JTable jTable) {
            final JTable jTable2 = jTable;
            jTable2.setColumnSelectionAllowed(false);
            final ListSelectionModel listSelectionModel = jTable2.getSelectionModel();
            this._mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    TableColumnModel tableColumnModel = jTable2.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = listSelectionModel.getMinSelectionIndex();
                    listSelectionModel.clearSelection();
                    int n3 = jTable2.convertColumnIndexToModel(n);
                    if (mouseEvent.getClickCount() == 1 && n3 >= 0) {
                        int n4 = mouseEvent.getModifiers() & 1;
                        CacheTableModel.this._sortAscending = n4 == 0;
                        CacheTableModel.this._sortColumn = n3;
                        CacheTableModel.this.runSort(listSelectionModel, n2);
                    }
                }
            };
            jTable2.getTableHeader().addMouseListener(this._mouseListener);
        }

        public void sort() {
            boolean bl = false;
            if (this._sortAscending) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    for (int j = i + 1; j < this.getRowCount(); ++j) {
                        if (this._rows[i].compareColumns(this._rows[j], this._sortColumn) <= 0) continue;
                        bl = true;
                        CacheObject cacheObject = this._rows[i];
                        this._rows[i] = this._rows[j];
                        this._rows[j] = cacheObject;
                    }
                }
            } else {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    for (int j = i + 1; j < this.getRowCount(); ++j) {
                        if (this._rows[j].compareColumns(this._rows[i], this._sortColumn) <= 0) continue;
                        bl = true;
                        CacheObject cacheObject = this._rows[i];
                        this._rows[i] = this._rows[j];
                        this._rows[j] = cacheObject;
                    }
                }
            }
            if (bl) {
                this.fireTableDataChanged();
            }
        }

        private void runSort(final ListSelectionModel listSelectionModel, final int n) {
            if (CacheViewer.getStatus() != 4) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block5: {
                            CacheViewer.setStatus(4);
                            try {
                                CacheObject cacheObject = null;
                                if (n >= 0) {
                                    cacheObject = CacheTableModel.this._rows[n];
                                }
                                CacheTableModel.this.sort();
                                if (cacheObject == null) break block5;
                                for (int i = 0; i < CacheTableModel.this._rows.length; ++i) {
                                    if (CacheTableModel.this._rows[i] != cacheObject) continue;
                                    listSelectionModel.addSelectionInterval(i, i);
                                    break;
                                }
                            }
                            finally {
                                CacheViewer.setStatus(0);
                            }
                        }
                    }
                }).start();
            }
        }
    }
}

