/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class XlsxCellHelper
extends BaseHelper {
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "center";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private XlsxStyleHelper styleHelper = null;

    public XlsxCellHelper(Writer writer, XlsxStyleHelper styleHelper) {
        super(writer);
        this.styleHelper = styleHelper;
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex) {
        this.write("  <c r=\"" + XlsxCellHelper.getColumIndexLetter(colIndex) + (rowIndex + 1) + "\" s=\"" + this.styleHelper.getCellStyle(gridCell) + "\" t=\"inlineStr\">");
    }

    public void exportFooter() {
        this.write("</c>");
    }

    public static String getVerticalAlignment(VerticalAlignEnum verticalAlignment) {
        if (verticalAlignment != null) {
            switch (verticalAlignment) {
                case BOTTOM: {
                    return VERTICAL_ALIGN_BOTTOM;
                }
                case MIDDLE: {
                    return VERTICAL_ALIGN_MIDDLE;
                }
            }
            return VERTICAL_ALIGN_TOP;
        }
        return null;
    }

    public static String getColumIndexLetter(int colIndex) {
        int intFirstLetter = colIndex / 676 + 64;
        int intSecondLetter = colIndex % 676 / 26 + 64;
        int intThirdLetter = colIndex % 26 + 65;
        int firstLetter = intFirstLetter > 64 ? (int)intFirstLetter : 32;
        int secondLetter = intSecondLetter > 64 ? (int)intSecondLetter : 32;
        char thirdLetter = (char)intThirdLetter;
        return ("" + (char)firstLetter + (char)secondLetter + thirdLetter).trim();
    }
}

