/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;

public class XlsxZip
extends FileBufferedZip {
    private ExportZipEntry workbookEntry = this.createEntry("xl/workbook.xml");
    private ExportZipEntry stylesEntry = null;
    private ExportZipEntry relsEntry = null;
    private ExportZipEntry contentTypesEntry = null;

    public XlsxZip() throws IOException {
        this.addEntry(this.workbookEntry);
        this.stylesEntry = this.createEntry("xl/styles.xml");
        this.addEntry(this.stylesEntry);
        this.relsEntry = this.createEntry("xl/_rels/workbook.xml.rels");
        this.addEntry(this.relsEntry);
        this.contentTypesEntry = this.createEntry("[Content_Types].xml");
        this.addEntry(this.contentTypesEntry);
        this.addEntry("_rels/.rels", "net/sf/jasperreports/engine/export/ooxml/xlsx/_rels/xml.rels");
    }

    public ExportZipEntry getWorkbookEntry() {
        return this.workbookEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public ExportZipEntry getRelsEntry() {
        return this.relsEntry;
    }

    public ExportZipEntry getContentTypesEntry() {
        return this.contentTypesEntry;
    }

    public ExportZipEntry addSheet(int index) {
        ExportZipEntry sheetEntry = this.createEntry("xl/worksheets/sheet" + index + ".xml");
        this.exportZipEntries.add(sheetEntry);
        return sheetEntry;
    }

    public ExportZipEntry addSheetRels(int index) {
        ExportZipEntry sheetRelsEntry = this.createEntry("xl/worksheets/_rels/sheet" + index + ".xml.rels");
        this.exportZipEntries.add(sheetRelsEntry);
        return sheetRelsEntry;
    }

    public ExportZipEntry addDrawing(int index) {
        ExportZipEntry drawingEntry = this.createEntry("xl/drawings/drawing" + index + ".xml");
        this.exportZipEntries.add(drawingEntry);
        return drawingEntry;
    }

    public ExportZipEntry addDrawingRels(int index) {
        ExportZipEntry drawingRelsEntry = this.createEntry("xl/drawings/_rels/drawing" + index + ".xml.rels");
        this.exportZipEntries.add(drawingRelsEntry);
        return drawingRelsEntry;
    }
}

