/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.MutexHandler;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class DefaultMutexHandler
implements MutexHandler {
    public Object createMutex() throws PKCS11Exception {
        return new Mutex();
    }

    public void destroyMutex(Object object) throws PKCS11Exception {
    }

    public void lockMutex(Object object) throws PKCS11Exception {
        try {
            Mutex mutex = (Mutex)object;
            while (true) {
                try {
                    mutex.lock();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (ClassCastException classCastException) {
            throw new PKCS11Exception(416L);
        }
    }

    public void unlockMutex(Object object) throws PKCS11Exception {
        try {
            Mutex mutex = (Mutex)object;
            mutex.unlock();
        }
        catch (ClassCastException classCastException) {
            throw new PKCS11Exception(416L);
        }
    }

    class Mutex {
        protected boolean locked_ = false;

        public synchronized void lock() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                while (this.locked_) {
                    this.wait();
                }
                this.locked_ = true;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }

        public String toString() {
            return this.locked_ ? "locked" : "unlocked";
        }

        public synchronized boolean unlock() {
            boolean bl = this.locked_;
            this.locked_ = false;
            this.notify();
            return bl;
        }
    }
}

