/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import lu.luxtrust.cryptoti.CryptoTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_Certificate;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Alias;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class GTO_CTI_Certificate
implements CryptoTI_Certificate {
    private static Log logger = Logger.getLogger(GTO_CTI_Certificate.class);
    private X509PublicKeyCertificate certificate = null;

    protected GTO_CTI_Certificate() {
    }

    public GTO_CTI_Certificate(X509PublicKeyCertificate certificate) throws CryptoTI_Exception {
        if (certificate == null) {
            logger.error("Argument \"Certificate\" cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Certificate cannot be null.");
        }
        this.certificate = certificate;
    }

    public boolean isAuthority() throws CryptoTI_Exception {
        logger.debug("IS AUTHORITY /");
        LongAttribute category = this.certificate.getCertificateCategory();
        if (category == null) {
            logger.warn("PKCS#11 attribute \"Category\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Category is not available");
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug("PRESENT (Category) ? " + category.isPresent());
            logger.debug("SENSITIVE (Category) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return category.getLongValue().equals(new Long(2L));
        }
        return false;
    }

    public boolean isCategorySpecified() throws CryptoTI_Exception {
        logger.debug("IS CATEGORY SPECIFIED /");
        LongAttribute category = this.certificate.getCertificateCategory();
        if (category == null) {
            logger.warn("PKCS#11 attribute \"Category\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Category is not available");
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug("PRESENT (Category) ? " + category.isPresent());
            logger.debug("SENSITIVE (Category) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return !category.getLongValue().equals(new Long(0L));
        }
        return false;
    }

    public boolean isOtherEntity() throws CryptoTI_Exception {
        logger.debug("IS OTHER ENTITY /");
        LongAttribute category = this.certificate.getCertificateCategory();
        if (category == null) {
            logger.warn("PKCS#11 attribute \"Category\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Category is not available");
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug("PRESENT (Category) ? " + category.isPresent());
            logger.debug("SENSITIVE (Category) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return category.getLongValue().equals(new Long(3L));
        }
        return false;
    }

    public boolean isUserToken() throws CryptoTI_Exception {
        logger.debug("IS USER TOKEN /");
        LongAttribute category = this.certificate.getCertificateCategory();
        if (category == null) {
            logger.warn("PKCS#11 attribute \"Category\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Category is not available");
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug("PRESENT (Category) ? " + category.isPresent());
            logger.debug("SENSITIVE (Category) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return category.getLongValue().equals(new Long(1L));
        }
        return false;
    }

    public CryptoTI_Alias getAlias() throws CryptoTI_Exception {
        logger.debug("GET ALIAS /");
        CharArrayAttribute label = this.certificate.getLabel();
        if (label == null) {
            logger.warn("PKCS#11 attribute \"Label\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Label is not available");
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug("PRESENT (Token) ? " + label.isPresent());
            logger.debug("SENSITIVE (Token) ? " + label.isSensitive());
        }
        if (label.isPresent()) {
            return new GTO_CTI_Alias(new String(label.getCharArrayValue()));
        }
        logger.warn("PKCS#11 attribute \"Label\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Label is not available");
    }

    public byte[] getEncoded() throws CryptoTI_Exception {
        logger.debug("GET ENCODED /");
        ByteArrayAttribute value = this.certificate.getValue();
        if (value == null) {
            logger.warn("PKCS#11 attribute \"Value\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Value is not available");
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug("PRESENT (value) ? " + value.isPresent());
            logger.debug("SENSITIVE (value) ? " + value.isSensitive());
        }
        if (this.certificate.getValue().isPresent()) {
            return value.getByteArrayValue();
        }
        logger.warn("PKCS#11 attribute \"Value\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Value is not available");
    }

    public X509PublicKeyCertificate getCertificate() {
        logger.debug("GET CERTIFICATE /");
        return this.certificate;
    }

    public int hashCode() {
        logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_Certificate other = (GTO_CTI_Certificate)obj;
        return !(this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate));
    }

    public String toString() {
        logger.debug("TO STRING /");
        if (this.certificate == null) {
            return "";
        }
        if (logger.isDebuggingEnabled()) {
            logger.debug(this.certificate.toString());
        }
        return this.certificate.toString();
    }
}

