/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.Mechanism;
import lu.luxtrust.cryptoti.CryptoTI_Mechanism;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class GTO_CTI_Mechanism
implements CryptoTI_Mechanism {
    private Log logger = Logger.getLogger(GTO_CTI_Mechanism.class);
    private Mechanism mechanism = null;

    public GTO_CTI_Mechanism(Mechanism mechanism) throws CryptoTI_Exception {
        if (mechanism != null) {
            this.mechanism = mechanism;
            if (this.logger.isDebuggingEnabled()) {
                this.logger.debug(mechanism.toString());
            }
        } else {
            this.logger.error("Mechanism cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Mechanism cannot be null.");
        }
    }

    public String getName() throws CryptoTI_Exception {
        this.logger.debug("GET MECHANISM NAME /");
        return this.mechanism.getName();
    }

    public boolean isSigningEnabled() throws CryptoTI_Exception {
        this.logger.debug("IS SIGNING ENABLED /");
        return true;
    }

    public Mechanism getMechanism() {
        this.logger.debug("GET MECHANISM /");
        return this.mechanism;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mechanism == null ? 0 : this.mechanism.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_Mechanism other = (GTO_CTI_Mechanism)obj;
        return !(this.mechanism == null ? other.mechanism != null : !this.mechanism.equals(other.mechanism));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug(this.mechanism.toString());
        }
        return this.mechanism.toString();
    }
}

