/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Scanner;
import lu.luxtrust.cryptoti.CryptoTI_Module;
import lu.luxtrust.cryptoti.CryptoTI_Token;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_NotSupportedException;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_SessionException;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Token;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;
import lu.luxtrust.utils.TextUtils;

public class GTO_CTI_Module
implements CryptoTI_Module {
    private String VERSION = "1.4.2 // // Java 1.5";
    private final String VERSION_DEFAULT_LINUX = "1.4.2 // 5.1 // Java 1.5";
    private final String DESCRIPTION = "LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks.";
    private final String VENDOR = "LuxTrust S.A. // Gemalto";
    private static final String PROPERTY_SUPPORTED_OS = "SUPPORTED_OS";
    private static final String PROPERTY_MULTI_LOGIN = "MULTI_LOGIN";
    private static final String PROPERTY_CHECK_PWD_FORMAT = "CHECK_PWD_FORMAT";
    private static final String PROPERTY_MIN_PIN_LENGTH = "MIN_PIN_LENGTH";
    private static final String PROPERTY_MAX_PIN_LENGTH = "MAX_PIN_LENGTH";
    private static final String PROPERTY_PIN_FORMAT_SESSION = "PIN_FORMAT_SESSION";
    private static final String PROPERTY_LOOKUP_WIN_GCC = "LOOKUP_WIN_GCC";
    private static final String PROPERTY_IMPORT_LTGR = "IMPORT_LTGR";
    private static final String SUPPORTED_OS_WINDOWS32 = "Windows32";
    private static final String SUPPORTED_OS_WINDOWS64 = "Windows64";
    private static final String SUPPORTED_OS_LINUX32 = "Linux32";
    private static final String SUPPORTED_OS_LINUX64 = "Linux64";
    private static final String SUPPORTED_OS_MAC = "MAC";
    private String NAME_PKCS11_WRAPPER_WINDOWS_32 = "pkcs11wrapperWin32.dll";
    private String NAME_PKCS11_WRAPPER_WINDOWS_64 = "pkcs11wrapperWin64.dll";
    private String NAME_PKCS11_WRAPPER_LINUX_32 = "libpkcs11wrapperLin32.so";
    private String NAME_PKCS11_WRAPPER_LINUX_64 = "libpkcs11wrapperLin64.so";
    private String NAME_PKCS11_WRAPPER_MAXOSX = "libpkcs11wrapper.jnilib";
    private String PARAM_INI_FILE_GEMALTO_VERSION = "[gsl_info]";
    private String PATH_GEMALTO_VERSION_WINDOWS = "Gemalto/Common/Diagnostic/GSLibsDiag.ini";
    private String PATH_GEMALTO_VERSION_MAC = "/etc/ClassicClient/GSLibsDiag";
    private String PATH_FOLDER_GEMALTO_VERSION_LINUX = "/usr/lib/ClassicClient/";
    private String PATH_CONFIG_FILE = "/adapterGTO.conf";
    private String PATH_GEMALTO_LIBRARY_WINDOWS = "BIN/gclib.dll";
    private String PATH_GEMALTO_LIBRARY_LINUX = "/usr/lib/pkcs11/libgclib.so";
    private final String PATH_GEMALTO_LIBRARY_MACOSX = "/usr/lib/pkcs11/libgclib.dylib";
    private final String GEMALTO_LIBRARY_NAME_WIN = "gclib.dll";
    private final String NAME_GEMALTO_MIDDLEWARE_PATH_1 = "GEMALTO";
    private static final String NAME_GEMALTO_MIDDLEWARE_PATH_2 = "LUXTRUST";
    private static final String NAME_GEMALTO_MIDDLEWARE_PATH_3 = "CLASSIC CLIENT";
    private static final String NAME_GEMALTO_MIDDLEWARE_PATH_4 = "CLASSICCLIENT";
    private static final String NAME_PREFIX_PKCS11_LIBRARY = "LT_CTI_CC_GEM_";
    private static final String NAME_PREFIX_LINUX_CLASSIC_CLIENT = "libgclib-";
    private final String LOOKUP_LEVEL_OPTIMISTIC = "Optimistic";
    private final String LOOKUP_LEVEL_PESSIMISTIC = "Pessimistic";
    private String PATH_LTGR_CERTIFICATE = "/LTGBRT.crt";
    private Module pkcs11Module = null;
    private String supportedOS = null;
    private boolean multiLogin = false;
    private boolean checkPWDFormat = false;
    private long minimumPinLength = -1L;
    private long maximumPinLength = -1L;
    private String pinFormatSession = null;
    private String lookupWinGcc = null;
    private boolean isInitialised = false;
    private File tmpLibraryFile = null;
    private boolean importLTGR = true;
    private Log logger = Logger.getLogger(GTO_CTI_Module.class);

    public String getDescription() throws CryptoTI_Exception {
        this.logger.debug("GET DESCRIPTION /");
        this.logger.debug("LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks.");
        return "LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks.";
    }

    public String getVendor() throws CryptoTI_Exception {
        this.logger.debug("GET VENDOR /");
        this.logger.debug("LuxTrust S.A. // Gemalto");
        return "LuxTrust S.A. // Gemalto";
    }

    public String getVersion() throws CryptoTI_Exception {
        this.logger.debug("GET VERSION /");
        this.logger.debug(this.VERSION);
        if (this.isInitialised) {
            String _version;
            if (this.supportedOS.equals(SUPPORTED_OS_WINDOWS32) || this.supportedOS.equals(SUPPORTED_OS_WINDOWS64)) {
                return this.VERSION;
            }
            if (this.supportedOS.equals(SUPPORTED_OS_MAC) && (_version = this.getGemaltoVersionMACOSX()) != null) {
                return this.setVersion(_version);
            }
            if (this.supportedOS.equals(SUPPORTED_OS_LINUX32) || this.supportedOS.equals(SUPPORTED_OS_LINUX64)) {
                _version = this.getGemaltoVersionLinux();
                if (_version != null) {
                    return this.setVersion(_version);
                }
                return "1.4.2 // 5.1 // Java 1.5";
            }
        }
        return this.VERSION;
    }

    public void initialise(InputStream configurationFile) throws CryptoTI_Exception {
        this.logger.debug("INIT / Configuration Stream");
        if (this.pkcs11Module != null) {
            this.logger.error("CryptoTI Module already initialised.", 131080);
            throw new CryptoTI_Exception(131080, "CryptoTI Module already initialised.");
        }
        if (configurationFile == null) {
            this.logger.debug("Loading Default GTO Adapter Configuration File: " + this.PATH_CONFIG_FILE);
            configurationFile = GTO_CTI_Module.class.getResourceAsStream(this.PATH_CONFIG_FILE);
        }
        this.logger.debug("Loading Configuration File...");
        Properties properties = new Properties();
        try {
            properties.load(configurationFile);
        }
        catch (IOException e) {
            this.logger.error("Configuration File could not be loaded!", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "Configuration File could not be loaded!");
        }
        this.logger.debug("Configuration File loaded correctly!");
        if (properties.getProperty(PROPERTY_MAX_PIN_LENGTH) != null) {
            if (!TextUtils.matchRegEx(properties.getProperty(PROPERTY_MAX_PIN_LENGTH), "[-]?[0-9]{1,10}")) {
                this.logger.error("MAX_PIN_LENGTH is not a valid number", 131075);
                throw new CryptoTI_Exception(131075, "MAX_PIN_LENGTH is not a valid number");
            }
        } else {
            this.logger.error("MAX_PIN_LENGTH cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "MAX_PIN_LENGTH cannot be null");
        }
        this.maximumPinLength = Integer.parseInt(properties.getProperty(PROPERTY_MAX_PIN_LENGTH));
        if (properties.getProperty(PROPERTY_MIN_PIN_LENGTH) != null) {
            if (!TextUtils.matchRegEx(properties.getProperty(PROPERTY_MIN_PIN_LENGTH), "[-]?[0-9]{1,10}")) {
                this.logger.error("MIN_PIN_LENGTH is not a valid number", 131075);
                throw new CryptoTI_Exception(131075, "MIN_PIN_LENGTH is not a valid number");
            }
        } else {
            this.logger.error("MIN_PIN_LENGTH cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "MIN_PIN_LENGTH cannot be null");
        }
        this.minimumPinLength = Integer.parseInt(properties.getProperty(PROPERTY_MIN_PIN_LENGTH));
        this.pinFormatSession = properties.getProperty(PROPERTY_PIN_FORMAT_SESSION);
        if (properties.get(PROPERTY_CHECK_PWD_FORMAT) != null) {
            if (properties.get(PROPERTY_CHECK_PWD_FORMAT).toString().toLowerCase().trim().equals("true") || properties.get(PROPERTY_CHECK_PWD_FORMAT).toString().toLowerCase().trim().equals("false")) {
                this.checkPWDFormat = Boolean.parseBoolean(properties.get(PROPERTY_CHECK_PWD_FORMAT).toString());
            } else {
                this.logger.error("CHECK_PWD_FORMAT is not valid", 131075);
                throw new CryptoTI_Exception(131075, "CHECK_PWD_FORMAT is not valid");
            }
        }
        if (this.minimumPinLength > 0L && this.maximumPinLength > 0L) {
            if (this.minimumPinLength >= this.maximumPinLength) {
                this.logger.error("Minimum pin length must be < then maximum pin length", 131075);
                throw new CryptoTI_Exception(131075, "Minimum pin length must be < then maximum pin length");
            }
        } else {
            this.logger.error("Minimum and maximum pin length must be > 0: minimumPinLength=" + this.minimumPinLength + ",maximumPinLength=" + this.maximumPinLength, 131075);
            throw new CryptoTI_Exception(131075, "Minimum and maximum pin length must be > 0");
        }
        if (this.pinFormatSession == null) {
            this.logger.error("Session PIN format cannot be null", 131082);
            throw new CryptoTI_Exception(131082, "Session pin format cannot be null");
        }
        this.pinFormatSession = this.pinFormatSession.trim();
        if (!this.isConfigValid(this.pinFormatSession, this.minimumPinLength, this.maximumPinLength)) {
            this.logger.error("Configuration file PIN length attributes don't match regular expression", 131082);
            throw new CryptoTI_Exception(131082, "Configuration file PIN length attributes don't match regular expression");
        }
        if (properties.getProperty(PROPERTY_SUPPORTED_OS) == null || properties.getProperty(PROPERTY_SUPPORTED_OS).equals("")) {
            this.logger.error("No supported OS information provided in configuration file", 131082);
            throw new CryptoTI_Exception(131082, "No supported OS information provided in configuration file");
        }
        this.supportedOS = properties.getProperty(PROPERTY_SUPPORTED_OS).trim();
        if (properties.get(PROPERTY_MULTI_LOGIN) != null) {
            if (properties.get(PROPERTY_MULTI_LOGIN).toString().toLowerCase().trim().equals("true") || properties.get(PROPERTY_MULTI_LOGIN).toString().toLowerCase().trim().equals("false")) {
                this.multiLogin = Boolean.parseBoolean(properties.get(PROPERTY_MULTI_LOGIN).toString());
            } else {
                this.logger.error("MULTI_LOGIN is not valid", 131075);
                throw new CryptoTI_Exception(131075, "MULTI_LOGIN is not valid");
            }
        }
        if (properties.get(PROPERTY_LOOKUP_WIN_GCC) != null) {
            if (properties.get(PROPERTY_LOOKUP_WIN_GCC).toString().toUpperCase().trim().equals("Optimistic".toUpperCase())) {
                this.lookupWinGcc = "Optimistic";
            } else if (properties.get(PROPERTY_LOOKUP_WIN_GCC).toString().toUpperCase().trim().equals("Pessimistic".toUpperCase())) {
                this.lookupWinGcc = "Pessimistic";
            } else {
                this.logger.error("LOOKUP_WIN_GCC is not valid", 131075);
                throw new CryptoTI_Exception(131075, "LOOKUP_WIN_GCC is not valid");
            }
        }
        if (properties.get(PROPERTY_IMPORT_LTGR) != null) {
            if (properties.get(PROPERTY_IMPORT_LTGR).toString().toLowerCase().trim().equals("true") || properties.get(PROPERTY_IMPORT_LTGR).toString().toLowerCase().trim().equals("false")) {
                this.importLTGR = Boolean.parseBoolean(properties.get(PROPERTY_IMPORT_LTGR).toString());
            } else {
                this.logger.error("IMPORT_LTGR is not valid", 131075);
                throw new CryptoTI_Exception(131075, "IMPORT_LTGR is not valid");
            }
        }
        if (!(this.supportedOS.equals(SUPPORTED_OS_LINUX32) || this.supportedOS.equals(SUPPORTED_OS_LINUX64) || this.supportedOS.equals(SUPPORTED_OS_WINDOWS32) || this.supportedOS.equals(SUPPORTED_OS_WINDOWS64) || this.supportedOS.equals(SUPPORTED_OS_MAC))) {
            this.logger.error("Operating System is not supported!", 131075);
            throw new CryptoTI_Exception(131075, "Operating System is not supported!");
        }
        this.logger.debug("OS: " + this.supportedOS);
        String namePkcs11WrapperFile = null;
        String pathGemaltoLibraryFile = null;
        File middlewareFile = null;
        if (this.supportedOS.equals(SUPPORTED_OS_WINDOWS32) || this.supportedOS.equals(SUPPORTED_OS_WINDOWS64)) {
            if (this.lookupWinGcc == null) {
                this.logger.error("LOOKUP_WIN_GCC is not valid", 131075);
                throw new CryptoTI_Exception(131075, "LOOKUP_WIN_GCC is not valid");
            }
            if (this.supportedOS.equals(SUPPORTED_OS_WINDOWS32)) {
                namePkcs11WrapperFile = this.NAME_PKCS11_WRAPPER_WINDOWS_32;
            } else if (this.supportedOS.equals(SUPPORTED_OS_WINDOWS64)) {
                namePkcs11WrapperFile = this.NAME_PKCS11_WRAPPER_WINDOWS_64;
            }
            String[] gccInfo = this.getGemaltoInfoWin();
            if (gccInfo != null) {
                String _gccVersion = gccInfo[0];
                String _installDir = gccInfo[1];
                pathGemaltoLibraryFile = String.valueOf(_installDir) + File.separator + this.PATH_GEMALTO_LIBRARY_WINDOWS;
                this.VERSION = this.setVersion(_gccVersion);
                middlewareFile = new File(pathGemaltoLibraryFile);
                if (!middlewareFile.exists()) {
                    this.logger.error("Gemalto Middleware does not exist: " + pathGemaltoLibraryFile, 131081);
                    throw new CryptoTI_Exception(131081, "Gemalto Middleware does not exist!");
                }
            } else if (this.lookupWinGcc.equals("Optimistic")) {
                pathGemaltoLibraryFile = "gclib.dll";
            } else if (this.lookupWinGcc.equals("Pessimistic") && (pathGemaltoLibraryFile = this.getGemaltoLibPathWin()) == null) {
                pathGemaltoLibraryFile = "gclib.dll";
            }
        }
        if (this.supportedOS.equals(SUPPORTED_OS_LINUX32)) {
            this.logger.debug("Linux 32 Wrapper File Name: " + this.NAME_PKCS11_WRAPPER_LINUX_32);
            namePkcs11WrapperFile = this.NAME_PKCS11_WRAPPER_LINUX_32;
            pathGemaltoLibraryFile = this.PATH_GEMALTO_LIBRARY_LINUX;
            this.logger.debug("Path to Gemalto Library Linux: " + pathGemaltoLibraryFile);
            middlewareFile = new File(pathGemaltoLibraryFile);
            if (!middlewareFile.exists()) {
                this.logger.error("Gemalto Middleware is not installed!", 131081);
                throw new CryptoTI_Exception(131081, "Middleware is not installed!");
            }
        }
        if (this.supportedOS.equals(SUPPORTED_OS_LINUX64)) {
            this.logger.debug("Linux 64 Wrapper File Name: " + this.NAME_PKCS11_WRAPPER_LINUX_64);
            namePkcs11WrapperFile = this.NAME_PKCS11_WRAPPER_LINUX_64;
            pathGemaltoLibraryFile = this.PATH_GEMALTO_LIBRARY_LINUX;
            this.logger.debug("Path to Gemalto Library Linux: " + pathGemaltoLibraryFile);
            middlewareFile = new File(pathGemaltoLibraryFile);
            if (!middlewareFile.exists()) {
                this.logger.error("Gemalto Middleware is not installed!", 131081);
                throw new CryptoTI_Exception(131081, "Middleware is not installed!");
            }
        }
        if (this.supportedOS.equals(SUPPORTED_OS_MAC)) {
            this.logger.debug("MAC OS X Wrapper File Name: " + this.NAME_PKCS11_WRAPPER_MAXOSX);
            namePkcs11WrapperFile = this.NAME_PKCS11_WRAPPER_MAXOSX;
            pathGemaltoLibraryFile = "/usr/lib/pkcs11/libgclib.dylib";
            this.logger.debug("Path to Gemalto Library MAC OS X: " + pathGemaltoLibraryFile);
            middlewareFile = new File(pathGemaltoLibraryFile);
            if (!middlewareFile.exists()) {
                this.logger.error("Gemalto Middleware is not installed!", 131081);
                throw new CryptoTI_Exception(131081, "Middleware is not installed!");
            }
        }
        if (middlewareFile != null) {
            middlewareFile = null;
        }
        this.deleteUnusedTmpFiles();
        try {
            this.tmpLibraryFile = File.createTempFile(NAME_PREFIX_PKCS11_LIBRARY, null);
        }
        catch (IOException e) {
            this.logger.error("Temporary File could not be created!", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "Temporary File could not be created!");
        }
        this.tmpLibraryFile.deleteOnExit();
        String _path = "/" + namePkcs11WrapperFile;
        this.logger.debug("Path P11 lib: " + _path);
        InputStream is = GTO_CTI_Module.class.getResourceAsStream(_path);
        if (is == null) {
            this.logger.error("No PKCS#11 Wrapper file has been found", 131075);
            throw new CryptoTI_Exception(131075, "No PKCS#11 Wrapper file has been found");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.tmpLibraryFile);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            out.flush();
            ((OutputStream)out).close();
            is.close();
        }
        catch (Exception e) {
            this.logger.error("Configuration File could not be loaded!", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "Configuration File could not be loaded!");
        }
        out = null;
        is = null;
        this.logger.debug("Path: " + this.tmpLibraryFile.getAbsolutePath());
        if (this.tmpLibraryFile.exists() && this.tmpLibraryFile.canRead()) {
            try {
                this.logger.debug("Temp Library Path: " + this.tmpLibraryFile.getCanonicalPath());
            }
            catch (IOException e) {
                this.logger.debug("Error: " + e.getMessage());
            }
            try {
                this.logger.debug("Path to Gemalto Library: " + pathGemaltoLibraryFile);
                this.pkcs11Module = Module.getInstance(pathGemaltoLibraryFile, this.tmpLibraryFile.getCanonicalPath());
            }
            catch (IOException e) {
                if (e.getMessage().indexOf("gclib.dll") > 0) {
                    this.logger.error("Gemalto Middleware Not Installed", 131081);
                    throw new CryptoTI_Exception(131081, "Gemalto Middleware Not Installed");
                }
                this.logger.error("PKCS#11 module could not be instantiated", (Throwable)e, 131074);
                throw new CryptoTI_Exception(131074, "PKCS#11 module could not be instantiated");
            }
            if (this.pkcs11Module != null) {
                this.logger.debug("PKCS#11 Module loaded successfully.");
            }
        } else {
            this.logger.error("The PKCS#11 library " + this.tmpLibraryFile.getAbsolutePath() + " does not exist or cannot be accessed.", 131081);
            throw new CryptoTI_Exception(131081, "CryptoTi Library cannot be found or accessed.");
        }
        if (this.pkcs11Module != null) {
            try {
                this.pkcs11Module.initialize(null);
                if (this.logger.isDebuggingEnabled()) {
                    this.logger.debug("Initialize of PKCS11 Module completed.");
                    this.logger.debug("Library Description: " + this.pkcs11Module.getInfo().getLibraryDescription());
                    this.logger.debug("CryptoKI version: " + this.pkcs11Module.getInfo().getCryptokiVersion());
                    this.logger.debug("Library version: " + this.pkcs11Module.getInfo().getLibraryVersion());
                    this.logger.debug("Manufacturer ID: " + this.pkcs11Module.getInfo().getManufacturerID());
                }
                this.isInitialised = true;
            }
            catch (TokenException ex) {
                if (ex.getMessage().equals("CKR_CRYPTOKI_ALREADY_INITIALIZED")) {
                    this.isInitialised = true;
                }
                this.logger.error("TokenException occurred", (Throwable)ex, 131074);
                throw new CryptoTI_Exception(131074, "TokenException occurred");
            }
        } else {
            this.logger.debug("PKCS#11 module is null.");
        }
        if (this.importLTGR) {
            try {
                String pathCaCerts = String.valueOf(System.getProperty("java.home")) + "/lib/security/cacerts".replace('/', File.separatorChar);
                File fileCaCerts = new File(pathCaCerts);
                if (fileCaCerts.isFile() && fileCaCerts.canRead() && fileCaCerts.canWrite()) {
                    String aliasLTGR = "luxtrust global root";
                    InputStream certificateFile = GTO_CTI_Module.class.getResourceAsStream(this.PATH_LTGR_CERTIFICATE);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    X509Certificate certificateLTGR = (X509Certificate)factory.generateCertificate(certificateFile);
                    certificateFile.close();
                    FileInputStream fisCaCerts = new FileInputStream(fileCaCerts);
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    String password = "changeit";
                    keystore.load(fisCaCerts, password.toCharArray());
                    fisCaCerts.close();
                    fisCaCerts = null;
                    PKIXParameters params = new PKIXParameters(keystore);
                    boolean found = false;
                    for (TrustAnchor ta : params.getTrustAnchors()) {
                        if (!ta.getTrustedCert().equals(certificateLTGR)) continue;
                        found = true;
                        break;
                    }
                    params = null;
                    Iterator<TrustAnchor> it = null;
                    if (!found) {
                        keystore.setCertificateEntry(aliasLTGR, certificateLTGR);
                        FileOutputStream os = new FileOutputStream(pathCaCerts);
                        keystore.store(os, password.toCharArray());
                        os.close();
                        os = null;
                    }
                    certificateLTGR = null;
                    certificateFile = null;
                    keystore = null;
                    params = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initialise(String pathToConfigurationFile) throws CryptoTI_Exception {
        this.logger.debug("INIT / Configuration Path");
        if (this.pkcs11Module != null) {
            this.logger.error("CryptoTI Module already initialised.", 131080);
            throw new CryptoTI_Exception(131080, "CryptoTI Module already initialised.");
        }
        InputStream is = null;
        if (pathToConfigurationFile == null) {
            is = GTO_CTI_Module.class.getResourceAsStream(this.PATH_CONFIG_FILE);
        } else {
            if (pathToConfigurationFile.equals("")) {
                this.logger.error("Path to configuration cannot be blank.", 131075);
                throw new CryptoTI_Exception(131075, "Path to configuration cannot be blank.");
            }
            try {
                is = new FileInputStream(new File(pathToConfigurationFile));
            }
            catch (FileNotFoundException e) {
                this.logger.error("Configuration File could not be found!", (Throwable)e, 131072);
                throw new CryptoTI_Exception(131072, "Configuration File could not be found");
            }
        }
        this.initialise(is);
        is = null;
    }

    public boolean isLoggedIn() throws CryptoTI_Exception {
        this.logger.debug("IS LOGGED IN /");
        return false;
    }

    public CryptoTI_Token[] listTokens() throws CryptoTI_Exception {
        Slot[] _slots;
        ArrayList<GTO_CTI_Token> _cards;
        block10: {
            this.logger.debug("LIST TOKENS /");
            if (this.pkcs11Module == null) {
                this.logger.error("CryptoTI Module not initialised.", 131079);
                throw new CryptoTI_Exception(131079, "CryptoTI Module not initialised.");
            }
            _cards = new ArrayList<GTO_CTI_Token>();
            _slots = this.pkcs11Module.getSlotList(true);
            if (_slots != null) break block10;
            return null;
        }
        try {
            this.logger.debug("Number of available slots: " + _slots.length);
            GTO_CTI_Token card = null;
            int slotIndex = 0;
            while (slotIndex < _slots.length) {
                Slot _slot = _slots[slotIndex];
                if (this.logger.isDebuggingEnabled()) {
                    this.logger.debug("Slot ID: " + _slot.getSlotID());
                    if (_slot.getSlotInfo() != null) {
                        this.logger.debug("Firmware Version: " + _slot.getSlotInfo().getFirmwareVersion());
                        this.logger.debug("Hardware Version: " + _slot.getSlotInfo().getHardwareVersion());
                        this.logger.debug("Manufacturer ID: " + _slot.getSlotInfo().getManufacturerID());
                        this.logger.debug("Slot Description: " + _slot.getSlotInfo().getSlotDescription());
                    } else {
                        this.logger.debug("SLOT INFO not available!");
                    }
                }
                this.logger.debug("Creating new Token");
                card = new GTO_CTI_Token(_slot.getToken(), this.multiLogin, this.checkPWDFormat, this.minimumPinLength, this.maximumPinLength, this.pinFormatSession);
                if (card != null && card.getInfo() != null) {
                    _cards.add(card);
                }
                ++slotIndex;
            }
            return _cards.toArray(new GTO_CTI_Token[_cards.size()]);
        }
        catch (TokenException e) {
            if (e.getMessage().equals("CKR_DEVICE_ERROR")) {
                this.logger.error("Device Error occurred", (Throwable)e, 131076);
                throw new CryptoTI_SessionException(131076, "Device Error occurred");
            }
            this.logger.error("Token Exception occurred", (Throwable)e, 131072);
            throw new CryptoTI_Exception(131072, "Token Exception occurred");
        }
    }

    public void logoff() throws CryptoTI_Exception {
        this.logger.debug("LOGOFF /");
        this.logger.warn("Logoff not supported!", 135168);
        throw new CryptoTI_NotSupportedException(135168, "Logoff not supported");
    }

    public boolean requiresPreAuthentication() throws CryptoTI_Exception {
        this.logger.debug("REQUIRES PRE AUTHENTICATION /");
        return false;
    }

    public void terminate() throws CryptoTI_Exception {
        this.logger.debug("TERMINATE /");
        if (this.pkcs11Module != null) {
            try {
                this.pkcs11Module.getPKCS11Module().C_Finalize(null);
                this.logger.debug("PKCS#11 module has been finalized!");
                this.pkcs11Module = null;
            }
            catch (Throwable e) {
                this.logger.warn(e, 0);
                throw new CryptoTI_Exception();
            }
        }
    }

    public void login(String userName, char[] password) throws CryptoTI_Exception {
        this.logger.debug("LOGIN /");
        this.logger.warn("Login not supported!", 135168);
        throw new CryptoTI_NotSupportedException(135168, "Login not supported");
    }

    public String getPINFormat() throws CryptoTI_Exception {
        this.logger.debug("GET PIN FORMAT /");
        return null;
    }

    public int hashCode() {
        this.logger.debug("HASHCODE /");
        int prime = 31;
        int result = 1;
        result = 31 * result + ("LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks." == null ? 0 : "LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks.".hashCode());
        result = 31 * result + ("LuxTrust S.A. // Gemalto" == null ? 0 : "LuxTrust S.A. // Gemalto".hashCode());
        result = 31 * result + (this.VERSION == null ? 0 : this.VERSION.hashCode());
        result = 31 * result + (this.pkcs11Module == null ? 0 : this.pkcs11Module.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        this.logger.debug("EQUALS /");
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_Module other = (GTO_CTI_Module)obj;
        if ("LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks." == null ? other.DESCRIPTION != null : !"LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks.".equals(other.DESCRIPTION)) {
            return false;
        }
        if ("LuxTrust S.A. // Gemalto" == null ? other.VENDOR != null : !"LuxTrust S.A. // Gemalto".equals(other.VENDOR)) {
            return false;
        }
        if (this.VERSION == null ? other.VERSION != null : !this.VERSION.equals(other.VERSION)) {
            return false;
        }
        return !(this.pkcs11Module == null ? other.pkcs11Module != null : !this.pkcs11Module.equals(other.pkcs11Module));
    }

    public String toString() {
        this.logger.debug("TO STRING /");
        StringBuffer sb = new StringBuffer();
        sb.append("LuxTrust CryptoTI Adapter for the Gemalto Classic Client supporting LuxTrust Smartcards and Signing Sticks.");
        sb.append(" ");
        sb.append(this.VERSION);
        sb.append(" ");
        sb.append("LuxTrust S.A. // Gemalto");
        return sb.toString();
    }

    private String[] getGemaltoInfoWin() {
        String version = null;
        String installDir = null;
        String programFilesPath = null;
        File iniFile = null;
        if (this.supportedOS.equals(SUPPORTED_OS_WINDOWS32)) {
            programFilesPath = System.getenv("ProgramFiles(x86)");
            if (!(programFilesPath != null && !programFilesPath.equals("") || (programFilesPath = System.getenv("ProgramW6432")) != null && !programFilesPath.equals("") || (programFilesPath = System.getenv("ProgramFiles")) != null && !programFilesPath.equals(""))) {
                return null;
            }
            String gemaltoIniPath = String.valueOf(programFilesPath) + File.separator + this.PATH_GEMALTO_VERSION_WINDOWS;
            iniFile = new File(gemaltoIniPath);
            if (!iniFile.exists()) {
                return null;
            }
        } else if (this.supportedOS.equals(SUPPORTED_OS_WINDOWS64)) {
            programFilesPath = System.getenv("ProgramFiles");
            if (programFilesPath == null || programFilesPath.equals("")) {
                return null;
            }
            String gemaltoIniPath = String.valueOf(programFilesPath) + File.separator + this.PATH_GEMALTO_VERSION_WINDOWS;
            iniFile = new File(gemaltoIniPath);
            if (!iniFile.exists()) {
                return null;
            }
        }
        version = this.getGemaltoVersion(iniFile, "version");
        installDir = this.getGemaltoVersion(iniFile, "installdir");
        if (version == null || installDir == null) {
            return null;
        }
        iniFile = null;
        return new String[]{version, installDir};
    }

    private String getGemaltoVersionMACOSX() {
        return this.getGemaltoVersion(new File(this.PATH_GEMALTO_VERSION_MAC), "version");
    }

    private String getGemaltoVersionLinux() {
        File folder = new File(this.PATH_FOLDER_GEMALTO_VERSION_LINUX);
        String _version = null;
        if (folder.isDirectory() && folder.canRead()) {
            File[] files = folder.listFiles(new PrefixFileFilter(NAME_PREFIX_LINUX_CLASSIC_CLIENT));
            if (files.length == 1) {
                String fileName = files[0].getName();
                _version = fileName.substring(NAME_PREFIX_LINUX_CLASSIC_CLIENT.length(), fileName.indexOf(".so"));
            }
            files = null;
            folder = null;
        }
        if (_version != null) {
            return LinuxDefinitions.gcLib2CC(_version);
        }
        return _version;
    }

    /*
     * Unable to fully structure code
     */
    private String getGemaltoVersion(File gemaltoVersionFile, String search) {
        _result = null;
        if (gemaltoVersionFile == null) {
            this.logger.debug("Version File cannot be null");
            return _result;
        }
        if (!gemaltoVersionFile.exists()) {
            this.logger.debug("Gemalto Version File does not exist!");
            return _result;
        }
        if (!gemaltoVersionFile.canRead()) {
            this.logger.debug("Gemalto Version File cannot be read!");
            return _result;
        }
        if (search == null || search.equals("")) {
            this.logger.debug("Search cannot be null");
            return _result;
        }
        scanner = null;
        try {
            scanner = new Scanner(gemaltoVersionFile);
            if (true) ** GOTO lbl33
        }
        catch (FileNotFoundException e) {
            this.logger.debug(e.getMessage());
            return _result;
        }
        do {
            searchFound = false;
            if (!scanner.nextLine().equals(this.PARAM_INI_FILE_GEMALTO_VERSION)) continue;
            while (!searchFound) {
                if (scanner.hasNext()) {
                    text = scanner.nextLine();
                    if (!text.startsWith(search)) continue;
                    _result = text.substring(text.indexOf("=") + 1);
                    searchFound = true;
                    continue;
                }
                return null;
            }
            break;
lbl33:
            // 2 sources

        } while (scanner.hasNext());
        scanner = null;
        return _result;
    }

    private String getGemaltoLibPathWin() {
        String[] classPath = System.getProperties().getProperty("java.library.path").split(";");
        String binFilePath = null;
        String[] stringArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            File checkFile = null;
            String _path = cp.toUpperCase();
            if (_path.indexOf("GEMALTO") > 0) {
                binFilePath = String.valueOf(cp) + File.separator + "gclib.dll";
                checkFile = new File(binFilePath);
                if (checkFile.exists()) {
                    checkFile = null;
                    return binFilePath;
                }
            } else if (_path.indexOf(NAME_GEMALTO_MIDDLEWARE_PATH_2) > 0) {
                binFilePath = String.valueOf(cp) + File.separator + "gclib.dll";
                checkFile = new File(binFilePath);
                if (checkFile.exists()) {
                    checkFile = null;
                    return binFilePath;
                }
            } else if (_path.indexOf(NAME_GEMALTO_MIDDLEWARE_PATH_3) > 0) {
                binFilePath = String.valueOf(cp) + File.separator + "gclib.dll";
                checkFile = new File(binFilePath);
                if (checkFile.exists()) {
                    checkFile = null;
                    return binFilePath;
                }
            } else if (_path.indexOf(NAME_GEMALTO_MIDDLEWARE_PATH_4) > 0 && (checkFile = new File(binFilePath = String.valueOf(cp) + File.separator + "gclib.dll")).exists()) {
                checkFile = null;
                return binFilePath;
            }
            binFilePath = null;
            checkFile = null;
            ++n2;
        }
        return binFilePath;
    }

    private String setVersion(String adapterVersion) {
        String version = null;
        String firstPart = this.VERSION.substring(0, this.VERSION.indexOf("//") + 3);
        String thirdPart = this.VERSION.substring(this.VERSION.lastIndexOf("//") - 1);
        version = String.valueOf(firstPart) + adapterVersion + thirdPart;
        return version;
    }

    private boolean isConfigValid(String regex, long minPinLength, long maxPinLength) {
        int endIndex = regex.length();
        int startIndex = regex.indexOf("{");
        boolean hasMore = true;
        if (startIndex > 0) {
            while (hasMore) {
                int tempIndex = regex.indexOf("{", startIndex + 1);
                if (tempIndex < 0) {
                    hasMore = false;
                    continue;
                }
                startIndex = tempIndex;
            }
        }
        return regex.substring(++startIndex, --endIndex).equals(String.valueOf(minPinLength) + "," + maxPinLength);
    }

    private void deleteUnusedTmpFiles() {
        File[] files;
        String _pathTmpFolder = System.getProperty("java.io.tmpdir");
        File folder = new File(_pathTmpFolder);
        File[] fileArray = files = folder.listFiles(new PrefixFileFilter(NAME_PREFIX_PKCS11_LIBRARY));
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File _file = fileArray[n2];
            if (_file.delete()) {
                this.logger.debug("File Deleted");
            } else {
                this.logger.debug("File Not Deleted: " + _file.getName());
            }
            ++n2;
        }
    }

    private static class LinuxDefinitions {
        private static final String CC_61_007 = "6.1 - 007";
        private static final String GCLIB_1_8_0 = "1.8.0";
        private static final HashMap<String, String> mapping = new HashMap();

        private LinuxDefinitions() {
        }

        public static String gcLib2CC(String gcLibVersion) {
            mapping.put(GCLIB_1_8_0, CC_61_007);
            if (mapping.get(gcLibVersion) == null) {
                return null;
            }
            return mapping.get(gcLibVersion);
        }
    }

    private static class PrefixFileFilter
    implements FilenameFilter {
        private String prefix = null;

        public PrefixFileFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.prefix);
        }
    }
}

