/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.gemalto.classic.cryptoti;

import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import lu.luxtrust.cryptoti.CryptoTI_Alias;
import lu.luxtrust.cryptoti.CryptoTI_X509;
import lu.luxtrust.cryptoti.exceptions.CryptoTI_Exception;
import lu.luxtrust.gemalto.classic.cryptoti.GTO_CTI_Certificate;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class GTO_CTI_X509
extends GTO_CTI_Certificate
implements CryptoTI_X509 {
    private Log logger = Logger.getLogger(GTO_CTI_X509.class);
    private X509Certificate x509Certificate = null;
    private CertificateFactory factory = null;
    private GTO_CTI_Certificate certificate = null;

    public GTO_CTI_X509(GTO_CTI_Certificate certificate) throws CryptoTI_Exception {
        if (certificate != null) {
            try {
                this.factory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream input = new ByteArrayInputStream(certificate.getEncoded());
                this.x509Certificate = (X509Certificate)this.factory.generateCertificate(input);
            }
            catch (CertificateException e) {
                this.logger.error("CertificateException occurred", (Throwable)e, 131072);
                throw new CryptoTI_Exception(131072, "CertificateException occurred");
            }
        } else {
            this.logger.error("Certificate cannot be null", 131075);
            throw new CryptoTI_Exception(131075, "Certificate cannot be null.");
        }
        this.certificate = certificate;
    }

    public GTO_CTI_X509() {
    }

    public String getIssuerDN() throws CryptoTI_Exception {
        this.logger.debug("GET ISSUER DN /");
        return this.x509Certificate.getIssuerX500Principal().getName();
    }

    public byte[] getIssuerPublicKeyHash() throws CryptoTI_Exception {
        this.logger.debug("GET ISSUER PUBLIC KEY HASH /");
        ByteArrayAttribute category = this.certificate.getCertificate().getHashOfIssuerPublicKey();
        if (category == null) {
            this.logger.warn("PKCS#11 attribute \"Issuer Public Key Hash\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Issuer Public Key Hash is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Issuer Public Key) ? " + category.isPresent());
            this.logger.debug("SENSITIVE (Issuer Public Key) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return category.getByteArrayValue();
        }
        this.logger.warn("PKCS#11 attribute \"Issuer Public Key Hash\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Issuer Public Key Hash is not available");
    }

    public byte[] getPublicKeyHash() throws CryptoTI_Exception {
        this.logger.debug("GET PUBLIC KEY HASH /");
        ByteArrayAttribute category = this.certificate.getCertificate().getHashOfSubjectPublicKey();
        if (category == null) {
            this.logger.warn("PKCS#11 attribute \"Issuer Public Key Hash\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "Public Key Hash is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (Public Key Hash) ? " + category.isPresent());
            this.logger.debug("SENSITIVE (Public Key Hash) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return category.getByteArrayValue();
        }
        this.logger.warn("PKCS#11 attribute \"Issuer Public Key Hash\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "Public Key Hash is not available");
    }

    public String getSerialNumber() throws CryptoTI_Exception {
        this.logger.debug("GET SERIAL NUMBER /");
        return this.x509Certificate.getSerialNumber().toString();
    }

    public String getSubjectDN() throws CryptoTI_Exception {
        this.logger.debug("GET SUBJECT DN /");
        return this.x509Certificate.getSubjectDN().getName();
    }

    public String getURL() throws CryptoTI_Exception {
        this.logger.debug("GET URL /");
        CharArrayAttribute category = this.certificate.getCertificate().getUrl();
        if (category == null) {
            this.logger.warn("PKCS#11 attribute \"URL\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "URL is not available");
        }
        if (this.logger.isDebuggingEnabled()) {
            this.logger.debug("PRESENT (URL) ? " + category.isPresent());
            this.logger.debug("SENSITIVE (URL) ? " + category.isSensitive());
        }
        if (category.isPresent()) {
            return new String(category.getCharArrayValue());
        }
        this.logger.warn("PKCS#11 attribute \"URL\" is not available", 131082);
        throw new CryptoTI_Exception(131082, "URL is not available");
    }

    public boolean isKU_CrlSign() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE CRL SIGN /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_CrlSign\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_CrlSign\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[6];
    }

    public boolean isKU_DataEncipherment() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE DATA ENCIPHERMENT /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_DataEncipherment\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_DataEncipherment\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[3];
    }

    public boolean isKU_DecipherOnly() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE DECIPHER ONLY /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_DecipherOnly\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_DecipherOnly\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[8];
    }

    public boolean isKU_DigitalSignature() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE DIGITAL SIGNATURE /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_DigitalSignature\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_DigitalSignature\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[0];
    }

    public boolean isKU_EncipherOnly() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE ENCIPHER ONLY /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_EncipherOnly\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_EncipherOnly\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[7];
    }

    public boolean isKU_KeyCertSign() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE CERTIFICATE SIGNING /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_KeyCertSign\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_KeyCertSign\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[5];
    }

    public boolean isKU_KeyEncipherment() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE KEY ENCIPHERMENT /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_KeyEncipherment\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_KeyEncipherment\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[2];
    }

    public boolean isKU_NonRepudiation() throws CryptoTI_Exception {
        this.logger.debug("IS KEY USAGE NON REPUDIATION /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_NonRepudiation\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_NonRepudiation\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[1];
    }

    public boolean isKU_hasKeyAgreement() throws CryptoTI_Exception {
        this.logger.debug("HAS KEY AGREEMENT /");
        if (this.x509Certificate.getKeyUsage() == null) {
            this.logger.warn("PKCS#11 attribute \"isKU_hasKeyAgreement\" is not available", 131082);
            throw new CryptoTI_Exception(131082, "PKCS#11 attribute \"isKU_hasKeyAgreement\" is not available");
        }
        return this.x509Certificate.getKeyUsage()[4];
    }

    public boolean isAuthority() throws CryptoTI_Exception {
        this.logger.debug("IS AUTHORITY /");
        return this.certificate.isAuthority();
    }

    public boolean isCategorySpecified() throws CryptoTI_Exception {
        this.logger.debug("IS CATEGORY SPECIFIED /");
        return this.certificate.isCategorySpecified();
    }

    public boolean isOtherEntity() throws CryptoTI_Exception {
        this.logger.debug("IS OTHER ENTITY /");
        return this.certificate.isOtherEntity();
    }

    public boolean isUserToken() throws CryptoTI_Exception {
        this.logger.debug("IS USER TOKEN /");
        return this.certificate.isUserToken();
    }

    public CryptoTI_Alias getAlias() throws CryptoTI_Exception {
        this.logger.debug("GET ALIAS /");
        return this.certificate.getAlias();
    }

    public byte[] getEncoded() throws CryptoTI_Exception {
        this.logger.debug("GET ENCODED /");
        return this.certificate.getEncoded();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        result = 31 * result + (this.x509Certificate == null ? 0 : this.x509Certificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTO_CTI_X509 other = (GTO_CTI_X509)obj;
        if (this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate)) {
            return false;
        }
        return !(this.x509Certificate == null ? other.x509Certificate != null : !this.x509Certificate.equals(other.x509Certificate));
    }

    public String toString() {
        return this.x509Certificate.toString();
    }
}

