/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.data.VR;

public class CommandUtils {
    public static final int SUCCESS = 0;
    public static final int PENDING = 65280;
    public static final int NORMAL = 0;
    public static final int HIGH = 1;
    public static final int LOW = 2;
    public static final int C_STORE_RQ = 1;
    public static final int C_STORE_RSP = 32769;
    public static final int C_GET_RQ = 16;
    public static final int C_GET_RSP = 32784;
    public static final int C_FIND_RQ = 32;
    public static final int C_FIND_RSP = 32800;
    public static final int C_MOVE_RQ = 33;
    public static final int C_MOVE_RSP = 32801;
    public static final int C_ECHO_RQ = 48;
    public static final int C_ECHO_RSP = 32816;
    public static final int N_EVENT_REPORT_RQ = 256;
    public static final int N_EVENT_REPORT_RSP = 33024;
    public static final int N_GET_RQ = 272;
    public static final int N_GET_RSP = 33040;
    public static final int N_SET_RQ = 288;
    public static final int N_SET_RSP = 33056;
    public static final int N_ACTION_RQ = 304;
    public static final int N_ACTION_RSP = 33072;
    public static final int N_CREATE_RQ = 320;
    public static final int N_CREATE_RSP = 33088;
    public static final int N_DELETE_RQ = 336;
    public static final int N_DELETE_RSP = 33104;
    public static final int C_CANCEL_RQ = 4095;
    private static final int RSP = 32768;
    public static final int NO_DATASET = 257;
    private static final String NL = System.getProperty("line.separator");
    private static int withDatasetType = 0;
    private static boolean includeUIDinRSP;

    public static boolean isResponse(DicomObject dcmobj) {
        return (dcmobj.getInt(256) & 0x8000) != 0;
    }

    public static boolean isCancelRQ(DicomObject dcmobj) {
        return dcmobj.getInt(256) == 4095;
    }

    public static DicomObject mkCStoreRQ(int msgId, String cuid, String iuid, int priority) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 1, withDatasetType);
        rq.putString(2, VR.UI, cuid);
        rq.putString(4096, VR.UI, iuid);
        rq.putInt(1792, VR.US, priority);
        return rq;
    }

    public static DicomObject mkCStoreRQ(int msgId, String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId) {
        DicomObject rq = CommandUtils.mkCStoreRQ(msgId, cuid, iuid, priority);
        rq.putString(4144, VR.AE, moveOriginatorAET);
        rq.putInt(4145, VR.US, moveOriginatorMsgId);
        return rq;
    }

    public static DicomObject mkCFindRQ(int msgId, String cuid, int priority) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 32, withDatasetType);
        rq.putString(2, VR.UI, cuid);
        rq.putInt(1792, VR.US, priority);
        return rq;
    }

    public static DicomObject mkCGetRQ(int msgId, String cuid, int priority) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 16, withDatasetType);
        rq.putString(2, VR.UI, cuid);
        rq.putInt(1792, VR.US, priority);
        return rq;
    }

    public static DicomObject mkCMoveRQ(int msgId, String cuid, int priority, String destination) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 33, withDatasetType);
        rq.putString(2, VR.UI, cuid);
        rq.putInt(1792, VR.US, priority);
        rq.putString(1536, VR.AE, destination);
        return rq;
    }

    public static DicomObject mkCCancelRQ(int msgId) {
        BasicDicomObject rq = new BasicDicomObject();
        rq.putInt(256, VR.US, 4095);
        rq.putInt(2048, VR.US, 257);
        rq.putInt(288, VR.US, msgId);
        return rq;
    }

    public static DicomObject mkCEchoRQ(int msgId, String cuid) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 48, 257);
        rq.putString(2, VR.UI, cuid);
        return rq;
    }

    public static DicomObject mkNEventReportRQ(int msgId, String cuid, String iuid, int eventTypeID, DicomObject data) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 256, data == null ? 257 : withDatasetType);
        rq.putString(2, VR.UI, cuid);
        rq.putString(4096, VR.UI, iuid);
        rq.putInt(4098, VR.US, eventTypeID);
        return rq;
    }

    public static DicomObject mkNGetRQ(int msgId, String cuid, String iuid, int[] tags) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 272, 257);
        rq.putString(3, VR.UI, cuid);
        rq.putString(4097, VR.UI, iuid);
        if (tags != null) {
            rq.putInts(4101, VR.AT, tags);
        }
        return rq;
    }

    public static DicomObject mkNSetRQ(int msgId, String cuid, String iuid) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 288, withDatasetType);
        rq.putString(3, VR.UI, cuid);
        rq.putString(4097, VR.UI, iuid);
        return rq;
    }

    public static DicomObject mkNActionRQ(int msgId, String cuid, String iuid, int actionTypeID, DicomObject data) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 304, data == null ? 257 : withDatasetType);
        rq.putString(3, VR.UI, cuid);
        rq.putString(4097, VR.UI, iuid);
        rq.putInt(4104, VR.US, actionTypeID);
        return rq;
    }

    public static DicomObject mkNCreateRQ(int msgId, String cuid, String iuid) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 320, withDatasetType);
        if (cuid != null) {
            rq.putString(2, VR.UI, cuid);
        }
        rq.putString(4096, VR.UI, iuid);
        return rq;
    }

    public static DicomObject mkNDeleteRQ(int msgId, String cuid, String iuid) {
        DicomObject rq = CommandUtils.mkRQ(msgId, 336, 257);
        rq.putString(3, VR.UI, cuid);
        rq.putString(4097, VR.UI, iuid);
        return rq;
    }

    private static DicomObject mkRQ(int msgId, int cmdfield, int datasetType) {
        BasicDicomObject rsp = new BasicDicomObject();
        rsp.putInt(272, VR.US, msgId);
        rsp.putInt(256, VR.US, cmdfield);
        rsp.putInt(2048, VR.US, datasetType);
        return rsp;
    }

    public static DicomObject mkRSP(DicomObject rq, int status) {
        BasicDicomObject rsp = new BasicDicomObject();
        rsp.putInt(256, VR.US, rq.getInt(256) | 0x8000);
        rsp.putInt(2304, VR.US, status);
        rsp.putInt(288, VR.US, rq.getInt(272));
        if (includeUIDinRSP) {
            String cuid = rq.getString(2);
            if (cuid == null) {
                cuid = rq.getString(3);
            }
            rsp.putString(2, VR.UI, cuid);
            String iuid = rq.getString(4096);
            if (iuid == null) {
                iuid = rq.getString(4097);
            }
            if (iuid != null) {
                rsp.putString(4096, VR.UI, iuid);
            }
        }
        return rsp;
    }

    public static boolean isIncludeUIDinRSP() {
        return includeUIDinRSP;
    }

    public static void setIncludeUIDinRSP(boolean includeUIDinRSP) {
        CommandUtils.includeUIDinRSP = includeUIDinRSP;
    }

    public static int getWithDatasetType() {
        return withDatasetType;
    }

    public static void setWithDatasetType(int withDatasetType) {
        if (withDatasetType == 257 || (withDatasetType & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("withDatasetType: " + Integer.toHexString(withDatasetType) + "H");
        }
        CommandUtils.withDatasetType = withDatasetType;
    }

    public static boolean hasDataset(DicomObject dcmobj) {
        return dcmobj.getInt(2048) != 257;
    }

    public static boolean isPending(DicomObject cmd) {
        return (cmd.getInt(2304) & 0xFF00) == 65280;
    }

    public static String toString(DicomObject cmd, int pcid, String tsuid) {
        UIDDictionary dict = UIDDictionary.getDictionary();
        StringBuilder sb = new StringBuilder(64);
        switch (cmd.getInt(256)) {
            case 1: {
                sb.append(cmd.getInt(272)).append(":C-STORE-RQ[pcid=").append(pcid).append(", prior=").append(cmd.getInt(1792)).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2))).append(NL).append("\tiuid=").append(cmd.getString(4096));
                if (!cmd.contains(4144)) break;
                sb.append(NL).append("\torig=").append(cmd.getString(4144)).append(">>").append(cmd.getInt(4145)).append(":C-MOVE-RQ");
                break;
            }
            case 16: {
                sb.append(cmd.getInt(272)).append(":C-GET-RQ[pcid=").append(pcid).append(", prior=").append(cmd.getInt(1792)).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2)));
                break;
            }
            case 32: {
                sb.append(cmd.getInt(272)).append(":C-FIND-RQ[pcid=").append(pcid).append(", prior=").append(cmd.getInt(1792)).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2)));
                break;
            }
            case 33: {
                sb.append(cmd.getInt(272)).append(":C-MOVE-RQ[pcid=").append(pcid).append(", aet=").append(dict.prompt(cmd.getString(1536))).append(", prior=").append(cmd.getInt(1792)).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2)));
                break;
            }
            case 48: {
                sb.append(cmd.getInt(272)).append(":C-ECHO-RQ[pcid=").append(pcid).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2)));
                break;
            }
            case 256: {
                sb.append(cmd.getInt(272)).append(":N-EVENT-REPORT-RQ[pcid=").append(pcid).append(", eventID=").append(cmd.getInt(4098)).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2))).append(NL).append("\tiuid=").append(cmd.getString(4096));
                break;
            }
            case 272: {
                sb.append(cmd.getInt(272)).append(":N-GET-RQ[pcid=").append(pcid);
                if (cmd.contains(4101)) {
                    sb.append(NL).append("\ttags=").append(cmd.get(4101).getValueAsString(null, 64));
                }
                sb.append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(3))).append(NL).append("\tiuid=").append(cmd.getString(4097));
                break;
            }
            case 288: {
                sb.append(cmd.getInt(272)).append(":N-SET-RQ[pcid=").append(pcid).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(3))).append(NL).append("\tiuid=").append(cmd.getString(4097));
                break;
            }
            case 304: {
                sb.append(cmd.getInt(272)).append(":N-ACTION-RQ[pcid=").append(pcid).append(", actionID=").append(cmd.getInt(4104)).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(3))).append(NL).append("\tiuid=").append(cmd.getString(4097));
                break;
            }
            case 320: {
                sb.append(cmd.getInt(272)).append(":N-CREATE-RQ[pcid=").append(pcid).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2))).append(NL).append("\tiuid=").append(cmd.getString(4096));
                break;
            }
            case 336: {
                sb.append(cmd.getInt(272)).append(":N-DELETE-RQ[pcid=").append(pcid).append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(3))).append(NL).append("\tiuid=").append(cmd.getString(4097));
                break;
            }
            case 4095: {
                sb.append(cmd.getInt(288)).append(":C-CANCEL-RQ[pcid=").append(pcid);
                break;
            }
            case 32769: {
                sb.append(cmd.getInt(288)).append(":C-STORE-RSP[pcid=").append(pcid);
                break;
            }
            case 32784: {
                sb.append(cmd.getInt(288));
                sb.append(":C-GET-RSP[pcid=").append(pcid).append(", remaining=").append(cmd.getString(4128)).append(", completed=").append(cmd.getString(4129)).append(", failed=").append(cmd.getString(4130)).append(", warning=").append(cmd.getString(4131));
                break;
            }
            case 32800: {
                sb.append(cmd.getInt(288)).append(":C-FIND-RSP[pcid=").append(pcid);
                break;
            }
            case 32801: {
                sb.append(cmd.getInt(288)).append(":C-MOVE-RSP[pcid=").append(pcid).append(", remaining=").append(cmd.getString(4128)).append(", completed=").append(cmd.getString(4129)).append(", failed=").append(cmd.getString(4130)).append(", warning=").append(cmd.getString(4131));
                break;
            }
            case 32816: {
                sb.append(cmd.getInt(288)).append(":C-ECHO-RSP[pcid=").append(pcid);
                break;
            }
            case 33024: {
                sb.append(cmd.getInt(288)).append(":N-EVENT-REPORT-RSP[pcid=").append(pcid).append(", eventID=").append(cmd.getString(4098));
                break;
            }
            case 33040: {
                sb.append(cmd.getInt(288)).append(":N-GET-RSP[pcid=").append(pcid);
                break;
            }
            case 33056: {
                sb.append(cmd.getInt(288)).append(":N-SET-RSP[pcid=").append(pcid);
                break;
            }
            case 33072: {
                sb.append(cmd.getInt(288)).append(":N-ACTION-RSP[pcid=").append(pcid).append(", actionID=").append(cmd.getString(4104));
                break;
            }
            case 33088: {
                sb.append(cmd.getInt(288)).append(":N-CREATE-RSP[pcid=").append(pcid);
                break;
            }
            case 33104: {
                sb.append(cmd.getInt(288)).append(":N-DELETE-RSP[pcid=").append(pcid);
                break;
            }
            default: {
                throw new IllegalArgumentException("CommandField:" + cmd.get(256));
            }
        }
        if (CommandUtils.isResponse(cmd)) {
            sb.append(", status=").append(Integer.toHexString(cmd.getInt(2304))).append('H');
            if (cmd.contains(2307)) {
                sb.append(", errorID=").append(cmd.getInt(2307));
            }
            if (cmd.contains(2306)) {
                sb.append(NL).append("\terror=").append(cmd.getString(2306));
            }
            if (cmd.contains(2)) {
                sb.append(NL).append("\tcuid=").append(dict.prompt(cmd.getString(2)));
            }
            if (cmd.contains(4096)) {
                sb.append(NL).append("\tiuid=").append(cmd.getString(4096));
            }
        }
        if (CommandUtils.hasDataset(cmd)) {
            sb.append(NL).append("\tts=").append(dict.prompt(tsuid));
        }
        sb.append(']');
        return sb.toString();
    }
}

