/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.CommandUtils;

public class DicomServiceException
extends IOException {
    private static final long serialVersionUID = -5858536886871974350L;
    final DicomObject rsp;
    private DicomObject data;

    public DicomServiceException(DicomObject rq, int status) {
        this.rsp = CommandUtils.mkRSP(rq, status);
    }

    public DicomServiceException(DicomObject rq, int status, String message) {
        super(message);
        this.rsp = CommandUtils.mkRSP(rq, status);
        if (message != null && message.length() > 64) {
            message = message.substring(0, 64);
        }
        this.setErrorComment(message);
    }

    public void setErrorComment(String val) {
        this.rsp.putString(2306, VR.LO, val);
    }

    public void setErrorID(int val) {
        this.rsp.putInt(2307, VR.US, val);
    }

    public final DicomObject getCommand() {
        return this.rsp;
    }

    public final DicomObject getDataset() {
        return this.data;
    }

    public final void setData(DicomObject data) {
        this.data = data;
    }
}

