/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.io.DicomCodingException;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.pdu.AAbort;
import org.dcm4che2.net.pdu.AAssociateAC;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.pdu.AAssociateRQ;
import org.dcm4che2.net.pdu.AAssociateRQAC;
import org.dcm4che2.net.pdu.CommonExtendedNegotiation;
import org.dcm4che2.net.pdu.ExtendedNegotiation;
import org.dcm4che2.net.pdu.PresentationContext;
import org.dcm4che2.net.pdu.RoleSelection;
import org.dcm4che2.net.pdu.UserIdentityAC;
import org.dcm4che2.net.pdu.UserIdentityRQ;
import org.dcm4che2.util.CloseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDUDecoder
extends PDVInputStream {
    static Logger log = LoggerFactory.getLogger(PDUDecoder.class);
    private static final int DEF_PDU_LEN = 16384;
    private static final int MAX_PDU_LEN = 0x1000000;
    private final Association as;
    private final InputStream in;
    private final Thread th;
    private byte[] buf = new byte[16390];
    private int pos;
    private int pdutype;
    private int pdulen;
    private int pcid = -1;
    private int pdvmch;
    private int pdvend;

    public PDUDecoder(Association as, InputStream in) {
        this.as = as;
        this.in = in;
        this.th = Thread.currentThread();
    }

    private void readFully(int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.in.read(this.buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private int remaining() {
        return this.pdulen + 6 - this.pos;
    }

    private boolean hasRemaining() {
        return this.pos < this.pdulen + 6;
    }

    int get() {
        if (!this.hasRemaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[this.pos++] & 0xFF;
    }

    void get(byte[] b, int off, int len) {
        if (len > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    void skip(int len) {
        if (len > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        this.pos += len;
    }

    private int getUnsignedShort() {
        return this.get() << 8 | this.get();
    }

    private int getInt() {
        return this.get() << 24 | this.get() << 16 | this.get() << 8 | this.get();
    }

    public void nextPDU() throws IOException {
        block18: {
            block17: {
                log.debug("{} waiting for PDU", (Object)this.as);
                if (this.th != Thread.currentThread()) {
                    throw new IllegalStateException("Entered by wrong thread");
                }
                this.readFully(0, 10);
                this.pos = 0;
                this.pdutype = this.get();
                this.get();
                this.pdulen = this.getInt();
                if (this.pdutype < 1 || this.pdutype > 7) {
                    log.warn(this.as.toString() + " >> unrecognized PDU[type=" + this.pdutype + ", len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "]");
                    throw new AAbort(2, 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug(this.as.toString() + " >> PDU[type=" + this.pdutype + ", len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "]");
                }
                if (this.pdutype != 3 && this.pdutype != 5 && this.pdutype != 6 && this.pdutype != 7) break block17;
                if (this.pdulen != 4) {
                    log.warn(this.as.toString() + ": Invalid length of PDU[type=" + this.pdutype + "len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "]");
                    throw new AAbort(2, 6);
                }
                switch (this.pdutype) {
                    case 3: {
                        this.get();
                        this.as.receivedAssociateRJ(new AAssociateRJ(this.get(), this.get(), this.get()));
                        break block18;
                    }
                    case 5: {
                        this.as.receivedReleaseRQ();
                        break block18;
                    }
                    case 6: {
                        this.as.receivedReleaseRP();
                        break block18;
                    }
                    case 7: {
                        this.get();
                        this.get();
                        this.as.receivedAbort(new AAbort(this.get(), this.get()));
                        break block18;
                    }
                    default: {
                        throw new RuntimeException("Unexpected pdutype:" + this.pdutype);
                    }
                }
            }
            if (this.pdulen < 0 || this.pdulen > 0x1000000) {
                log.warn(this.as.toString() + ": Length of PDU[type=" + this.pdutype + "[len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "] exceeds " + 0x1000000 + " limit");
                log.warn(this.as.toString() + ": Length of PDU[type=" + this.pdutype + "[len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "] exceeds " + 0x1000000 + " limit");
                throw new AAbort(2, 6);
            }
            if (6 + this.pdulen > this.buf.length) {
                byte[] tmp = new byte[6 + this.pdulen];
                System.arraycopy(this.buf, 0, tmp, 0, 10);
                this.buf = tmp;
            }
            this.readFully(10, this.pdulen - 4);
            switch (this.pdutype) {
                case 1: {
                    this.as.receivedAssociateRQ((AAssociateRQ)this.decode(new AAssociateRQ()));
                    break;
                }
                case 2: {
                    this.as.receivedAssociateAC((AAssociateAC)this.decode(new AAssociateAC()));
                    break;
                }
                case 4: {
                    log.debug("{} >> P-DATA_TF[len={}]", (Object)this.as, (Object)new Integer(this.pdulen));
                    this.as.receivedPDataTF();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected pdutype:" + this.pdutype);
                }
            }
        }
    }

    private byte[] decodeBytes() {
        return this.decodeBytes(this.getUnsignedShort());
    }

    private byte[] decodeBytes(int len) {
        byte[] bs = new byte[len];
        this.get(bs, 0, len);
        return bs;
    }

    private AAssociateRQAC decode(AAssociateRQAC rqac) throws IOException {
        try {
            rqac.setProtocolVersion(this.getUnsignedShort());
            this.get();
            this.get();
            rqac.setCalledAET(this.decodeASCIIString(16).trim());
            rqac.setCallingAET(this.decodeASCIIString(16).trim());
            rqac.setReservedBytes(this.decodeBytes(32));
            while (this.pos < this.pdulen) {
                this.decodeItem(rqac);
            }
            if (this.pos != this.pdulen + 6) {
                log.warn(this.as.toString() + ": Invalid length of PDU[type=" + this.pdutype + ", len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "]");
                throw new AAbort(2, 6);
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.warn(this.as.toString() + ": Invalid length of PDU[type=" + this.pdutype + ", len=" + ((long)this.pdulen & 0xFFFFFFFFL) + "]");
            throw new AAbort(2, 6);
        }
        return rqac;
    }

    private String decodeASCIIString() {
        return this.decodeASCIIString(this.getUnsignedShort());
    }

    private String decodeASCIIString(int len) {
        try {
            int len0;
            if (this.pos + len > this.pdulen + 6) {
                throw new IndexOutOfBoundsException();
            }
            for (len0 = len; len0 > 0 && this.buf[this.pos + len0 - 1] == 0; --len0) {
            }
            String s = new String(this.buf, this.pos, len0, "US-ASCII");
            this.pos += len;
            return s;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unreachable; US-ASCII is always available", e);
        }
    }

    private void decodeItem(AAssociateRQAC rqac) throws AAbort {
        int itemType = this.get();
        this.get();
        int itemLength = this.getUnsignedShort();
        switch (itemType) {
            case 16: {
                rqac.setApplicationContext(this.decodeASCIIString(itemLength));
                break;
            }
            case 32: 
            case 33: {
                rqac.addPresentationContext(this.decodePC(itemLength));
                break;
            }
            case 80: {
                this.decodeUserInfo(itemLength, rqac);
                break;
            }
            default: {
                this.skip(itemLength);
            }
        }
    }

    private PresentationContext decodePC(int itemLength) {
        PresentationContext pc = new PresentationContext();
        pc.setPCID(this.get());
        this.get();
        pc.setResult(this.get() & 0xFF);
        this.get();
        int endpos = this.pos + itemLength - 4;
        while (this.pos < endpos) {
            this.decodePCSubItem(pc);
        }
        return pc;
    }

    private void decodePCSubItem(PresentationContext pc) {
        int itemType = this.get() & 0xFF;
        this.get();
        int itemLength = this.getUnsignedShort();
        switch (itemType) {
            case 48: {
                pc.setAbstractSyntax(this.decodeASCIIString(itemLength));
                break;
            }
            case 64: {
                pc.addTransferSyntax(this.decodeASCIIString(itemLength));
                break;
            }
            default: {
                this.skip(itemLength);
            }
        }
    }

    private void decodeUserInfo(int itemLength, AAssociateRQAC rqac) throws AAbort {
        int endpos = this.pos + itemLength;
        while (this.pos < endpos) {
            this.decodeUserInfoSubItem(rqac);
        }
    }

    private void decodeUserInfoSubItem(AAssociateRQAC rqac) throws AAbort {
        int itemType = this.get();
        this.get();
        int itemLength = this.getUnsignedShort();
        switch (itemType) {
            case 81: {
                rqac.setMaxPDULength(this.getInt());
                break;
            }
            case 82: {
                rqac.setImplClassUID(this.decodeASCIIString(itemLength));
                break;
            }
            case 83: {
                rqac.setMaxOpsInvoked(this.getUnsignedShort());
                rqac.setMaxOpsPerformed(this.getUnsignedShort());
                break;
            }
            case 84: {
                rqac.addRoleSelection(this.decodeRoleSelection(itemLength));
                break;
            }
            case 85: {
                rqac.setImplVersionName(this.decodeASCIIString(itemLength));
                break;
            }
            case 86: {
                rqac.addExtendedNegotiation(this.decodeExtendedNegotiation(itemLength));
                break;
            }
            case 87: {
                rqac.addCommonExtendedNegotiation(this.decodeCommonExtendedNegotiation(itemLength));
                break;
            }
            case 88: 
            case 89: {
                if (rqac instanceof AAssociateRQ) {
                    ((AAssociateRQ)rqac).setUserIdentity(this.decodeUserIdentityRQ(itemLength));
                    break;
                }
                ((AAssociateAC)rqac).setUserIdentity(this.decodeUserIdentityAC(itemLength));
                break;
            }
            default: {
                this.skip(itemLength);
            }
        }
    }

    private RoleSelection decodeRoleSelection(int itemLength) {
        RoleSelection rs = new RoleSelection();
        rs.setSOPClassUID(this.decodeASCIIString());
        rs.setSCU(this.get() != 0);
        rs.setSCP(this.get() != 0);
        return rs;
    }

    private ExtendedNegotiation decodeExtendedNegotiation(int itemLength) {
        ExtendedNegotiation extNeg = new ExtendedNegotiation();
        int uidLength = this.getUnsignedShort();
        extNeg.setSOPClassUID(this.decodeASCIIString(uidLength));
        extNeg.setInformation(this.decodeBytes(itemLength - uidLength - 2));
        return extNeg;
    }

    private CommonExtendedNegotiation decodeCommonExtendedNegotiation(int itemLength) throws AAbort {
        int endPos = this.pos + itemLength;
        CommonExtendedNegotiation extNeg = new CommonExtendedNegotiation();
        extNeg.setSOPClassUID(this.decodeASCIIString(this.getUnsignedShort()));
        extNeg.setServiceClassUID(this.decodeASCIIString(this.getUnsignedShort()));
        this.decodeRelatedGeneralSOPClassUIDs(this.getUnsignedShort(), extNeg);
        if (this.pos != endPos) {
            log.warn(this.as.toString() + ": Mismatch of encoded (" + itemLength + ") with actual (" + (itemLength + this.pos - itemLength) + ") Common Extended Negotiation item length");
            throw new AAbort(2, 6);
        }
        return extNeg;
    }

    private void decodeRelatedGeneralSOPClassUIDs(int totlen, CommonExtendedNegotiation extNeg) {
        int endPos = this.pos + totlen;
        while (this.pos < endPos) {
            extNeg.addRelatedGeneralSOPClassUID(this.decodeASCIIString());
        }
    }

    private UserIdentityRQ decodeUserIdentityRQ(int itemLength) throws AAbort {
        int endPos = this.pos + itemLength;
        UserIdentityRQ user = new UserIdentityRQ();
        user.setUserIdentityType(this.get() & 0xFF);
        user.setPositiveResponseRequested(this.get() != 0);
        user.setPrimaryField(this.decodeBytes());
        user.setSecondaryField(this.decodeBytes());
        if (this.pos != endPos) {
            log.warn(this.as.toString() + ": Mismatch of encoded (" + itemLength + ") with actual (" + (itemLength + this.pos - itemLength) + ") User Identity item length");
            throw new AAbort(2, 6);
        }
        return user;
    }

    private UserIdentityAC decodeUserIdentityAC(int itemLength) throws AAbort {
        int endPos = this.pos + itemLength;
        UserIdentityAC user = new UserIdentityAC();
        user.setServerResponse(this.decodeBytes());
        if (this.pos != endPos) {
            log.warn(this.as.toString() + ": Mismatch of encoded (" + itemLength + ") with actual (" + (itemLength + this.pos - itemLength) + ") User Identity item length");
            throw new AAbort(2, 6);
        }
        return user;
    }

    public void decodeDIMSE() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (this.pcid != -1) {
            return;
        }
        this.nextPDV(1, -1);
        PresentationContext pc = this.as.getAssociateAC().getPresentationContext(this.pcid);
        if (pc == null) {
            log.warn(this.as.toString() + ": No Presentation Context with given ID - " + this.pcid);
            throw new AAbort();
        }
        if (!pc.isAccepted()) {
            log.warn(this.as.toString() + ": No accepted Presentation Context with given ID - " + this.pcid);
            throw new AAbort();
        }
        String tsuid = pc.getTransferSyntax();
        DicomObject cmd = this.readDicomObject(TransferSyntax.ImplicitVRLittleEndian);
        if (log.isInfoEnabled()) {
            log.info(this.as.toString() + " >> " + CommandUtils.toString(cmd, this.pcid, tsuid));
        }
        if (log.isDebugEnabled()) {
            log.debug("Command:\n" + cmd);
        }
        if (CommandUtils.hasDataset(cmd)) {
            this.nextPDV(0, this.pcid);
            if (CommandUtils.isResponse(cmd)) {
                DicomObject data = this.readDicomObject(TransferSyntax.valueOf((String)tsuid));
                if (log.isDebugEnabled()) {
                    log.debug("Dataset:\n" + data);
                }
                this.as.onDimseRSP(cmd, data);
            } else {
                this.as.onDimseRQ(this.pcid, cmd, this, tsuid);
                long skipped = this.skipAll();
                if (log.isDebugEnabled() && skipped > 0L) {
                    log.debug(this.as.toString() + ": Service User did not consume " + skipped + " bytes of DIMSE data.");
                }
            }
        } else if (CommandUtils.isResponse(cmd)) {
            this.as.onDimseRSP(cmd, null);
        } else {
            this.as.onDimseRQ(this.pcid, cmd, null, null);
        }
        this.pcid = -1;
    }

    public DicomObject readDataset() throws IOException {
        PresentationContext pc = this.as.getAssociateAC().getPresentationContext(this.pcid);
        String tsuid = pc.getTransferSyntax();
        return this.readDicomObject(TransferSyntax.valueOf((String)tsuid));
    }

    private DicomObject readDicomObject(TransferSyntax ts) throws IOException {
        BasicDicomObject dcm = new BasicDicomObject();
        DicomInputStream din = new DicomInputStream((InputStream)this, ts);
        try {
            din.readDicomObject((DicomObject)dcm, -1);
        }
        catch (DicomCodingException e) {
            log.warn(this.as.toString() + ": Failed to decode dicom object: " + e.getMessage());
            throw new AAbort();
        }
        finally {
            CloseUtils.safeClose((Closeable)din);
        }
        return dcm;
    }

    private void nextPDV(int command, int pcid1) throws IOException {
        if (!this.hasRemaining()) {
            this.nextPDU();
            if (this.pdutype != 4) {
                log.warn(this.as.toString() + ": Expected P-DATA-TF but received PDU[type=" + this.pdutype + ", len=" + this.pdulen + "]");
                throw new AAbort();
            }
        }
        if (this.remaining() < 6) {
            log.warn(this.as.toString() + ": PDV does not fit in remaining " + this.remaining() + " bytes of P-DATA_TF[len=" + this.pdulen + "]");
            throw new AAbort();
        }
        int pdvlen = this.getInt();
        this.pdvend = this.pos + pdvlen;
        if (pdvlen < 2 || pdvlen > this.remaining()) {
            log.warn(this.as.toString() + ": Invalid PDV item length: " + pdvlen);
            throw new AAbort();
        }
        this.pcid = this.get();
        this.pdvmch = this.get();
        if (log.isDebugEnabled()) {
            log.debug(this.as.toString() + " >> PDV[len = " + pdvlen + ", pcid = " + this.pcid + ", mch = " + this.pdvmch + "]");
        }
        if ((this.pdvmch & 1) != command) {
            log.warn(this.as.toString() + (command == 0 ? ": Expected Data but received Command PDV" : ": Expected Command but received Data PDV"));
            throw new AAbort();
        }
        if (pcid1 != -1 && this.pcid != pcid1) {
            log.warn(this.as.toString() + ": Expected PDV with pcid: " + pcid1 + " but received with pcid: " + this.pcid);
            throw new AAbort();
        }
    }

    private boolean isEOF() throws IOException {
        while (this.pos == this.pdvend) {
            if ((this.pdvmch & 2) != 0) {
                return true;
            }
            try {
                this.nextPDV(this.pdvmch & 1, this.pcid);
            }
            catch (AAbort e) {
                this.as.abort(e);
                throw e;
            }
        }
        return false;
    }

    public int read() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (this.isEOF()) {
            return -1;
        }
        return this.get();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (this.isEOF()) {
            return -1;
        }
        int read = Math.min(len, this.pdvend - this.pos);
        this.get(b, off, read);
        return read;
    }

    public final int available() {
        return this.pdvend - this.pos;
    }

    public long skip(long n) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        if (n <= 0L || this.isEOF()) {
            return 0L;
        }
        int skipped = (int)Math.min(n, (long)(this.pdvend - this.pos));
        this.skip(skipped);
        return skipped;
    }

    public void close() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        this.skipAll();
    }

    public long skipAll() throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        long n = 0L;
        while (!this.isEOF()) {
            n += (long)(this.pdvend - this.pos);
            this.pos = this.pdvend;
        }
        return n;
    }

    public void copyTo(OutputStream out, int length) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        int remaining = length;
        while (remaining > 0) {
            if (this.isEOF()) {
                throw new EOFException("remaining: " + remaining);
            }
            int read = Math.min(remaining, this.pdvend - this.pos);
            out.write(this.buf, this.pos, read);
            remaining -= read;
            this.pos += read;
        }
    }

    public void copyTo(OutputStream out) throws IOException {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
        while (!this.isEOF()) {
            out.write(this.buf, this.pos, this.pdvend - this.pos);
            this.pos = this.pdvend;
        }
    }
}

