/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net.pdu;

import java.io.IOException;

public class AAssociateRJ
extends IOException {
    private static final long serialVersionUID = 7878137718648065429L;
    public static final int RESULT_REJECTED_PERMANENT = 1;
    public static final int RESULT_REJECTED_TRANSIENT = 2;
    public static final int SOURCE_SERVICE_USER = 1;
    public static final int SOURCE_SERVICE_PROVIDER_ACSE = 2;
    public static final int SOURCE_SERVICE_PROVIDER_PRES = 3;
    public static final int REASON_NO_REASON_GIVEN = 1;
    public static final int REASON_APP_CTX_NAME_NOT_SUPPORTED = 2;
    public static final int REASON_CALLING_AET_NOT_RECOGNIZED = 3;
    public static final int REASON_CALLED_AET_NOT_RECOGNIZED = 7;
    public static final int REASON_PROTOCOL_VERSION_NOT_SUPPORTED = 2;
    public static final int REASON_TEMPORARY_CONGESTION = 1;
    public static final int REASON_LOCAL_LIMIT_EXCEEDED = 2;
    private static final Lookup[] DESCRIPTIONS = new Lookup[]{new Lookup(1, 1, "no-reason-given"), new Lookup(1, 2, "application-context-name-not-supported"), new Lookup(1, 3, "calling-AE-title-not-recognized"), new Lookup(1, 7, "called-AE-title-not-recognized"), new Lookup(2, 1, "no-reason-given"), new Lookup(2, 2, "protocol-version-not-supported"), new Lookup(3, 1, "temporary-congestion"), new Lookup(3, 2, "local-limit-exceeded")};
    private final int result;
    private final int source;
    private final int reason;

    public AAssociateRJ(int result, int source, int reason) {
        super(AAssociateRJ.createDescription(result, source, reason));
        this.result = result;
        this.source = source;
        this.reason = reason;
    }

    public final int getResult() {
        return this.result;
    }

    public final int getSource() {
        return this.source;
    }

    public final int getReason() {
        return this.reason;
    }

    private static String createDescription(int result, int source, int reason) {
        StringBuilder msg = new StringBuilder();
        msg.append("A-ASSOCIATE-RJ[result=");
        msg.append(result);
        msg.append(", source=");
        msg.append(source);
        msg.append(", reason=");
        msg.append(reason);
        msg.append("]: ");
        if (result == 1) {
            msg.append("permanent ");
        } else if (result == 2) {
            msg.append("transient ");
        }
        for (Lookup desc : DESCRIPTIONS) {
            if (!desc.matches(source, reason)) continue;
            msg.append(desc.getDescription());
            return msg.toString();
        }
        msg.append("reserved");
        return msg.toString();
    }

    private static class Lookup {
        private int source;
        private int reason;
        private String description;

        public Lookup(int source, int reason, String desc) {
            this.source = source;
            this.reason = reason;
            this.description = desc;
        }

        public boolean matches(int sourceIn, int reasonIn) {
            return this.source == sourceIn && this.reason == reasonIn;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

