/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.unified.interfaces;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.transaction.Transaction;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.PayloadKey;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.invocation.unified.interfaces.UnifiedInvokerProxy;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.serialization.IMarshalledValue;

public class UnifiedInvokerHAProxy
extends UnifiedInvokerProxy {
    static final long serialVersionUID = -4813929243402349966L;
    private LoadBalancePolicy loadBalancePolicy;
    private String proxyFamilyName = null;
    private FamilyClusterInfo familyClusterInfo = null;
    public static final WeakHashMap txFailoverAuthorizations = new WeakHashMap();

    public UnifiedInvokerHAProxy() {
        this.log.debug("UnifiedInvokerHAProxy constructor called with no arguments.");
        this.setSubSystem("invokerha");
    }

    public UnifiedInvokerHAProxy(InvokerLocator locator, boolean isStrictRMIException, ArrayList targets, LoadBalancePolicy policy, String proxyFamilyName, long viewId) {
        super(locator, isStrictRMIException);
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget(proxyFamilyName, targets, viewId);
        this.loadBalancePolicy = policy;
        this.proxyFamilyName = proxyFamilyName;
        this.setSubSystem("invokerha");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean txContextAllowsFailover(Invocation invocation) {
        Transaction tx = invocation.getTransaction();
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                return !txFailoverAuthorizations.containsKey(tx);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationHasReachedAServer(Invocation invocation) {
        Transaction tx = invocation.getTransaction();
        if (tx != null) {
            Transaction transaction = tx;
            synchronized (transaction) {
                txFailoverAuthorizations.put(tx, null);
            }
        }
    }

    protected int totalNumberOfTargets() {
        if (this.familyClusterInfo != null) {
            return this.familyClusterInfo.getTargets().size();
        }
        return 0;
    }

    protected void resetView() {
        this.familyClusterInfo.resetView();
    }

    protected Client getClient(Invocation invocationBasedRouting) throws MalformedURLException {
        Object target = this.loadBalancePolicy.chooseTarget(this.familyClusterInfo, invocationBasedRouting);
        InvokerLocator targetLocator = (InvokerLocator)target;
        if (!this.getLocator().equals((Object)targetLocator)) {
            this.init(targetLocator);
        }
        return this.getClient();
    }

    public Object invoke(Invocation invocation) throws Exception {
        int failoverCounter = 0;
        invocation.setValue("FAILOVER_COUNTER", new Integer(failoverCounter), PayloadKey.AS_IS);
        Object response = null;
        GenericClusteringException lastException = null;
        boolean failoverAuthorized = true;
        while (this.familyClusterInfo.getTargets() != null && this.familyClusterInfo.getTargets().size() > 0 && failoverAuthorized) {
            boolean definitivlyRemoveNodeOnFailure = true;
            try {
                invocation.setValue("CLUSTER_VIEW_ID", new Long(this.familyClusterInfo.getCurrentViewId()));
                this.log.debug("Client cluster view id: " + this.familyClusterInfo.getCurrentViewId());
                this.log.debug(this.printPossibleTargets());
                Client clientInstance = this.getClient(invocation);
                this.log.debug("Making invocation on " + clientInstance.getInvoker().getLocator());
                response = clientInstance.invoke((Object)invocation, null);
                HARMIResponse haResponse = null;
                if (response instanceof Exception) {
                    this.log.debug("Invocation returened exception: " + response);
                    if (response instanceof GenericClusteringException) {
                        GenericClusteringException gcex;
                        lastException = gcex = (GenericClusteringException)response;
                        if (gcex.getCompletionStatus() == 1) {
                            if (this.totalNumberOfTargets() >= failoverCounter && !gcex.isDefinitive()) {
                                definitivlyRemoveNodeOnFailure = false;
                            }
                            this.removeDeadTarget(this.getLocator());
                            if (!definitivlyRemoveNodeOnFailure) {
                                this.resetView();
                            }
                            failoverAuthorized = this.txContextAllowsFailover(invocation);
                            invocation.setValue("FAILOVER_COUNTER", new Integer(++failoverCounter), PayloadKey.AS_IS);
                            this.log.debug("Received GenericClusteringException where request was not completed.  Will retry.");
                            continue;
                        }
                        this.invocationHasReachedAServer(invocation);
                        throw new ServerException("Clustering error", gcex);
                    }
                    throw (Exception)response;
                }
                haResponse = response instanceof IMarshalledValue ? (HARMIResponse)((IMarshalledValue)response).get() : (response instanceof MarshalledObject ? (HARMIResponse)((MarshalledObject)response).get() : (HARMIResponse)response);
                if (haResponse.newReplicants != null) {
                    this.updateClusterInfo(haResponse.newReplicants, haResponse.currentViewId);
                }
                response = haResponse.response;
                return response;
            }
            catch (CannotConnectException cncEx) {
                this.log.debug("Invocation failed: CannotConnectException - " + (Object)((Object)cncEx), cncEx);
                this.removeDeadTarget(this.getLocator());
                this.resetView();
                failoverAuthorized = this.txContextAllowsFailover(invocation);
                invocation.setValue("FAILOVER_COUNTER", new Integer(++failoverCounter), PayloadKey.AS_IS);
            }
            catch (GenericClusteringException gcex) {
                lastException = gcex;
                if (gcex.getCompletionStatus() == 1) {
                    if (this.totalNumberOfTargets() >= failoverCounter && !gcex.isDefinitive()) {
                        definitivlyRemoveNodeOnFailure = false;
                    }
                    this.removeDeadTarget(this.getLocator());
                    if (!definitivlyRemoveNodeOnFailure) {
                        this.resetView();
                    }
                    failoverAuthorized = this.txContextAllowsFailover(invocation);
                    invocation.setValue("FAILOVER_COUNTER", new Integer(++failoverCounter), PayloadKey.AS_IS);
                    this.log.debug("Received GenericClusteringException where request was not completed.  Will retry.");
                    continue;
                }
                this.invocationHasReachedAServer(invocation);
                throw new ServerException("Clustering error", gcex);
            }
            catch (RemoteException aex) {
                this.log.debug("Invocation failed: RemoteException - " + aex, aex);
                if (this.isStrictRMIException()) {
                    throw new ServerException(aex.getMessage(), aex);
                }
                throw aex;
            }
            catch (Throwable throwable) {
                this.log.debug("Invocation failed: " + throwable, throwable);
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }
        if (!failoverAuthorized) {
            throw new ServiceUnavailableException("Service unavailable (failover not possible inside a user transaction) for " + invocation.getObjectName() + " calling method " + invocation.getMethod(), lastException);
        }
        throw new ServiceUnavailableException("Service unavailable for " + invocation.getObjectName() + " calling method " + invocation.getMethod(), lastException);
    }

    private Object printPossibleTargets() {
        ArrayList possibleTargets;
        StringBuffer buffer = new StringBuffer();
        if (this.familyClusterInfo != null && (possibleTargets = this.familyClusterInfo.getTargets()) != null && possibleTargets.size() > 0) {
            for (int x = 0; x < possibleTargets.size(); ++x) {
                buffer.append("\nPossible target " + (x + 1) + ": " + possibleTargets.get(x));
            }
        }
        return buffer.toString();
    }

    private void removeDeadTarget(InvokerLocator locator) {
        if (locator != null && this.familyClusterInfo != null) {
            this.familyClusterInfo.removeDeadTarget(locator);
            this.log.debug("Removed " + locator + " from target list.");
        }
    }

    private void updateClusterInfo(ArrayList newReplicants, long currentViewId) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.updateClusterInfo(newReplicants, currentViewId);
            this.log.debug("Updating cluster info.  New view id: " + currentViewId);
            this.log.debug("New cluster target list is:");
            for (int x = 0; x < newReplicants.size(); ++x) {
                this.log.debug(newReplicants.get(x));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(500);
        out.writeUTF(this.getLocator().getOriginalURI());
        out.writeBoolean(this.isStrictRMIException());
        ArrayList targets = null;
        long vid = 0L;
        FamilyClusterInfo familyClusterInfo = this.familyClusterInfo;
        synchronized (familyClusterInfo) {
            targets = this.familyClusterInfo.getTargets();
            vid = this.familyClusterInfo.getCurrentViewId();
        }
        out.writeObject(targets);
        out.writeObject(this.loadBalancePolicy);
        out.writeObject(this.proxyFamilyName);
        out.writeLong(vid);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 500: {
                this.setLocator(new InvokerLocator(in.readUTF()));
                this.setStrictRMIException(in.readBoolean());
                this.init(this.getLocator());
                ArrayList targets = (ArrayList)in.readObject();
                this.loadBalancePolicy = (LoadBalancePolicy)in.readObject();
                this.proxyFamilyName = (String)in.readObject();
                long vid = in.readLong();
                this.familyClusterInfo = ClusteringTargetsRepository.initTarget(this.proxyFamilyName, targets, vid);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown version seen: " + version);
            }
        }
    }
}

