/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.auth.callback.SecurityActions;

public class SecurityActions {
    static CallbackHandler getContextCallbackHandler() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextCallbackHandler();
        }
        return PolicyContextActions.PRIVILEGED.getContextCallbackHandler();
    }

    static interface PolicyContextActions {
        public static final String CALLBACK_HANDLER_KEY = "org.jboss.security.auth.spi.CallbackHandler";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction;
            {
                this.exAction = new PrivilegedExceptionAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() throws Exception {
                        return (CallbackHandler)PolicyContext.getContext("org.jboss.security.auth.spi.CallbackHandler");
                    }
                };
            }

            public CallbackHandler getContextCallbackHandler() throws PolicyContextException {
                try {
                    return (CallbackHandler)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public CallbackHandler getContextCallbackHandler() throws PolicyContextException {
                return (CallbackHandler)PolicyContext.getContext("org.jboss.security.auth.spi.CallbackHandler");
            }
        };

        public CallbackHandler getContextCallbackHandler() throws PolicyContextException;
    }
}

