/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dyndns.fichtner.rsccheck.engine.Context;
import org.dyndns.fichtner.rsccheck.engine.ErrorEntry;
import org.dyndns.fichtner.rsccheck.engine.RscBundleCollection;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;
import org.dyndns.fichtner.rsccheck.engine.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRscBundleVisitor
implements Visitor {
    protected Context context;
    private final List<ErrorEntry> errors = new ArrayList<ErrorEntry>();

    @Override
    public boolean visitCollection(RscBundleCollection rscBundleCollection, Context context) {
        this.errors.clear();
        this.context = context;
        for (Map.Entry entry : rscBundleCollection.entrySet()) {
            this.visitBundle((RscBundleReader)entry.getKey(), (RscBundleContent)entry.getValue());
        }
        return true;
    }

    @Override
    public boolean visitBundle(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent) {
        for (Map.Entry entry : rscBundleContent.entrySet()) {
            if (this.visitBundleKeyValue(rscBundleReader, rscBundleContent, (String)entry.getKey(), (RscBundleContent.Entry)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visitBundleKeyValue(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, String string, RscBundleContent.Entry entry) {
        return true;
    }

    protected void addError(Visitor visitor, String string, RscBundleReader rscBundleReader, RscBundleContent.Entry entry) {
        this.errors.add(new ErrorEntry(visitor, rscBundleReader, entry, string));
    }

    @Override
    public List<ErrorEntry> getErrors() {
        return this.errors;
    }

    @Override
    public boolean runnableWithoutConfig() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

