/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine;

import java.util.ArrayList;
import java.util.List;
import org.dyndns.fichtner.rsccheck.engine.Context;
import org.dyndns.fichtner.rsccheck.engine.ErrorEntry;
import org.dyndns.fichtner.rsccheck.engine.RscBundleCollection;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;
import org.dyndns.fichtner.rsccheck.engine.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RscBundleCheck {
    private final Context context;

    public RscBundleCheck(Context context) {
        if (context == null) {
            throw new NullPointerException("configuration must not be null");
        }
        this.context = context;
    }

    public List<ErrorEntry> execute() throws Exception {
        RscBundleCollection rscBundleCollection = new RscBundleCollection();
        for (RscBundleReader object : this.context.rscBundleReaders) {
            rscBundleCollection.put(object, new RscBundleContent(object));
        }
        ArrayList arrayList = new ArrayList();
        for (Visitor visitor : this.context.visitors) {
            rscBundleCollection.accept(visitor, this.context);
            arrayList.addAll(visitor.getErrors());
        }
        return arrayList;
    }
}

