/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;

public class RscBundleReaderFile
implements RscBundleReader {
    private final InputStream inStream;
    private final String identifier;

    public RscBundleReaderFile(File file) throws FileNotFoundException {
        this(new FileInputStream(file), file.toString());
    }

    public RscBundleReaderFile(InputStream inputStream, String string) {
        this.inStream = inputStream;
        this.identifier = string;
    }

    public synchronized void fill(RscBundleContent rscBundleContent) throws IOException {
        int n2;
        char[] cArray = new char[1024];
        LineReader lineReader = new LineReader(this.inStream);
        while ((n2 = lineReader.readLine()) >= 0) {
            int n3;
            char c2 = '\u0000';
            int n4 = n2;
            boolean bl = false;
            boolean bl2 = false;
            for (n3 = 0; n3 < n2; ++n3) {
                c2 = lineReader.lineBuf[n3];
                if (!(c2 != '=' && c2 != ':' || bl2)) {
                    n4 = n3 + 1;
                    bl = true;
                    break;
                }
                if (!(c2 != ' ' && c2 != '\t' && c2 != '\f' || bl2)) {
                    n4 = n3 + 1;
                    break;
                }
                bl2 = c2 == '\\' ? !bl2 : false;
            }
            lineReader.keylinenum = lineReader.linenum;
            while (n4 < n2) {
                c2 = lineReader.lineBuf[n4];
                if (c2 != ' ' && c2 != '\t' && c2 != '\f') {
                    if (bl || c2 != '=' && c2 != ':') break;
                    bl = true;
                }
                ++n4;
            }
            this.loadConvert(lineReader.lineBuf, 0, n3, cArray);
            this.loadConvert(lineReader.lineBuf, n4, n2 - n4, cArray);
            rscBundleContent.put(new String(lineReader.lineBuf, 0, n3), new RscBundleContent.Entry(new String(lineReader.lineBuf, n4, n2 - n4), lineReader.keylinenum));
        }
    }

    private String loadConvert(char[] cArray, int n2, int n3, char[] cArray2) {
        int n4;
        if (cArray2.length < n3) {
            n4 = n3 * 2;
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            cArray2 = new char[n4];
        }
        char[] cArray3 = cArray2;
        int n5 = 0;
        int n6 = n2 + n3;
        while (n2 < n6) {
            if ((n4 = cArray[n2++]) == 92) {
                if ((n4 = cArray[n2++]) == 116) {
                    n4 = 9;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 102) {
                    n4 = 12;
                }
                cArray3[n5++] = n4;
                continue;
            }
            cArray3[n5++] = n4;
        }
        return new String(cArray3, 0, n5);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private static class LineReader {
        byte[] inBuf = new byte[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        int keylinenum = 0;
        int linenum = 0;

        public LineReader(InputStream inputStream) {
            this.inStream = inputStream;
        }

        int readLine() throws IOException {
            int n2 = 0;
            char c2 = '\u0000';
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (n2 == 0 || bl2) {
                            return -1;
                        }
                        return n2;
                    }
                }
                c2 = (char)(0xFF & this.inBuf[this.inOff++]);
                if (bl6) {
                    bl6 = false;
                    if (c2 == '\n') continue;
                }
                if (bl) {
                    if (c2 == ' ' || c2 == '\t' || c2 == '\f') continue;
                    if (!(bl4 || c2 != '\r' && c2 != '\n')) {
                        ++this.linenum;
                        continue;
                    }
                    bl = false;
                    bl4 = false;
                }
                if (bl3) {
                    ++this.linenum;
                    bl3 = false;
                    if (c2 == '#' || c2 == '!') {
                        bl2 = true;
                        continue;
                    }
                }
                if (c2 != '\n' && c2 != '\r') {
                    this.lineBuf[n2++] = c2;
                    if (n2 == this.lineBuf.length) {
                        int n3 = this.lineBuf.length * 2;
                        if (n3 < 0) {
                            n3 = Integer.MAX_VALUE;
                        }
                        char[] cArray = new char[n3];
                        System.arraycopy(this.lineBuf, 0, cArray, 0, this.lineBuf.length);
                        this.lineBuf = cArray;
                    }
                    if (c2 == '\\') {
                        bl5 = !bl5;
                        continue;
                    }
                    bl5 = false;
                    continue;
                }
                if (bl2 || n2 == 0) {
                    bl2 = false;
                    bl3 = true;
                    bl = true;
                    n2 = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return n2;
                    }
                }
                if (!bl5) break;
                --n2;
                bl = true;
                bl4 = true;
                bl5 = false;
                if (c2 != '\r') continue;
                bl6 = true;
            }
            return n2;
        }
    }
}

