/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;

public class AllowedCharKeyVisitor
extends AbstractRscBundleVisitor {
    private String allowedKeyChars;
    private String disallowedKeyChars;

    public boolean visitBundleKeyValue(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, String string, RscBundleContent.Entry entry) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (this.allowedKeyChars != null && this.allowedKeyChars.indexOf(c2) < 0) {
                this.addError(this, "Key contains character " + c2 + " which was not found in the allowed chars <" + this.allowedKeyChars + ">", rscBundleReader, entry);
            }
            if (this.disallowedKeyChars == null || this.disallowedKeyChars.indexOf(c2) < 0) continue;
            this.addError(this, "Key contains character " + c2 + " which was found in the disallowed chars <" + this.disallowedKeyChars + ">", rscBundleReader, entry);
        }
        return super.visitBundleKeyValue(rscBundleReader, rscBundleContent, string, entry);
    }

    public String getAllowedKeyChars() {
        return this.allowedKeyChars;
    }

    public void setAllowedKeyChars(String string) {
        this.allowedKeyChars = string;
    }

    public String getDisallowedKeyChars() {
        return this.disallowedKeyChars;
    }

    public void setDisallowedKeyChars(String string) {
        this.disallowedKeyChars = string;
    }

    public boolean runnableWithoutConfig() {
        return false;
    }

    public String getName() {
        return "allowed char key check";
    }
}

