/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import java.util.regex.Pattern;
import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;

public class KeyRegexpVisitor
extends AbstractRscBundleVisitor {
    private Pattern pattern;

    public boolean visitBundleKeyValue(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, String string, RscBundleContent.Entry entry) {
        if (this.pattern != null && !this.pattern.matcher(string).find()) {
            this.addError(this, "Key " + string + " does not match regexp " + this.pattern.pattern(), rscBundleReader, entry);
        }
        return super.visitBundleKeyValue(rscBundleReader, rscBundleContent, string, entry);
    }

    public boolean runnableWithoutConfig() {
        return false;
    }

    public void setAllowedKeyRegexp(String string) {
        if (string == null || string.length() == 0) {
            throw new RuntimeException("allowedKeyRegexp must not be empty");
        }
        this.pattern = Pattern.compile(string);
    }

    public String getName() {
        return "key regexp check";
    }
}

