/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;
import org.dyndns.fichtner.rsccheck.util.Jdkutil;
import org.dyndns.fichtner.rsccheck.util.NlsReferenceCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedKeyVisitor
extends AbstractRscBundleVisitor {
    private String fqNlsMethodName;
    private String classpath;
    private URL[] cpURLs;

    @Override
    public boolean visitBundle(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent) {
        this.checkValid();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.processClasspathEntry(hashSet, this.classpath));
        this.do1(rscBundleReader, rscBundleContent, hashSet);
        this.do2(rscBundleReader, rscBundleContent, hashSet);
        return super.visitBundle(rscBundleReader, rscBundleContent);
    }

    private void checkValid() {
        if (this.classpath == null || this.classpath.length() == 0) {
            throw new IllegalStateException("Classpath must not be null or empty");
        }
        if (this.fqNlsMethodName == null) {
            throw new IllegalStateException("Method must not be null or empty");
        }
    }

    private void do1(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>(set);
        arrayList.removeAll(rscBundleContent.keySet());
        if (!arrayList.isEmpty()) {
            this.addError(this, "Reference(s) to non-exisiting resourcebundle-key(s) " + arrayList, rscBundleReader, null);
        }
    }

    private void do2(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, Set<String> set) {
        ArrayList arrayList = new ArrayList(rscBundleContent.keySet());
        arrayList.removeAll(set);
        if (!arrayList.isEmpty()) {
            this.addError(this, "Unused resourcebundle key(s) " + arrayList, rscBundleReader, null);
        }
    }

    private Set<String> processClasspathEntry(Set<String> set, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Member[] memberArray = this.loadMembers();
        for (int i2 = 0; i2 < memberArray.length; ++i2) {
            NlsReferenceCheck nlsReferenceCheck = new NlsReferenceCheck(memberArray[i2]);
            nlsReferenceCheck.check(string);
            hashSet.addAll(nlsReferenceCheck.getCollectedKeys());
        }
        return hashSet;
    }

    private URLClassLoader getClassloader() {
        return new URLClassLoader(this.cpURLs);
    }

    private static URL[] createURLArray(String string) throws MalformedURLException {
        String[] stringArray = string.split(File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = UnusedKeyVisitor.createFile(stringArray[i2]).toURI().toURL();
        }
        return uRLArray;
    }

    private Member[] loadMembers() {
        String[] stringArray = this.fqNlsMethodName.split(":");
        Member[] memberArray = new Member[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            memberArray[i2] = stringArray[i2].contains("#") ? this.loadMethod(stringArray[i2]) : this.loadConstructor(stringArray[i2]);
        }
        return memberArray;
    }

    private Constructor<?> loadConstructor(String string) {
        Object[] objectArray;
        String[] stringArray = string.split("[\\(\\,\\)]");
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Illegal constructor string " + this.fqNlsMethodName);
        }
        String string2 = stringArray[0];
        Class<?> clazz = this.loadClass(string2);
        Constructor<?> constructor = this.findConstructor(clazz, (String[])(objectArray = this.trim(UnusedKeyVisitor.createArray(stringArray, 1))));
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor (" + Arrays.toString(objectArray) + ") not found in " + string2);
        }
        return constructor;
    }

    private Method loadMethod(String string) {
        String[] stringArray = string.split("[\\#\\(\\,\\)]");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Illegal method string " + this.fqNlsMethodName);
        }
        String string2 = stringArray[0];
        Class<?> clazz = this.loadClass(string2);
        String string3 = stringArray[1];
        Object[] objectArray = this.trim(UnusedKeyVisitor.createArray(stringArray, 2));
        Method method = this.findMethod(clazz, (String[])objectArray, string3);
        if (method == null) {
            throw new IllegalArgumentException("Method " + string3 + "(" + Arrays.toString(objectArray) + ") not found in " + string2);
        }
        return method;
    }

    private String[] trim(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = stringArray[i2].trim();
        }
        return stringArray2;
    }

    private Method findMethod(Class<?> clazz, String[] stringArray, String string) {
        Method[] methodArray = clazz.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            if (!method.getName().equals(string) || !Arrays.equals(Jdkutil.getExternalNames(method.getParameterTypes()), stringArray)) continue;
            return method;
        }
        return null;
    }

    private Constructor<?> findConstructor(Class<?> clazz, String[] stringArray) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            Constructor<?> constructor = constructorArray[i2];
            if (!Arrays.equals(Jdkutil.getExternalNames(constructor.getParameterTypes()), stringArray)) continue;
            return constructor;
        }
        return null;
    }

    private static String[] createArray(String[] stringArray, int n2) {
        String[] stringArray2 = new String[stringArray.length - n2];
        System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }

    public void setNlsMethodName(String string) {
        this.fqNlsMethodName = string;
    }

    private Class<?> loadClass(String string) {
        try {
            return Class.forName(string, false, this.getClassloader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Error loading class " + string, classNotFoundException);
        }
    }

    public void setClasspath(String string) {
        try {
            this.cpURLs = UnusedKeyVisitor.createURLArray(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Unable to create classloader for " + this.classpath, malformedURLException);
        }
        this.classpath = string;
    }

    private static File createFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException(file + " does not exist");
        }
        return file;
    }

    @Override
    public boolean runnableWithoutConfig() {
        return false;
    }

    @Override
    public String getName() {
        return "unused key check";
    }
}

