/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import java.util.HashMap;
import java.util.Map;
import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.Context;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;
import org.dyndns.fichtner.rsccheck.engine.visitors.PlaceholderVisitor;

public class UpperLowerVisitor
extends AbstractRscBundleVisitor {
    private final Map<String, Character> upperLowerMap = new HashMap<String, Character>();

    public boolean visitBundleKeyValue(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, String string, RscBundleContent.Entry entry) {
        if (entry.getValue().length() != 0 && !this.checkUpperLowerCase(this.context, string, entry.getValue())) {
            this.addError(this, "inconsistent lower/upper case", rscBundleReader, entry);
        }
        return super.visitBundleKeyValue(rscBundleReader, rscBundleContent, string, entry);
    }

    private boolean checkUpperLowerCase(Context context, String string, String string2) {
        Character c2 = this.upperLowerMap.get(string);
        char c3 = string2.charAt(0);
        PlaceholderVisitor placeholderVisitor = (PlaceholderVisitor)context.getVisitor(PlaceholderVisitor.class);
        if (placeholderVisitor == null || placeholderVisitor.getPlaceholderChars() == null || placeholderVisitor.getPlaceholderChars().indexOf(c3) < 0) {
            if (c2 == null) {
                this.upperLowerMap.put(string, new Character(c3));
            } else {
                return Character.isLowerCase(c3) == Character.isLowerCase(c2.charValue());
            }
        }
        return true;
    }

    public String getName() {
        return "upper lower check";
    }
}

