/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.util;

import de.reflectk.ContentReader;
import de.reflectk.Inspect4J;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NlsReferenceCheck {
    private final Set<String> nlsKeys;
    private final Member inspected;
    private final String desc;
    private final boolean isMethod;
    private final boolean isStatic;
    private final int parCount;

    public NlsReferenceCheck(Member member) {
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            this.desc = Type.getConstructorDescriptor(constructor);
            this.isMethod = false;
            this.isStatic = false;
            this.parCount = constructor.getParameterTypes().length;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            this.desc = Type.getMethodDescriptor(method);
            this.isMethod = true;
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.parCount = method.getParameterTypes().length;
        } else {
            throw new IllegalArgumentException("member must not be null and not a field");
        }
        this.inspected = member;
        this.nlsKeys = new HashSet<String>();
    }

    public void check(String string) {
        Inspect4J.readContent(string, string, new ContentReader(){

            public void readContent(String string, byte[] byArray) {
                NlsReferenceCheck.this.check(byArray);
            }
        });
    }

    public void check(byte[] byArray) {
        ClassNode classNode = new ClassNode();
        new ClassReader(byArray).accept(classNode, 8);
        for (MethodNode methodNode : classNode.methods) {
            Analyzer analyzer = new Analyzer(new SourceInterpreter());
            try {
                analyzer.analyze(classNode.name, methodNode);
                Frame[] frameArray = analyzer.getFrames();
                for (int i2 = 0; i2 < methodNode.instructions.size(); ++i2) {
                    if (!(methodNode.instructions.get(i2) instanceof MethodInsnNode)) continue;
                    int n2 = methodNode.instructions.get(i2).getOpcode();
                    if (!(this.isMethod && this.isStatic && n2 == 184 || this.isMethod && !this.isStatic && 182 == n2) && (183 != n2 || this.isMethod)) continue;
                    this.doIt1(frameArray, i2, (MethodInsnNode)methodNode.instructions.get(i2));
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new RuntimeException("Error analyzing " + classNode.name, analyzerException);
            }
        }
    }

    private void doIt1(Frame[] frameArray, int n2, MethodInsnNode methodInsnNode) {
        if (NlsReferenceCheck.convert(this.inspected.getDeclaringClass().getName()).equals(methodInsnNode.owner) && (this.inspected.getName().equals(methodInsnNode.name) || "<init>".equals(methodInsnNode.name)) && this.desc.equals(methodInsnNode.desc)) {
            SourceValue sourceValue = null;
            for (int i2 = 0; i2 < this.parCount; ++i2) {
                sourceValue = (SourceValue)frameArray[n2].pop();
            }
            if (sourceValue != null) {
                this.doIt2(frameArray, n2, sourceValue);
            }
        }
    }

    private void doIt2(Frame[] frameArray, int n2, SourceValue sourceValue) {
        Iterator iterator = sourceValue.insns.iterator();
        while (iterator.hasNext()) {
            this.doIt3(frameArray, n2, (AbstractInsnNode)iterator.next());
        }
    }

    private void doIt3(Frame[] frameArray, int n2, AbstractInsnNode abstractInsnNode2) {
        if (abstractInsnNode2 instanceof LdcInsnNode) {
            this.nlsKeys.add(String.valueOf(((LdcInsnNode)abstractInsnNode2).cst));
            return;
        }
        if (abstractInsnNode2 instanceof VarInsnNode) {
            VarInsnNode varInsnNode = (VarInsnNode)abstractInsnNode2;
            if (25 == varInsnNode.getOpcode()) {
                for (AbstractInsnNode abstractInsnNode2 : ((SourceValue)frameArray[n2].getLocal((int)varInsnNode.var)).insns) {
                    if (!(abstractInsnNode2 instanceof VarInsnNode) || 58 != abstractInsnNode2.getOpcode()) continue;
                    this.nlsKeys.add(String.valueOf(((LdcInsnNode)abstractInsnNode2.getPrevious()).cst));
                    return;
                }
            }
        } else if (abstractInsnNode2 instanceof FieldInsnNode) {
            // empty if block
        }
    }

    private static String convert(String string) {
        return string.replace('.', '/');
    }

    public Set<String> getCollectedKeys() {
        return this.nlsKeys;
    }

    public void reset() {
        this.nlsKeys.clear();
    }
}

