/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] mapping = new int[40];
    private Object[] newLocals = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    private boolean changed;

    public LocalVariablesSorter(int n2, String string, MethodVisitor methodVisitor) {
        super(methodVisitor);
        Type[] typeArray = Type.getArgumentTypes(string);
        this.nextLocal = (8 & n2) == 0 ? 1 : 0;
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            this.nextLocal += typeArray[i2].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n2, int n3) {
        Type type;
        switch (n2) {
            case 22: 
            case 55: {
                type = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: {
                type = OBJECT_TYPE;
                break;
            }
            default: {
                type = Type.VOID_TYPE;
            }
        }
        this.mv.visitVarInsn(n2, this.remap(n3, type));
    }

    public void visitIincInsn(int n2, int n3) {
        this.mv.visitIincInsn(this.remap(n2, Type.INT_TYPE), n3);
    }

    public void visitMaxs(int n2, int n3) {
        this.mv.visitMaxs(n2, this.nextLocal);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        int n3 = this.remap(n2, Type.getType(string2));
        this.mv.visitLocalVariable(string, string2, string3, label, label2, n3);
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        int n5;
        if (n2 != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.changed) {
            this.mv.visitFrame(n2, n3, objectArray, n4, objectArray2);
            return;
        }
        Object[] objectArray3 = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, objectArray3, 0, objectArray3.length);
        int n6 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            int n7;
            Object object = objectArray[n5];
            int n8 = n7 = object == Opcodes.LONG || object == Opcodes.DOUBLE ? 2 : 1;
            if (object != Opcodes.TOP) {
                this.setFrameLocal(this.remap(n6, n7), object);
            }
            n6 += n7;
        }
        n6 = 0;
        n5 = 0;
        int n9 = 0;
        while (n6 < this.newLocals.length) {
            Object object;
            if ((object = this.newLocals[n6++]) != null && object != Opcodes.TOP) {
                this.newLocals[n9] = object;
                n5 = n9 + 1;
                if (object == Opcodes.LONG || object == Opcodes.DOUBLE) {
                    ++n6;
                }
            } else {
                this.newLocals[n9] = Opcodes.TOP;
            }
            ++n9;
        }
        this.mv.visitFrame(n2, n5, this.newLocals, n4, objectArray2);
        this.newLocals = objectArray3;
    }

    public int newLocal(Type type) {
        Object object;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                object = Opcodes.INTEGER;
                break;
            }
            case 6: {
                object = Opcodes.FLOAT;
                break;
            }
            case 7: {
                object = Opcodes.LONG;
                break;
            }
            case 8: {
                object = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                object = type.getDescriptor();
                break;
            }
            default: {
                object = type.getInternalName();
            }
        }
        int n2 = this.nextLocal;
        this.nextLocal += type.getSize();
        this.setLocalType(n2, type);
        this.setFrameLocal(n2, object);
        return n2;
    }

    protected void setLocalType(int n2, Type type) {
    }

    private void setFrameLocal(int n2, Object object) {
        int n3 = this.newLocals.length;
        if (n2 >= n3) {
            Object[] objectArray = new Object[Math.max(2 * n3, n2 + 1)];
            System.arraycopy(this.newLocals, 0, objectArray, 0, n3);
            this.newLocals = objectArray;
        }
        this.newLocals[n2] = object;
    }

    private int remap(int n2, Type type) {
        int n3;
        int n4;
        if (n2 < this.firstLocal) {
            return n2;
        }
        int n5 = 2 * n2 + type.getSize() - 1;
        if (n5 >= (n4 = this.mapping.length)) {
            int[] nArray = new int[Math.max(2 * n4, n5 + 1)];
            System.arraycopy(this.mapping, 0, nArray, 0, n4);
            this.mapping = nArray;
        }
        if ((n3 = this.mapping[n5]) == 0) {
            n3 = this.newLocalMapping(type);
            this.setLocalType(n3, type);
            this.mapping[n5] = n3 + 1;
        } else {
            --n3;
        }
        if (n3 != n2) {
            this.changed = true;
        }
        return n3;
    }

    protected int newLocalMapping(Type type) {
        int n2 = this.nextLocal;
        this.nextLocal += type.getSize();
        return n2;
    }

    private int remap(int n2, int n3) {
        int n4;
        if (n2 < this.firstLocal || !this.changed) {
            return n2;
        }
        int n5 = 2 * n2 + n3 - 1;
        int n6 = n4 = n5 < this.mapping.length ? this.mapping[n5] : 0;
        if (n4 == 0) {
            throw new IllegalStateException("Unknown local variable " + n2);
        }
        return n4 - 1;
    }
}

