/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckFieldAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[0].endsWith(".class") ? new ClassReader(new FileInputStream(stringArray[0])) : new ClassReader(stringArray[0]);
        CheckClassAdapter.verify(classReader, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader classReader, boolean bl, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(classNode), 2);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List list = classNode.methods;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2;
            MethodNode methodNode = (MethodNode)list.get(i2);
            Analyzer analyzer = new Analyzer(new SimpleVerifier(Type.getObjectType(classNode.name), type, false));
            try {
                analyzer.analyze(classNode.name, methodNode);
                if (!bl) {
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            Frame[] frameArray = analyzer.getFrames();
            TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor();
            printWriter.println(methodNode.name + methodNode.desc);
            for (n2 = 0; n2 < methodNode.instructions.size(); ++n2) {
                methodNode.instructions.get(n2).accept(traceMethodVisitor);
                StringBuffer stringBuffer = new StringBuffer();
                Frame frame = frameArray[n2];
                if (frame == null) {
                    stringBuffer.append('?');
                } else {
                    int n3;
                    for (n3 = 0; n3 < frame.getLocals(); ++n3) {
                        stringBuffer.append(CheckClassAdapter.getShortName(frame.getLocal(n3).toString())).append(' ');
                    }
                    stringBuffer.append(" : ");
                    for (n3 = 0; n3 < frame.getStackSize(); ++n3) {
                        stringBuffer.append(CheckClassAdapter.getShortName(frame.getStack(n3).toString())).append(' ');
                    }
                }
                while (stringBuffer.length() < methodNode.maxStack + methodNode.maxLocals + 1) {
                    stringBuffer.append(' ');
                }
                printWriter.print(Integer.toString(n2 + 100000).substring(1));
                printWriter.print(" " + stringBuffer + " : " + traceMethodVisitor.buf);
            }
            for (n2 = 0; n2 < methodNode.tryCatchBlocks.size(); ++n2) {
                ((TryCatchBlockNode)methodNode.tryCatchBlocks.get(n2)).accept(traceMethodVisitor);
                printWriter.print(" " + traceMethodVisitor.buf);
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    private static String getShortName(String string) {
        int n2 = string.lastIndexOf(47);
        int n3 = string.length();
        if (string.charAt(n3 - 1) == ';') {
            --n3;
        }
        return n2 == -1 ? string : string.substring(n2 + 1, n3);
    }

    public CheckClassAdapter(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(n3, 161329);
        if (string == null || !string.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(string, "class name");
        }
        if ("java/lang/Object".equals(string)) {
            if (string3 != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(string3, "super class name");
        }
        if (string2 != null) {
            CheckMethodAdapter.checkClassSignature(string2);
        }
        if ((n3 & 0x200) != 0 && !"java/lang/Object".equals(string3)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                CheckMethodAdapter.checkInternalName(stringArray[i2], "interface name at index " + i2);
            }
        }
        this.cv.visit(n2, n3, string, string2, string3, stringArray);
    }

    public void visitSource(String string, String string2) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        this.cv.visitSource(string, string2);
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (string == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (string3 != null) {
            CheckMethodAdapter.checkMethodDesc(string3);
        }
        this.cv.visitOuterClass(string, string2, string3);
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(string, "class name");
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, "outer class name");
        }
        if (string3 != null) {
            CheckMethodAdapter.checkIdentifier(string3, "inner class name");
        }
        CheckClassAdapter.checkAccess(n2, 30239);
        this.cv.visitInnerClass(string, string2, string3, n2);
    }

    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 151775);
        CheckMethodAdapter.checkIdentifier(string, "field name");
        CheckMethodAdapter.checkDesc(string2, false);
        if (string3 != null) {
            CheckMethodAdapter.checkFieldSignature(string3);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        FieldVisitor fieldVisitor = this.cv.visitField(n2, string, string2, string3, object);
        return new CheckFieldAdapter(fieldVisitor);
    }

    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 138751);
        CheckMethodAdapter.checkMethodIdentifier(string, "method name");
        CheckMethodAdapter.checkMethodDesc(string2);
        if (string3 != null) {
            CheckMethodAdapter.checkMethodSignature(string3);
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                CheckMethodAdapter.checkInternalName(stringArray[i2], "exception name at index " + i2);
            }
        }
        return new CheckMethodAdapter(this.cv.visitMethod(n2, string, string2, string3, stringArray));
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkState();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.cv.visitAnnotation(string, bl));
    }

    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.cv.visitAttribute(attribute);
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int n2, int n3) {
        int n4;
        int n5;
        if ((n2 & ~n3) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n2);
        }
        int n6 = (n2 & 1) == 0 ? 0 : 1;
        int n7 = (n2 & 2) == 0 ? 0 : 1;
        int n8 = n5 = (n2 & 4) == 0 ? 0 : 1;
        if (n6 + n7 + n5 > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + n2);
        }
        int n9 = (n2 & 0x10) == 0 ? 0 : 1;
        int n10 = n4 = (n2 & 0x400) == 0 ? 0 : 1;
        if (n9 + n4 > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + n2);
        }
    }
}

