/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.xml.SAXAdapter;
import org.objectweb.asm.xml.SAXAnnotationAdapter;
import org.objectweb.asm.xml.SAXClassAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXCodeAdapter
extends SAXAdapter
implements MethodVisitor {
    static final String[] TYPES = new String[]{"top", "int", "float", "double", "long", "null", "uninitializedThis"};
    private final Map labelNames = new HashMap();

    public SAXCodeAdapter(ContentHandler contentHandler, int n2) {
        super(contentHandler);
        if ((n2 & 0x700) == 0) {
            this.addStart("code", new AttributesImpl());
        }
    }

    public final void visitCode() {
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        switch (n2) {
            case -1: 
            case 0: {
                if (n2 == -1) {
                    attributesImpl.addAttribute("", "type", "type", "", "NEW");
                } else {
                    attributesImpl.addAttribute("", "type", "type", "", "FULL");
                }
                this.addStart("frame", attributesImpl);
                this.appendFrameTypes(true, n3, objectArray);
                this.appendFrameTypes(false, n4, objectArray2);
                break;
            }
            case 1: {
                attributesImpl.addAttribute("", "type", "type", "", "APPEND");
                this.addStart("frame", attributesImpl);
                this.appendFrameTypes(true, n3, objectArray);
                break;
            }
            case 2: {
                attributesImpl.addAttribute("", "type", "type", "", "CHOP");
                attributesImpl.addAttribute("", "count", "count", "", Integer.toString(n3));
                this.addStart("frame", attributesImpl);
                break;
            }
            case 3: {
                attributesImpl.addAttribute("", "type", "type", "", "SAME");
                this.addStart("frame", attributesImpl);
                break;
            }
            case 4: {
                attributesImpl.addAttribute("", "type", "type", "", "SAME1");
                this.addStart("frame", attributesImpl);
                this.appendFrameTypes(false, 1, objectArray2);
            }
        }
        this.addEnd("frame");
    }

    private void appendFrameTypes(boolean bl, int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            AttributesImpl attributesImpl = new AttributesImpl();
            if (object instanceof String) {
                attributesImpl.addAttribute("", "type", "type", "", (String)object);
            } else if (object instanceof Integer) {
                attributesImpl.addAttribute("", "type", "type", "", TYPES[(Integer)object]);
            } else {
                attributesImpl.addAttribute("", "type", "type", "", "uninitialized");
                attributesImpl.addAttribute("", "label", "label", "", this.getLabel((Label)object));
            }
            this.addElement(bl ? "local" : "stack", attributesImpl);
        }
    }

    public final void visitInsn(int n2) {
        this.addElement(AbstractVisitor.OPCODES[n2], new AttributesImpl());
    }

    public final void visitIntInsn(int n2, int n3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "value", "value", "", Integer.toString(n3));
        this.addElement(AbstractVisitor.OPCODES[n2], attributesImpl);
    }

    public final void visitVarInsn(int n2, int n3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n3));
        this.addElement(AbstractVisitor.OPCODES[n2], attributesImpl);
    }

    public final void visitTypeInsn(int n2, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "desc", "desc", "", string);
        this.addElement(AbstractVisitor.OPCODES[n2], attributesImpl);
    }

    public final void visitFieldInsn(int n2, String string, String string2, String string3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string);
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        this.addElement(AbstractVisitor.OPCODES[n2], attributesImpl);
    }

    public final void visitMethodInsn(int n2, String string, String string2, String string3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string);
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        this.addElement(AbstractVisitor.OPCODES[n2], attributesImpl);
    }

    public final void visitJumpInsn(int n2, Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "label", "label", "", this.getLabel(label));
        this.addElement(AbstractVisitor.OPCODES[n2], attributesImpl);
    }

    public final void visitLabel(Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", this.getLabel(label));
        this.addElement("Label", attributesImpl);
    }

    public final void visitLdcInsn(Object object) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(object.toString()));
        attributesImpl.addAttribute("", "desc", "desc", "", Type.getDescriptor(object.getClass()));
        this.addElement(AbstractVisitor.OPCODES[18], attributesImpl);
    }

    public final void visitIincInsn(int n2, int n3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n2));
        attributesImpl.addAttribute("", "inc", "inc", "", Integer.toString(n3));
        this.addElement(AbstractVisitor.OPCODES[132], attributesImpl);
    }

    public final void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "min", "min", "", Integer.toString(n2));
        attributesImpl.addAttribute("", "max", "max", "", Integer.toString(n3));
        attributesImpl.addAttribute("", "dflt", "dflt", "", this.getLabel(label));
        String string = AbstractVisitor.OPCODES[170];
        this.addStart(string, attributesImpl);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("", "name", "name", "", this.getLabel(labelArray[i2]));
            this.addElement("label", attributesImpl2);
        }
        this.addEnd(string);
    }

    public final void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "dflt", "dflt", "", this.getLabel(label));
        String string = AbstractVisitor.OPCODES[171];
        this.addStart(string, attributesImpl);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("", "name", "name", "", this.getLabel(labelArray[i2]));
            attributesImpl2.addAttribute("", "key", "key", "", Integer.toString(nArray[i2]));
            this.addElement("label", attributesImpl2);
        }
        this.addEnd(string);
    }

    public final void visitMultiANewArrayInsn(String string, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "desc", "desc", "", string);
        attributesImpl.addAttribute("", "dims", "dims", "", Integer.toString(n2));
        this.addElement(AbstractVisitor.OPCODES[197], attributesImpl);
    }

    public final void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        attributesImpl.addAttribute("", "end", "end", "", this.getLabel(label2));
        attributesImpl.addAttribute("", "handler", "handler", "", this.getLabel(label3));
        if (string != null) {
            attributesImpl.addAttribute("", "type", "type", "", string);
        }
        this.addElement("TryCatch", attributesImpl);
    }

    public final void visitMaxs(int n2, int n3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "maxStack", "maxStack", "", Integer.toString(n2));
        attributesImpl.addAttribute("", "maxLocals", "maxLocals", "", Integer.toString(n3));
        this.addElement("Max", attributesImpl);
        this.addEnd("code");
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", string);
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        if (string3 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(string3));
        }
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        attributesImpl.addAttribute("", "end", "end", "", this.getLabel(label2));
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n2));
        this.addElement("LocalVar", attributesImpl);
    }

    public final void visitLineNumber(int n2, Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "line", "line", "", Integer.toString(n2));
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        this.addElement("LineNumber", attributesImpl);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationDefault", 0, null, null);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotation", bl ? 1 : -1, null, string);
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "parameterAnnotation", bl ? 1 : -1, n2, string);
    }

    public void visitEnd() {
        this.addEnd("method");
    }

    private final String getLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = Integer.toString(this.labelNames.size());
            this.labelNames.put(label, string);
        }
        return string;
    }
}

