/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.jmx;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.jmx.HAServiceMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;

public class HAServiceMBeanSupport
extends ServiceMBeanSupport
implements HAServiceMBean {
    private HAPartition partition_;
    private ClusterPartitionMBean clusterPartition;
    private String partitionName = ServerConfigUtil.getDefaultPartitionName();
    private DistributedReplicantManager.ReplicantListener drmListener = null;
    private String REPLICANT_TOKEN = "";
    private boolean sendLocalLifecycleNotifications = true;
    private boolean sendRemoteLifecycleNotifications = true;

    public ClusterPartitionMBean getClusterPartition() {
        return this.clusterPartition;
    }

    public void setClusterPartition(ClusterPartitionMBean clusterPartition) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.clusterPartition = clusterPartition;
        }
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String newPartitionName) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.partitionName = newPartitionName;
        }
    }

    public void setDistributedState(String key, Serializable value) throws Exception {
        DistributedState ds = this.getPartition().getDistributedStateService();
        ds.set(this.getServiceHAName(), (Serializable)((Object)key), value);
    }

    public Serializable getDistributedState(String key) {
        DistributedState ds = this.getPartition().getDistributedStateService();
        return ds.get(this.getServiceHAName(), (Serializable)((Object)key));
    }

    protected void startService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"start HAServiceMBeanSupport");
        }
        this.setupPartition();
        this.registerRPCHandler();
        this.registerDRMListener();
    }

    protected void stopService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)"stop HAServiceMBeanSupport");
        }
        this.unregisterDRMListener();
        this.unregisterRPCHandler();
    }

    protected void setupPartition() throws Exception {
        if (this.clusterPartition == null) {
            String pName = this.getPartitionName();
            this.partition_ = this.findHAPartitionWithName(pName);
        } else {
            this.partition_ = this.clusterPartition.getHAPartition();
            this.partitionName = this.partition_.getPartitionName();
        }
    }

    protected void registerRPCHandler() {
        this.partition_.registerRPCHandler(this.getServiceHAName(), this);
    }

    protected void unregisterRPCHandler() {
        this.partition_.unregisterRPCHandler(this.getServiceHAName(), this);
    }

    protected void registerDRMListener() throws Exception {
        DistributedReplicantManager drm = this.partition_.getDistributedReplicantManager();
        this.drmListener = new DistributedReplicantManager.ReplicantListener(){
            Object mutex = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
                if (key.equals(HAServiceMBeanSupport.this.getServiceHAName())) {
                    Object object = this.mutex;
                    synchronized (object) {
                        HAServiceMBeanSupport.this.partitionTopologyChanged(newReplicants, newReplicantsViewId);
                    }
                }
            }
        };
        drm.registerListener(this.getServiceHAName(), this.drmListener);
        drm.add(this.getServiceHAName(), (Serializable)((Object)this.REPLICANT_TOKEN));
    }

    protected void unregisterDRMListener() throws Exception {
        DistributedReplicantManager drm = this.partition_.getDistributedReplicantManager();
        drm.remove(this.getServiceHAName());
        drm.unregisterListener(this.getServiceHAName(), this.drmListener);
    }

    public void partitionTopologyChanged(List newReplicants, int newReplicantsViewId) {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("partitionTopologyChanged(). cluster view id: " + newReplicantsViewId));
        }
    }

    protected boolean isDRMMasterReplica() {
        DistributedReplicantManager drm = this.getPartition().getDistributedReplicantManager();
        return drm.isMasterReplica(this.getServiceHAName());
    }

    public HAPartition getPartition() {
        return this.partition_;
    }

    public void callMethodOnPartition(String methodName, Object[] args) throws Exception {
        this.getPartition().callMethodOnCluster(this.getServiceHAName(), methodName, args, true);
    }

    public void callMethodOnPartition(String methodName, Object[] args, Class[] types) throws Exception {
        this.getPartition().callMethodOnCluster(this.getServiceHAName(), methodName, args, types, true);
    }

    public boolean getSendLocalLifecycleNotifications() {
        return this.sendLocalLifecycleNotifications;
    }

    public void setSendLocalLifecycleNotifications(boolean sendLocalLifecycleNotifications) {
        this.sendLocalLifecycleNotifications = sendLocalLifecycleNotifications;
    }

    public boolean getSendRemoteLifecycleNotifications() {
        return this.sendRemoteLifecycleNotifications;
    }

    public void setSendRemoteLifecycleNotifications(boolean sendRemoteLifecycleNotifications) {
        this.sendRemoteLifecycleNotifications = sendRemoteLifecycleNotifications;
    }

    public void sendNotification(Notification notification) {
        boolean stateChange;
        block4: {
            stateChange = this.isStateChangeNotification(notification);
            if (!stateChange || this.sendRemoteLifecycleNotifications) {
                try {
                    notification.setSource(this.getServiceName());
                    this.sendNotificationRemote(notification);
                }
                catch (Throwable th) {
                    boolean debug = this.log.isDebugEnabled();
                    if (!debug) break block4;
                    this.log.debug((Object)("sendNotificationRemote( " + notification + " ) failed "), th);
                }
            }
        }
        if (!stateChange || this.sendLocalLifecycleNotifications) {
            this.sendNotificationToLocalListeners(notification);
        }
    }

    private boolean isStateChangeNotification(Notification notification) {
        boolean stateChange = false;
        if (notification instanceof AttributeChangeNotification) {
            stateChange = "State".equals(((AttributeChangeNotification)notification).getAttributeName());
        }
        return stateChange;
    }

    protected void sendNotificationToLocalListeners(Notification notification) {
        super.sendNotification(notification);
    }

    protected void callAsyncMethodOnPartition(String methodName, Object[] args, Class[] types) throws Exception {
        HAPartition partition = this.getPartition();
        if (partition != null) {
            this.getPartition().callAsynchMethodOnCluster(this.getServiceHAName(), methodName, args, types, true);
        }
    }

    protected void sendNotificationRemote(Notification notification) throws Exception {
        this.callAsyncMethodOnPartition("_receiveRemoteNotification", new Object[]{notification}, new Class[]{Notification.class});
    }

    public void _receiveRemoteNotification(Notification notification) {
        super.sendNotification(notification);
    }

    public String getServiceHAName() {
        return this.getServiceName().getCanonicalName();
    }

    protected HAPartition findHAPartitionWithName(String name) throws Exception {
        this.log.debug((Object)("findHAPartitionWithName, name=" + name));
        HAPartition result = null;
        QueryExp classEQ = Query.eq(Query.classattr(), Query.value(ClusterPartition.class.getName()));
        QueryExp matchPartitionName = Query.match(Query.attr("PartitionName"), Query.value(name));
        QueryExp exp = Query.and(classEQ, matchPartitionName);
        Set<ObjectInstance> mbeans = this.getServer().queryMBeans(null, exp);
        if (mbeans != null && mbeans.size() > 0) {
            ObjectInstance inst = mbeans.iterator().next();
            ClusterPartitionMBean cp = (ClusterPartitionMBean)MBeanProxyExt.create((Class)ClusterPartitionMBean.class, (ObjectName)inst.getObjectName(), (MBeanServer)this.getServer());
            result = cp.getHAPartition();
        }
        if (result == null) {
            String msg = "Failed to find HAPartition with PartitionName=" + name;
            throw new InstanceNotFoundException(msg);
        }
        return result;
    }
}

