/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.util.List;
import javax.management.Notification;
import org.jboss.ha.jmx.HAServiceMBeanSupport;
import org.jboss.ha.singleton.HASingleton;
import org.jboss.ha.singleton.HASingletonMBean;

public class HASingletonSupport
extends HAServiceMBeanSupport
implements HASingletonMBean,
HASingleton {
    private boolean isMasterNode = false;

    public boolean isMasterNode() {
        return this.isMasterNode;
    }

    public void startSingleton() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"startSingleton() : elected for master singleton node");
        }
    }

    public void stopSingleton() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"stopSingleton() : another node in the partition (if any) is elected for master");
        }
    }

    public void partitionTopologyChanged(List newReplicants, int newViewID) {
        boolean isElectedNewMaster = this.isDRMMasterReplica();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("partitionTopologyChanged, isElectedNewMaster=" + isElectedNewMaster + ", isMasterNode=" + this.isMasterNode + ", viewID=" + newViewID));
        }
        if (isElectedNewMaster && this.isMasterNode) {
            return;
        }
        if (isElectedNewMaster && !this.isMasterNode) {
            this.makeThisNodeMaster();
        } else if (this.isMasterNode) {
            this._stopOldMaster();
        }
    }

    public void _stopOldMaster() {
        this.log.debug((Object)("_stopOldMaster, isMasterNode=" + this.isMasterNode));
        try {
            if (this.isMasterNode) {
                this.isMasterNode = false;
                this.sendLocalNotification("org.jboss.ha.singleton.stopping");
                this.stopSingleton();
                this.sendLocalNotification("org.jboss.ha.singleton.stopped");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"_stopOldMaster failed. Will still try to start new master. You need to examine the reason why the old master wouldn't stop and resolve it. It is bad that the old singleton may still be running while we are starting a new one, so you need to resolve this ASAP.", (Throwable)ex);
        }
    }

    protected void makeThisNodeMaster() {
        try {
            this.callAsyncMethodOnPartition("_stopOldMaster", new Object[0], new Class[0]);
            this.isMasterNode = true;
            this.sendLocalNotification("org.jboss.ha.singleton.starting");
            this.startSingleton();
            this.sendLocalNotification("org.jboss.ha.singleton.started");
        }
        catch (Exception ex) {
            this.log.error((Object)"_stopOldMaster failed. New master singleton will not start.", (Throwable)ex);
        }
    }

    private void sendLocalNotification(String type) {
        Notification n = new Notification(type, this, this.getNextNotificationSequenceNumber());
        super.sendNotificationToLocalListeners(n);
    }
}

