/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.api;

import org.concordion.api.Command;
import org.concordion.api.CommandCallList;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Resource;
import org.concordion.api.ResultRecorder;
import org.concordion.internal.util.Check;

public class CommandCall {
    private final CommandCallList children = new CommandCallList();
    private final Command command;
    private final String expression;
    private final Resource resource;
    private Element element;

    public CommandCall(Command command, Element element, String expression, Resource resource) {
        this.command = command;
        this.element = element;
        this.expression = expression;
        this.resource = resource;
    }

    public void setUp(Evaluator evaluator, ResultRecorder resultRecorder) {
        this.command.setUp(this, evaluator, resultRecorder);
    }

    public void execute(Evaluator evaluator, ResultRecorder resultRecorder) {
        this.command.execute(this, evaluator, resultRecorder);
    }

    public void verify(Evaluator evaluator, ResultRecorder resultRecorder) {
        this.command.verify(this, evaluator, resultRecorder);
    }

    public void appendChild(CommandCall commandNode) {
        this.children.append(commandNode);
    }

    public CommandCallList getChildren() {
        return this.children;
    }

    public Command getCommand() {
        return this.command;
    }

    public Element getElement() {
        return this.element;
    }

    public String getExpression() {
        return this.expression;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean hasChildCommands() {
        return !this.children.isEmpty();
    }

    public void setElement(Element element) {
        Check.notNull(element, "element is null", new Object[0]);
        this.element = element;
    }
}

