/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.api;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;
import nu.xom.XPathContext;

public final class Element {
    public static final String XHTML_PREFIX = "xhtml";
    public static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    private static XPathContext namespaceMappings = new XPathContext("xhtml", "http://www.w3.org/1999/xhtml");
    private final nu.xom.Element xomElement;

    public Element(String name) {
        this(new nu.xom.Element(name));
    }

    public Element(nu.xom.Element xomElement) {
        this.xomElement = xomElement;
    }

    public String getText() {
        return this.xomElement.getValue();
    }

    public Element addStyleClass(String styleClass) {
        String currentClass = this.getAttributeValue("class");
        if (currentClass != null) {
            styleClass = currentClass + " " + styleClass;
        }
        this.addAttribute("class", styleClass);
        return this;
    }

    public Element appendNonBreakingSpace() {
        return this.appendText("\u00a0");
    }

    public Element appendText(String text) {
        this.xomElement.appendChild((Node)new Text(text));
        return this;
    }

    public Element appendNonBreakingSpaceIfBlank() {
        if (this.isBlank()) {
            this.appendNonBreakingSpace();
        }
        return this;
    }

    public Element prependText(String text) {
        this.xomElement.insertChild((Node)new Text(text), 0);
        return this;
    }

    public Element prependChild(Element element) {
        this.xomElement.insertChild((Node)element.xomElement, 0);
        return this;
    }

    public void appendChild(Element element) {
        this.xomElement.appendChild((Node)element.xomElement);
    }

    public void removeChild(Element element) {
        this.xomElement.removeChild((Node)element.xomElement);
    }

    private Node[] getChildNodes() {
        Node[] childNodes = new Node[this.xomElement.getChildCount()];
        for (int i = 0; i < this.xomElement.getChildCount(); ++i) {
            childNodes[i] = this.xomElement.getChild(i);
        }
        return childNodes;
    }

    public void moveChildrenTo(Element element) {
        for (Node childNode : this.getChildNodes()) {
            childNode.detach();
            element.xomElement.appendChild(childNode);
        }
    }

    public Element setId(String id) {
        this.addAttribute("id", id);
        return this;
    }

    public Element addAttribute(String localName, String value) {
        this.xomElement.addAttribute(new Attribute(localName, value));
        return this;
    }

    public String getAttributeValue(String name) {
        return this.xomElement.getAttributeValue(name);
    }

    public String getAttributeValue(String localName, String namespaceURI) {
        return this.xomElement.getAttributeValue(localName, namespaceURI);
    }

    public void removeAttribute(String name) {
        this.xomElement.removeAttribute(this.xomElement.getAttribute(name));
    }

    public void removeAttribute(String localName, String namespaceURI) {
        this.xomElement.removeAttribute(this.xomElement.getAttribute(localName, namespaceURI));
    }

    public void moveAttributesTo(Element element) {
        for (int i = 0; i < this.xomElement.getAttributeCount(); ++i) {
            Attribute attribute = this.xomElement.getAttribute(i);
            this.xomElement.removeAttribute(attribute);
            element.xomElement.addAttribute(attribute);
        }
    }

    private boolean isBlank() {
        return this.getText().trim().equals("");
    }

    public String toXML() {
        return this.xomElement.toXML();
    }

    public Element getRootElement() {
        return new Element(this.xomElement.getDocument().getRootElement());
    }

    public Element getFirstChildElement(String name) {
        nu.xom.Element body = this.xomElement.getFirstChildElement(name);
        if (body == null) {
            return null;
        }
        return new Element(body);
    }

    public boolean hasChildren() {
        return this.xomElement.getChildCount() > 0;
    }

    public int hashCode() {
        return this.xomElement.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        return !(this.xomElement == null ? other.xomElement != null : !this.xomElement.equals((Object)other.xomElement));
    }

    public String getLocalName() {
        return this.xomElement.getLocalName();
    }

    public boolean isNamed(String name) {
        return this.getLocalName().equals(name);
    }

    public Element[] getDescendantElements(String name) {
        ArrayList<Element> descendants = new ArrayList<Element>();
        Nodes nodes = this.xomElement.query(this.xpathForElementName(name), namespaceMappings);
        for (int i = 0; i < nodes.size(); ++i) {
            descendants.add(new Element((nu.xom.Element)nodes.get(i)));
        }
        descendants.remove(this);
        return descendants.toArray(new Element[0]);
    }

    private String xpathForElementName(String name) {
        return ".//" + name + " | " + ".//" + XHTML_PREFIX + ":" + name;
    }

    public Element[] getChildElements(String name) {
        return this.wrapXomElements(this.xomElement.getChildElements(name));
    }

    public Element[] getChildElements() {
        return this.wrapXomElements(this.xomElement.getChildElements());
    }

    private Element[] wrapXomElements(Elements xomElements) {
        int count = xomElements.size();
        Element[] elements = new Element[count];
        for (int i = 0; i < count; ++i) {
            elements[i] = new Element(xomElements.get(i));
        }
        return elements;
    }

    public Element getFirstDescendantNamed(String name) {
        Element[] descendantElements = this.getDescendantElements(name);
        return descendantElements.length == 0 ? null : descendantElements[0];
    }

    public void appendSister(Element element) {
        nu.xom.Element xomParentElement = (nu.xom.Element)this.xomElement.getParent();
        int elementIndex = xomParentElement.indexOf((Node)this.xomElement);
        xomParentElement.insertChild((Node)element.xomElement, elementIndex + 1);
    }

    public Element getElementById(String id) {
        String query = ".//*[@id='" + id + "']";
        Nodes nodes = this.xomElement.query(query);
        if (0 == nodes.size()) {
            return null;
        }
        return new Element((nu.xom.Element)nodes.get(0));
    }
}

