/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Elements;
import org.concordion.api.Command;
import org.concordion.api.CommandCall;
import org.concordion.api.CommandFactory;
import org.concordion.api.Element;
import org.concordion.api.Resource;
import org.concordion.api.Specification;
import org.concordion.api.listener.DocumentParsingListener;
import org.concordion.internal.XMLSpecification;
import org.concordion.internal.util.Announcer;
import org.concordion.internal.util.Check;

public class DocumentParser {
    private final CommandFactory commandFactory;
    private final Announcer<DocumentParsingListener> listeners = Announcer.to(DocumentParsingListener.class);

    public DocumentParser(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public void addDocumentParsingListener(DocumentParsingListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeDocumentParsingListener(DocumentParsingListener listener) {
        this.listeners.removeListener(listener);
    }

    private void announceBeforeParsing(Document document) {
        this.listeners.announce().beforeParsing(document);
    }

    public Specification parse(Document document, Resource resource) {
        this.announceBeforeParsing(document);
        nu.xom.Element xomElement = document.getRootElement();
        CommandCall rootCommandCall = new CommandCall(this.createSpecificationCommand(), new Element(xomElement), "", resource);
        this.generateCommandCallTree(xomElement, rootCommandCall, resource);
        return new XMLSpecification(rootCommandCall);
    }

    private void generateCommandCallTree(nu.xom.Element xomElement, CommandCall parentCommandCall, Resource resource) {
        boolean commandIsAssigned = false;
        for (int i = 0; i < xomElement.getAttributeCount(); ++i) {
            String commandName;
            Command command;
            Attribute attribute = xomElement.getAttribute(i);
            String namespaceURI = attribute.getNamespaceURI();
            if (namespaceURI.equals("") || (command = this.createCommand(namespaceURI, commandName = attribute.getLocalName())) == null) continue;
            Check.isFalse(commandIsAssigned, "Multiple commands per element is currently not supported.", new Object[0]);
            commandIsAssigned = true;
            String expression = attribute.getValue();
            CommandCall commandCall = new CommandCall(command, new Element(xomElement), expression, resource);
            parentCommandCall.appendChild(commandCall);
            parentCommandCall = commandCall;
        }
        Elements children = xomElement.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            this.generateCommandCallTree(children.get(i), parentCommandCall, resource);
        }
    }

    private Command createSpecificationCommand() {
        Command specCmd = this.createCommand("", "specification");
        return specCmd;
    }

    private Command createCommand(String namespaceURI, String commandName) {
        return this.commandFactory.createCommand(namespaceURI, commandName);
    }
}

