/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.concordion.api.ExpectedToFail;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.api.ResultSummary;
import org.concordion.api.Unimplemented;
import org.concordion.internal.FailFastException;
import org.concordion.internal.FixtureState;

public class SummarizingResultRecorder
implements ResultRecorder,
ResultSummary {
    private List<Result> recordedResults = new ArrayList<Result>();
    private FailFastException failFastException;

    public void record(Result result) {
        this.recordedResults.add(result);
    }

    public void assertIsSatisfied() {
        this.assertIsSatisfied(this);
    }

    public void assertIsSatisfied(Object fixture) {
        FixtureState state = this.getFixtureState(fixture);
        state.assertIsSatisfied(this.getSuccessCount(), this.getFailureCount(), this.getExceptionCount(), this.failFastException);
    }

    private FixtureState getFixtureState(Object fixture) {
        FixtureState state = FixtureState.EXPECTED_TO_PASS;
        if (fixture.getClass().getAnnotation(ExpectedToFail.class) != null) {
            state = FixtureState.EXPECTED_TO_FAIL;
        }
        if (fixture.getClass().getAnnotation(Unimplemented.class) != null) {
            state = FixtureState.UNIMPLEMENTED;
        }
        return state;
    }

    public boolean hasExceptions() {
        return this.getExceptionCount() > 0L;
    }

    public long getCount(Result result) {
        int count = 0;
        for (Result candidate : this.recordedResults) {
            if (candidate != result) continue;
            ++count;
        }
        return count;
    }

    public long getExceptionCount() {
        return this.getCount(Result.EXCEPTION);
    }

    public long getFailureCount() {
        return this.getCount(Result.FAILURE);
    }

    public long getSuccessCount() {
        return this.getCount(Result.SUCCESS);
    }

    public long getIgnoredCount() {
        return this.getCount(Result.IGNORED);
    }

    public void print(PrintStream out) {
        this.print(out, this);
    }

    public void print(PrintStream out, Object fixture) {
        out.print("Successes: " + this.getSuccessCount());
        out.print(", Failures: " + this.getFailureCount());
        if (this.getIgnoredCount() > 0L) {
            out.print(", Ignored: " + this.getIgnoredCount());
        }
        if (this.hasExceptions()) {
            out.print(", Exceptions: " + this.getExceptionCount());
        }
        this.getFixtureState(fixture).printNote(out);
        out.println("\n");
    }

    public void recordFailFastException(FailFastException exception) {
        this.setFailFastException(exception);
    }

    public Throwable getFailFastException() {
        return this.failFastException;
    }

    public void setFailFastException(FailFastException exception) {
        this.failFastException = exception;
    }
}

