/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal;

import java.util.ArrayList;
import org.concordion.api.Element;
import org.concordion.internal.Row;

public class Table {
    private final Element tableElement;

    public Table(Element tableElement) {
        assert (tableElement.isNamed("table"));
        this.tableElement = tableElement;
    }

    public Row getLastHeaderRow() {
        Row[] headerRows = this.getHeaderRows();
        if (headerRows.length == 0) {
            throw new RuntimeException("Table has no header row (i.e. no row containing only <th> elements)");
        }
        return headerRows[headerRows.length - 1];
    }

    private Row[] getHeaderRows() {
        ArrayList<Row> headerRows = new ArrayList<Row>();
        for (Row row : this.getRows()) {
            if (!row.isHeaderRow()) continue;
            headerRows.add(row);
        }
        return headerRows.toArray(new Row[headerRows.size()]);
    }

    public Row[] getDetailRows() {
        ArrayList<Row> detailRows = new ArrayList<Row>();
        for (Row row : this.getRows()) {
            if (row.isHeaderRow()) continue;
            detailRows.add(row);
        }
        return detailRows.toArray(new Row[detailRows.size()]);
    }

    private Row[] getRows() {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Element rowElement : this.tableElement.getDescendantElements("tr")) {
            rows.add(new Row(rowElement));
        }
        return rows.toArray(new Row[rows.size()]);
    }

    public Row addDetailRow() {
        Element rowElement = new Element("tr");
        Element tbody = this.tableElement.getFirstChildElement("tbody");
        if (tbody != null) {
            tbody.appendChild(rowElement);
        } else {
            this.tableElement.appendChild(rowElement);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            rowElement.appendChild(new Element("td"));
        }
        return new Row(rowElement);
    }

    private int getColumnCount() {
        return this.getLastHeaderRow().getCells().length;
    }
}

