/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import java.util.Comparator;
import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.api.listener.AssertEqualsListener;
import org.concordion.api.listener.AssertFailureEvent;
import org.concordion.api.listener.AssertSuccessEvent;
import org.concordion.internal.BrowserStyleWhitespaceComparator;
import org.concordion.internal.util.Announcer;
import org.concordion.internal.util.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertEqualsCommand
extends AbstractCommand {
    private Announcer<AssertEqualsListener> listeners = Announcer.to(AssertEqualsListener.class);
    private final Comparator<Object> comparator;

    public AssertEqualsCommand() {
        this(new BrowserStyleWhitespaceComparator());
    }

    public AssertEqualsCommand(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    public void addAssertEqualsListener(AssertEqualsListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeAssertEqualsListener(AssertEqualsListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void verify(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        Check.isFalse(commandCall.hasChildCommands(), "Nesting commands inside an 'assertEquals' is not supported", new Object[0]);
        Element element = commandCall.getElement();
        Object actual = evaluator.evaluate(commandCall.getExpression());
        String expected = element.getText();
        if (this.comparator.compare(actual, expected) == 0) {
            resultRecorder.record(Result.SUCCESS);
            this.announceSuccess(element);
        } else {
            resultRecorder.record(Result.FAILURE);
            this.announceFailure(element, expected, actual);
        }
    }

    private void announceSuccess(Element element) {
        this.listeners.announce().successReported(new AssertSuccessEvent(element));
    }

    private void announceFailure(Element element, String expected, Object actual) {
        this.listeners.announce().failureReported(new AssertFailureEvent(element, expected, actual));
    }
}

