/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.command;

import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Resource;
import org.concordion.api.ResultRecorder;
import org.concordion.api.listener.SpecificationProcessingEvent;
import org.concordion.api.listener.SpecificationProcessingListener;
import org.concordion.internal.FailFastException;
import org.concordion.internal.util.Announcer;

public class SpecificationCommand
extends AbstractCommand {
    private Announcer<SpecificationProcessingListener> listeners = Announcer.to(SpecificationProcessingListener.class);

    public void setUp(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        throw new IllegalStateException("Unexpected call to " + this.getClass().getSimpleName() + "'s setUp() method. Only the execute() method should be called.");
    }

    public void execute(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        this.announceBeforeProcessingEvent(commandCall.getResource(), commandCall.getElement());
        try {
            commandCall.getChildren().processSequentially(evaluator, resultRecorder);
        }
        catch (FailFastException e) {
            // empty catch block
        }
        this.announceAfterProcessingEvent(commandCall.getResource(), commandCall.getElement());
    }

    public void verify(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        throw new IllegalStateException("Unexpected call to " + this.getClass().getSimpleName() + "'s verify() method. Only the execute() method should be called.");
    }

    public void addSpecificationListener(SpecificationProcessingListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeSpecificationListener(SpecificationProcessingListener listener) {
        this.listeners.removeListener(listener);
    }

    private void announceAfterProcessingEvent(Resource resource, Element element) {
        this.listeners.announce().afterProcessingSpecification(new SpecificationProcessingEvent(resource, element));
    }

    private void announceBeforeProcessingEvent(Resource resource, Element element) {
        this.listeners.announce().beforeProcessingSpecification(new SpecificationProcessingEvent(resource, element));
    }
}

