/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.internal.runner;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.concordion.api.ExpectedToFail;
import org.concordion.api.Resource;
import org.concordion.api.Runner;
import org.concordion.api.RunnerResult;
import org.concordion.api.Unimplemented;
import org.concordion.internal.FailFastException;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConcordionRunner
implements Runner {
    private static Logger logger = Logger.getLogger(DefaultConcordionRunner.class.getName());

    @Override
    public RunnerResult execute(Resource resource, String href) throws Exception {
        Class<?> concordionClass = this.findTestClass(resource, href);
        return this.runTestClass(concordionClass);
    }

    protected Class<?> findTestClass(Resource resource, String href) throws ClassNotFoundException {
        Class<?> concordionClass;
        String name = resource.getName();
        Resource hrefResource = resource.getParent().getRelativeResource(href);
        name = hrefResource.getPath().replaceFirst("/", "").replace("/", ".").replaceAll("\\.html$", "");
        try {
            concordionClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            try {
                concordionClass = Class.forName(name + "Test");
            }
            catch (ClassNotFoundException e1) {
                concordionClass = Class.forName(name + "Fixture");
            }
        }
        return concordionClass;
    }

    protected RunnerResult runTestClass(Class<?> concordionClass) throws Exception {
        Result jUnitResult = this.runJUnitClass(concordionClass);
        return this.decodeJUnitResult(concordionClass, jUnitResult);
    }

    protected Result runJUnitClass(Class<?> concordionClass) {
        Result jUnitResult = JUnitCore.runClasses((Class[])new Class[]{concordionClass});
        return jUnitResult;
    }

    protected RunnerResult decodeJUnitResult(Class<?> concordionClass, Result jUnitResult) throws Exception {
        org.concordion.api.Result result = org.concordion.api.Result.FAILURE;
        if (jUnitResult.wasSuccessful()) {
            result = org.concordion.api.Result.SUCCESS;
            if (this.onlyPartiallyImplemented(concordionClass)) {
                result = org.concordion.api.Result.IGNORED;
            }
            if (jUnitResult.getIgnoreCount() > 0) {
                result = org.concordion.api.Result.IGNORED;
            }
        } else {
            List failures = jUnitResult.getFailures();
            for (Failure failure : failures) {
                Throwable exception = failure.getException();
                this.logExceptionIfNotAssertionError(exception);
                this.rethrowExceptionIfWarranted(concordionClass, exception);
            }
        }
        return new RunnerResult(result);
    }

    private void logExceptionIfNotAssertionError(Throwable exception) {
        if (!(exception instanceof AssertionError)) {
            logger.log(Level.WARNING, "", exception);
        }
    }

    private void rethrowExceptionIfWarranted(Class<?> concordionClass, Throwable exception) throws AssertionError, Exception {
        if (exception instanceof AssertionError) {
            if (exception.getCause() instanceof FailFastException) {
                throw (FailFastException)exception.getCause();
            }
            if (this.fullyImplemented(concordionClass)) {
                return;
            }
            throw (AssertionError)((Object)exception);
        }
        if (exception instanceof Exception) {
            throw (Exception)exception;
        }
        throw new RuntimeException(exception);
    }

    private boolean onlyPartiallyImplemented(Class<?> concordionClass) {
        return concordionClass.getAnnotation(ExpectedToFail.class) != null || concordionClass.getAnnotation(Unimplemented.class) != null;
    }

    private boolean fullyImplemented(Class<?> concordionClass) {
        return !this.onlyPartiallyImplemented(concordionClass);
    }
}

