/*
 * Decompiled with CFR 0.152.
 */
package nl.ow.dilemma.ant.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Pack200Impl {
    public static String PACK_CLASS = "java.util.jar.Pack200";

    public static boolean hasPack200() {
        try {
            Class.forName(PACK_CLASS);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    public void repack(File file) throws IOException {
        File tmpfile = new File(file.getParent(), "repack_" + UUID.randomUUID().toString() + ".tmp");
        this.pack(file, tmpfile, false);
        this.unpack(tmpfile, file, false);
        tmpfile.delete();
    }

    public void pack(File jarFile) throws IOException {
        File packedFile = new File(jarFile.getAbsolutePath() + ".pack.gz");
        this.pack(jarFile, packedFile, true);
    }

    public void unpack(File packedJarFile) throws IOException {
        String packedName = packedJarFile.getAbsolutePath();
        String jarFilename = packedName.endsWith(".pack.gz") ? packedName.substring(0, packedName.length() - 8) : "unpacked";
        File jarFile = new File(jarFilename);
        this.unpack(packedJarFile, jarFile, true);
    }

    public void pack(File jarFile, File packedJarFile, boolean zip) throws IOException {
        if (!Pack200Impl.hasPack200()) {
            System.err.println(PACK_CLASS + " not found, Pack200 features not available.");
            return;
        }
        Pack200.Packer packer = Pack200.newPacker();
        JarFile inputFile = new JarFile(jarFile);
        FileOutputStream fos = new FileOutputStream(packedJarFile);
        BufferedOutputStream os = zip ? new BufferedOutputStream(new GZIPOutputStream(fos)) : new BufferedOutputStream(fos);
        packer.pack(inputFile, (OutputStream)os);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    public void unpack(File packedJarFile, File jarFile, boolean zip) throws IOException {
        if (!Pack200Impl.hasPack200()) {
            System.err.println(PACK_CLASS + " not found, Pack200 features not available.");
            return;
        }
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        FileInputStream fis = new FileInputStream(packedJarFile);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        BufferedInputStream is = zip ? new BufferedInputStream(new GZIPInputStream(fis)) : new BufferedInputStream(fis);
        unpacker.unpack((InputStream)is, jos);
        fis.close();
        jos.flush();
        jos.close();
    }
}

