/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.FrameArea;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.LassoArea;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import lu.tudor.santec.bizcal.NamedCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarView {
    public CalendarModel broker;
    protected CalendarListener listener;
    protected List<String> bottomCategories = new ArrayList<String>();
    protected PopupMenuCallback popupMenuCallback;
    private boolean visible = false;
    private Map<String, FrameArea> _frameAreaMap = new HashMap<String, FrameArea>();
    private Map<Object, List<Object>> _eventMap = new HashMap<Object, List<Object>>();
    private List<Event> _selectedEvents = new ArrayList<Event>();
    protected Font font;
    private LassoArea _lassoArea;
    private FrameArea _newEventArea;
    private JComponent _dragArea;
    private CalendarViewConfig desc;
    private static boolean draggingEnabled = true;
    private boolean isDragging = false;
    private boolean isCreating = false;
    private boolean isResizeing = false;
    private static FrameArea originalClickedFrameArea = null;
    private static final int LINE_OFFSET = 5;
    private static boolean isMousePressed = false;
    private static boolean isResizeable = false;
    private List<JLabel> vLines = new ArrayList<JLabel>();
    private List<JLabel> hLines = new ArrayList<JLabel>();
    Map<Event, FrameArea> frameAreaHash = Collections.synchronizedMap(new HashMap());
    private JComponent calPanel;
    private Date selectionDate;
    private NamedCalendar selectedCalendar;

    public CalendarView(CalendarViewConfig desc) throws Exception {
        this.desc = desc;
        this.font = desc.getFont();
    }

    protected LayoutManager getLayout() {
        return null;
    }

    public final void refresh() throws Exception {
        this._frameAreaMap.clear();
        this._eventMap.clear();
        try {
            this.refresh0();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void refresh0() throws Exception;

    public void setBroker(CalendarModel broker) throws Exception {
        this.broker = broker;
    }

    public void setModel(CalendarModel model) {
        this.broker = model;
    }

    public void addListener(CalendarListener listener) {
        this.listener = listener;
    }

    public void addBottomCategory(String aCategory) {
        this.bottomCategories.add(aCategory);
    }

    protected void fireDateChanged(Date date) throws Exception {
        if (this.listener != null) {
            this.listener.dateChanged(date);
        }
    }

    protected DateInterval incDay(DateInterval day) throws Exception {
        DateInterval di = new DateInterval(DateUtil.move(day.getStartDate(), 1), DateUtil.move(day.getEndDate(), 1));
        return di;
    }

    protected void fireDateSelected(Date date) throws Exception {
        if (this.listener != null) {
            this.listener.dateSelected(date);
        }
    }

    protected FrameArea createFrameArea(Object calId, Event event) throws Exception {
        FrameArea area = new FrameArea();
        area.setEvent(event);
        String summary = event.getSummary();
        if (summary != null) {
            area.setDescription(summary);
        }
        DateFormat formatter = DateFormat.getTimeInstance(3, Locale.getDefault());
        StringBuffer headLineBuff = new StringBuffer();
        if (event.isShowTime()) {
            headLineBuff.append(String.valueOf(formatter.format(event.getStart())) + "-" + formatter.format(event.getEnd()) + " ");
        }
        if (event.getSummary() != null) {
            headLineBuff.append(event.getSummary());
        }
        area.setHeadLine(headLineBuff.toString());
        area.setStartTime(event.getStart());
        area.setEndTime(event.getEnd());
        if (event.getDescription() != null) {
            area.setDescription(event.getDescription());
        }
        area.setBackground(event.getColor());
        area.setBorder(event.isFrame());
        area.setRoundedRectangle(event.isRoundedCorner());
        area.showHeader(event.showHeader());
        if (event.isEditable()) {
            FrameAreaMouseListener mouseListener = new FrameAreaMouseListener(area, calId, event);
            area.addMouseListener(mouseListener);
            area.addMouseMotionListener(mouseListener);
            area.addKeyListener(new FrameAreaKeyListener(event));
        }
        if (event.isEditable()) {
            String tip = event.getToolTip();
            area.setToolTipText(tip);
        }
        area.setIcon(event.getIcon());
        area.setUpperRightIcon(event.getUpperRightIcon());
        area.setCursor(new Cursor(12));
        try {
            area.setLineDistance((Integer)event.get("linedistance"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        area.setSelected(this.isSelected(event));
        this.register(calId, event, area);
        return area;
    }

    protected void showEventpopup(MouseEvent e, Object calId, Event event) throws Exception {
        if (this.popupMenuCallback == null) {
            return;
        }
        try {
            JPopupMenu popup = this.popupMenuCallback.getEventPopupMenu(calId, event);
            popup.show(e.getComponent(), e.getX(), e.getY());
            popup.setVisible(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void showEmptyPopup(MouseEvent e, Object calId) throws Exception {
        if (this.popupMenuCallback == null) {
            return;
        }
        Date date = this.getDate(e.getPoint().x, e.getPoint().y);
        JPopupMenu popup = this.popupMenuCallback.getEmptyPopupMenu(calId, date);
        if (popup != null) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public int getTimeSlotHeight() {
        if (this.hLines != null) {
            Integer y1 = null;
            Integer y2 = null;
            for (JLabel l : this.hLines) {
                if (l.getY() <= 0) continue;
                if (y1 == null) {
                    y1 = l.getY();
                    continue;
                }
                y2 = l.getY();
                break;
            }
            if (y1 != null && y2 != null) {
                return -1 * (y1 - y2);
            }
        }
        return -1;
    }

    private int getColumnWidth() {
        if (this.vLines != null) {
            if (this.vLines.size() > 0) {
                return this.vLines.get(0).getX();
            }
            return this.calPanel.getWidth();
        }
        return -1;
    }

    public Date getSelectionDate() {
        return this.selectionDate;
    }

    private void setSelectionDate(int x, int y) {
        try {
            this.setSelectionDate(this.getDate(x, y));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSelectionDate(Date d) {
        this.selectionDate = d;
        try {
            this.fireDateSelected(this.selectionDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract Date getDate(int var1, int var2) throws Exception;

    private synchronized FrameArea findLastFrameArea(FrameArea base) {
        if (base.getChildren() == null || base.getChildren().size() < 1) {
            return null;
        }
        return base.getChildren().get(base.getChildren().size() - 1);
    }

    private int findNextGreaterHorizontalLinePos(int mouseY) {
        if (this.hLines == null) {
            return -1;
        }
        int linePos = 100000000;
        for (JLabel l : this.hLines) {
            if (l.getY() <= mouseY || l.getY() >= linePos) continue;
            linePos = l.getY();
        }
        if (linePos == 100000000) {
            return -1;
        }
        return linePos;
    }

    private int findNextSmallerHorizontalLinePos(int mouseY) {
        if (this.hLines == null) {
            return -1;
        }
        if (mouseY < this.getTimeSlotHeight()) {
            return this.calPanel.getY();
        }
        int linePos = this.calPanel.getHeight();
        for (JLabel l : this.hLines) {
            if (l.getY() >= linePos || l.getY() < mouseY - this.getTimeSlotHeight()) continue;
            linePos = l.getY();
        }
        return linePos;
    }

    private List<Integer> findUndrawnLines(int mouseXold, int mouseXnew, Integer lastFrameX) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        if (mouseXnew > mouseXold) {
            for (JLabel l : this.vLines) {
                if (l.getX() <= lastFrameX || l.getX() >= mouseXnew || returnList.contains(l.getX())) continue;
                returnList.add(l.getX());
            }
        }
        return returnList;
    }

    private int findNextGreaterVerticalLine(int mouseX) {
        if (this.vLines != null) {
            int linePos = this.calPanel.getWidth();
            for (JLabel l : this.vLines) {
                if (l.getX() <= mouseX || l.getX() >= linePos) continue;
                linePos = l.getX();
            }
            return linePos;
        }
        System.out.println("Return -1");
        return -1;
    }

    private int findNextSmallerVerticalLine(int mouseX) {
        if (this.vLines != null) {
            int linePos = -1;
            for (JLabel l : this.vLines) {
                if (l.getX() >= mouseX || l.getX() <= linePos) continue;
                linePos = l.getX();
            }
            return linePos;
        }
        return -1;
    }

    private JLabel findSmallestLine() {
        if (this.vLines == null) {
            return null;
        }
        if (this.vLines.size() == 0) {
            JLabel sL = new JLabel();
            sL.setBounds(this.calPanel.getWidth(), 0, 0, 0);
            this.vLines.add(sL);
            return sL;
        }
        if (this.vLines.size() == 1) {
            this.vLines.get(0).setBounds(this.calPanel.getWidth(), 0, 0, 0);
        }
        JLabel smallest = this.vLines.get(0);
        for (JLabel l : this.vLines) {
            if (l.getX() >= smallest.getX()) continue;
            smallest = l;
        }
        return smallest;
    }

    public void addVerticalLine(JLabel line) {
        this.vLines.add(line);
    }

    public void resetVerticalLines() {
        this.vLines.clear();
    }

    public void addHorizontalLine(JLabel line) {
        this.hLines.add(line);
    }

    public void resetHorizontalLines() {
        this.hLines.clear();
    }

    protected void addDraggingComponents(JComponent calPanel) throws Exception {
        this._lassoArea = new LassoArea();
        calPanel.add((Component)this._lassoArea, 1000);
        this._newEventArea = new FrameArea();
        this._newEventArea.setRoundedRectangle(false);
        this._newEventArea.setVisible(false);
        calPanel.add((Component)this._newEventArea, (Object)2);
        this.calPanel = calPanel;
    }

    protected Object getCalendarId(int x, int y) throws Exception {
        return null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) throws Exception {
        this.visible = visible;
        if (visible) {
            this.refresh();
        }
    }

    protected int getXOffset() {
        return 0;
    }

    protected int getCaptionRowHeight() {
        return 0;
    }

    public void setCursor(Cursor cursor) {
        this.getComponent().setCursor(cursor);
    }

    protected void register(Object calId, Event event, FrameArea area) {
        this._frameAreaMap.put("" + calId + event.getId() + event.getStart().getTime(), area);
        List<Object> list = this._eventMap.get(calId);
        if (list == null) {
            list = new ArrayList<Object>();
            this._eventMap.put(calId, list);
        }
        list.add(event);
    }

    protected FrameArea getFrameArea(Object calId, Event event) {
        return this._frameAreaMap.get("" + calId + event.getId() + event.getStart().getTime());
    }

    public void select(Object calId, Event event, boolean flag) throws Exception {
        FrameArea area = this.frameAreaHash.get(event);
        if (area != null) {
            area.setSelected(flag);
            if (area.getChildren() != null) {
                for (FrameArea fa : area.getChildren()) {
                    fa.setSelected(true);
                }
            }
        }
        if (flag) {
            if (!this._selectedEvents.contains(event)) {
                this._selectedEvents.add(event);
            }
        } else {
            this._selectedEvents.remove(event);
        }
        if (this.listener != null) {
            this.listener.eventsSelected(this._selectedEvents);
            this.listener.eventSelected(calId, event);
        }
        this.setSelectionDate(event.getStart());
    }

    public void deselect() throws Exception {
        this._selectedEvents.clear();
        for (Calendar cal : this.broker.getSelectedCalendars()) {
            Object calId = cal.getId();
            List<Object> events = this._eventMap.get(calId);
            if (events == null) {
                return;
            }
            for (Event event : events) {
                FrameArea area = this.frameAreaHash.get(event);
                if (area == null) continue;
                area.setSelected(false);
                if (area.getChildren() == null) continue;
                for (FrameArea fa : area.getChildren()) {
                    fa.setSelected(false);
                }
            }
        }
        if (this.listener != null) {
            this.listener.eventsSelected(this._selectedEvents);
            this.listener.selectionReset();
        }
        this.calPanel.requestFocus();
    }

    public void copy() throws Exception {
        this.listener.copy(this._selectedEvents);
    }

    protected boolean supportsDrag() {
        return true;
    }

    private void lasso(Object id, Date date1, Date date2) throws Exception {
        this.deselect();
        if (DateUtil.round2Day(date1).getTime() != DateUtil.round2Day(date2).getTime()) {
            TimeOfDay startTime = DateUtil.getTimeOfDay(date1);
            TimeOfDay endTime = DateUtil.getTimeOfDay(date2);
            Date date = date1;
            while (true) {
                Date start = DateUtil.setTimeOfDate(date, startTime);
                Date end = DateUtil.setTimeOfDate(date, endTime);
                if (!end.after(date2)) {
                    this._selectedEvents.addAll(this.getEditibleEvents(id, new DateInterval(start, end)));
                    date = DateUtil.getDiffDay(date, 1);
                    continue;
                }
                break;
            }
        } else {
            this._selectedEvents.addAll(this.getEditibleEvents(id, new DateInterval(date1, date2)));
        }
        for (Event event : this._selectedEvents) {
            FrameArea area = this.getFrameArea(id, event);
            area.setSelected(true);
            if (this.listener == null) continue;
            this.listener.eventSelected(id, event);
        }
        if (this.listener != null) {
            this.listener.eventsSelected(this._selectedEvents);
        }
    }

    private List<Event> getEditibleEvents(Object calId, DateInterval interval) throws Exception {
        ArrayList<Event> result = new ArrayList<Event>();
        List<Object> events = this._eventMap.get(calId);
        if (events == null || events.size() < 1) {
            return result;
        }
        for (Event event : events) {
            DateInterval eventInterval;
            boolean overlap;
            if (!event.isEditable() || !(overlap = (eventInterval = new DateInterval(event.getStart(), event.getEnd())).overlap(interval))) continue;
            result.add(event);
        }
        return result;
    }

    private boolean isSelected(Event event) {
        if (event == null) {
            return false;
        }
        for (Event tmpEvent : this._selectedEvents) {
            if (!tmpEvent.getId().equals(event.getId())) continue;
            return true;
        }
        return false;
    }

    public void setDescriptor(CalendarViewConfig desc) {
        this.desc = desc;
    }

    public CalendarViewConfig getDescriptor() {
        return this.desc;
    }

    protected JComponent createCorner(boolean left, boolean top) throws Exception {
        String direction = "LEFT_RIGHT";
        if (!left && top) {
            direction = "TOP_BOTTOM";
        } else if (left && top) {
            direction = "TOPLEFT_BOTTOMRIGHT";
        }
        GradientArea area = new GradientArea(direction, Color.WHITE, ColumnHeaderPanel.GRADIENT_COLOR);
        area.setOpaque(true);
        area.setBorder(false);
        return area;
    }

    protected int getInitYPos() throws Exception {
        return 0;
    }

    protected List<?> getSelectedCalendars() throws Exception {
        return this.broker.getSelectedCalendars();
    }

    protected DateInterval getInterval() throws Exception {
        return this.broker.getInterval();
    }

    public CalendarModel getModel() {
        return this.broker;
    }

    protected FrameArea getBaseFrameArea(Event e) {
        return this.frameAreaHash.get(e);
    }

    protected Map<Date, List<Event>> createEventsPerDay(Object calId) throws Exception {
        HashMap<Date, List<Event>> map = new HashMap<Date, List<Event>>();
        List<Event> eventList = this.getModel().getEvents(calId);
        if (eventList != null) {
            for (Event event : eventList) {
                Date date = DateUtil.round2Day(event.getStart());
                List<Event> events = (ArrayList<Event>)map.get(date);
                if (events == null) {
                    events = new ArrayList<Event>();
                    map.put(date, events);
                }
                events.add(event);
                if (DateUtil.isSameDay(event.getStart(), event.getEnd())) continue;
                Date next = DateUtil.move(event.getStart(), 1);
                while (DateUtil.isBeforeDay(next, event.getEnd()) || DateUtil.isSameDay(event.getEnd(), next)) {
                    date = DateUtil.round2Day(next);
                    events = (List)map.get(date);
                    if (events == null) {
                        events = new ArrayList();
                        map.put(date, events);
                    }
                    events.add(event);
                    next = DateUtil.move(next, 1);
                }
            }
        }
        return map;
    }

    public abstract JComponent getComponent();

    public void clear() {
        this._selectedEvents.clear();
    }

    public static Point convertPoint(Point p, Component source, Component target) {
        Point pNew = new Point(p);
        SwingUtilities.convertPointToScreen(pNew, source);
        SwingUtilities.convertPointFromScreen(pNew, target);
        return pNew;
    }

    public void setSelectedCalendarInCV(NamedCalendar selectedCalendar) {
        this.selectedCalendar = selectedCalendar;
    }

    public boolean getIsCreating() {
        return this.isCreating;
    }

    public boolean getIsDragging() {
        return this.isDragging;
    }

    public boolean getIsResizeing() {
        return this.isResizeing;
    }

    protected class CalHeaderMouseListener
    extends MouseAdapter {
        private Object calId;

        public CalHeaderMouseListener(Object calId) {
            this.calId = calId;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup = CalendarView.this.popupMenuCallback.getCalendarPopupMenu(this.calId);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
            catch (Exception exc) {
                throw BizcalException.create(exc);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class FrameAreaKeyListener
    extends KeyAdapter {
        private Event _event;

        public FrameAreaKeyListener(Event event) {
            this._event = event;
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            try {
                if (event.isControlDown() && event.getKeyCode() == 67) {
                    CalendarView.this.copy();
                }
                if (event.isControlDown() && event.getKeyCode() == 86 && CalendarView.this.listener != null) {
                    CalendarView.this.listener.paste(null, CalendarView.this.getSelectionDate());
                }
                if ((event.getKeyCode() == 127 || event.getKeyCode() == 8) && CalendarView.this.listener != null) {
                    CalendarView.this.listener.deleteEvents(CalendarView.this._selectedEvents);
                }
            }
            catch (Exception exc) {
                throw BizcalException.create(exc);
            }
        }

        public void keyReleased(KeyEvent event) {
        }
    }

    private class FrameAreaMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point _startDrag;
        private FrameArea _frameArea;
        private Object _calId;
        private Event _event;
        private Cursor resizeCursor = new Cursor(9);
        private Cursor handCursor = new Cursor(12);
        private FrameArea lastCreatedFrameArea = null;
        private Integer mouseXold = -1;
        private HashMap<Integer, FrameArea> additionalFrames = new HashMap();
        private List<FrameArea> deletedFrameAreas = Collections.synchronizedList(new ArrayList());
        private boolean _shiftKey = false;
        private boolean dragged;
        private long lastEventTime = 0L;
        private FrameArea baseArea;
        private static final int DEFAULT_SIZE_Y_RESIZE_REGION = 6;
        private int resizeRegionY = 6;
        private boolean isPopupTrigger = false;

        public FrameAreaMouseListener(FrameArea frameArea, Object calId, Event event) {
            this._frameArea = frameArea;
            this._calId = calId;
            this._event = event;
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.isPopupTrigger = true;
            }
            isMousePressed = true;
            this.dragged = false;
            if (originalClickedFrameArea == null) {
                originalClickedFrameArea = this._frameArea;
            }
            try {
                if (e.getClickCount() == 1 && this._event.isSelectable()) {
                    FrameArea area = this.getBaseArea();
                    if ((e.getModifiersEx() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        if (area.isSelected()) {
                            CalendarView.this.select(this._calId, this._event, false);
                        } else {
                            CalendarView.this.select(this._calId, this._event, true);
                        }
                    } else {
                        CalendarView.this.deselect();
                        CalendarView.this.select(this._calId, this._event, true);
                    }
                    CalendarView.this._lassoArea.setVisible(false);
                    this._frameArea.requestFocus();
                    if (CalendarView.this.listener != null) {
                        CalendarView.this.listener.eventClicked(this._calId, this._event, area, e);
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            FrameArea baseFrameArea = this.getBaseArea();
            this._startDrag = e.getPoint();
            this.additionalFrames.clear();
            if (baseFrameArea.getChildren() != null) {
                for (FrameArea fa : baseFrameArea.getChildren()) {
                    this.additionalFrames.put(fa.getX(), fa);
                }
            }
            this.lastCreatedFrameArea = CalendarView.this.findLastFrameArea(baseFrameArea);
            CalendarView.this.calPanel.repaint();
        }

        private void removeAdditionalArea(FrameArea fa) {
            ArrayList<Integer> keys = new ArrayList<Integer>();
            for (Integer key : this.additionalFrames.keySet()) {
                if (!this.additionalFrames.get(key).equals(fa)) continue;
                keys.add(key);
            }
            for (Integer k : keys) {
                this.additionalFrames.remove(k);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isPopupTrigger || e.isPopupTrigger()) {
                this.showPopup(e);
            } else {
                CalendarView.this.isDragging = false;
                CalendarView.this.isResizeing = false;
                FrameArea baseFrameArea = this.getBaseArea();
                if (!baseFrameArea.equals(this._frameArea)) {
                    baseFrameArea.getMouseListeners()[0].mouseReleased(e);
                    return;
                }
                for (FrameArea fa : this.deletedFrameAreas) {
                    fa.setVisible(false);
                    CalendarView.this.calPanel.remove(fa);
                    this.removeAdditionalArea(fa);
                }
                this.deletedFrameAreas.clear();
                CalendarView.this.getComponent().revalidate();
                try {
                    if (CalendarView.this.listener != null) {
                        if (isResizeable) {
                            Date movDate;
                            FrameArea fa;
                            fa = CalendarView.this.findLastFrameArea(baseFrameArea);
                            if (fa == null) {
                                fa = baseFrameArea;
                            }
                            if (!(movDate = CalendarView.this.getDate(fa.getX() + 5, fa.getY() + fa.getHeight())).equals(this._event.getStart())) {
                                CalendarView.this.listener.resized(this._event, this._calId, this._event.getEnd(), CalendarView.this.getDate(fa.getX() + 5, fa.getY() + fa.getHeight()));
                            }
                        } else {
                            Date eventDateNew = CalendarView.this.getDate(baseFrameArea.getX() + 5, baseFrameArea.getY());
                            if (this.dragged && !DateUtil.round2Minute(eventDateNew).equals(DateUtil.round2Minute(this._event.getStart()))) {
                                CalendarView.this.listener.moved(this._event, this._calId, this._event.getStart(), this._calId, eventDateNew);
                            }
                            if (e.getClickCount() == 1 && this._event.isSelectable()) {
                                FrameArea area = CalendarView.this.getFrameArea(this._calId, this._event);
                                CalendarView.this.listener.eventClicked(this._calId, this._event, area, e);
                            }
                            if (e.getClickCount() == 2 && this._event.isSelectable()) {
                                CalendarView.this.select(this._calId, this._event, true);
                                isMousePressed = false;
                                CalendarView.this.listener.eventDoubleClick(this._calId, this._event, e);
                                return;
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    ErrorHandler.handleError(exc);
                }
                this._frameArea.setIsMoving(false);
                originalClickedFrameArea = null;
                isMousePressed = false;
            }
        }

        public void mouseEntered(MouseEvent e) {
            FrameArea baseFrameArea = this.getBaseArea();
            if (!baseFrameArea.equals(this._frameArea)) {
                baseFrameArea.getMouseListeners()[0].mouseEntered(e);
                return;
            }
            if (isMousePressed) {
                return;
            }
            isResizeable = false;
            try {
                if (!this._event.isSelectable()) {
                    return;
                }
                if (!this._frameArea.isSelected()) {
                    if (this._frameArea.getChildren() != null) {
                        for (FrameArea fa : this._frameArea.getChildren()) {
                            fa.setBrightness(true);
                            fa.setBorder(true);
                        }
                    }
                    this._frameArea.setBrightness(true);
                    this._frameArea.setBorder(true);
                    CalendarView.this.calPanel.repaint();
                }
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }

        public void mouseExited(MouseEvent e) {
            FrameArea baseFrameArea = this.getBaseArea();
            if (!baseFrameArea.equals(this._frameArea)) {
                baseFrameArea.getMouseListeners()[0].mouseExited(e);
                return;
            }
            if (isMousePressed) {
                return;
            }
            if (isResizeable) {
                isResizeable = false;
                baseFrameArea.setCursor(new Cursor(0));
            }
            try {
                if (!this._event.isSelectable() || this._frameArea.isSelected()) {
                    return;
                }
                CalendarView.this.getComponent().setCursor(new Cursor(0));
                this._frameArea.setBrightness(false);
                if (this._frameArea.getChildren() != null) {
                    for (FrameArea fa : this._frameArea.getChildren()) {
                        fa.setBrightness(false);
                        fa.setBorder(false);
                    }
                }
                CalendarView.this.calPanel.repaint();
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        private void showPopup(MouseEvent e) {
            try {
                FrameArea area = CalendarView.this.getFrameArea(this._calId, this._event);
                if (this._event.isSelectable() && !area.isSelected()) {
                    CalendarView.this.deselect();
                    CalendarView.this.select(this._calId, this._event, true);
                }
                CalendarView.this.showEventpopup(e, this._calId, this._event);
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }

        private FrameArea getBaseArea() {
            if (this.baseArea == null) {
                this.baseArea = CalendarView.this.frameAreaHash.get(this._event);
            }
            return this.baseArea;
        }

        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.lastEventTime == 0L) {
                    this.lastEventTime = System.currentTimeMillis();
                } else {
                    long current = System.currentTimeMillis();
                    if (current - this.lastEventTime < 15L) {
                        return;
                    }
                    this.lastEventTime = current;
                }
                FrameArea baseFrameArea = this.getBaseArea();
                try {
                    ((FrameAreaMouseListener)baseFrameArea.getMouseListeners()[0]).dragged = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.dragged = true;
                this._shiftKey = (e.getModifiersEx() & 0x40) != 0;
                try {
                    if (isResizeable) {
                        CalendarView.this.isResizeing = true;
                        this.resizeDrag(baseFrameArea, e);
                    } else {
                        CalendarView.this.isDragging = true;
                        this.moveDrag(baseFrameArea, e);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            FrameArea baseFrameArea = CalendarView.this.frameAreaHash.get(this._event);
            if (baseFrameArea.getHeight() <= 12) {
                this.resizeRegionY = baseFrameArea.getHeight() / 2;
                if (this.resizeRegionY <= 0) {
                    this.resizeRegionY = 5;
                }
            }
            FrameArea areaToChange = null;
            areaToChange = CalendarView.this.findLastFrameArea(baseFrameArea);
            if (areaToChange == null) {
                areaToChange = baseFrameArea;
            }
            if (!areaToChange.getCursor().equals(this.resizeCursor)) {
                if (e.getPoint().y > areaToChange.getHeight() - this.resizeRegionY && e.getSource().equals(areaToChange)) {
                    areaToChange.setCursor(this.resizeCursor);
                    isResizeable = true;
                    e.consume();
                    return;
                }
            } else if (!areaToChange.getCursor().equals(this.handCursor) && e.getPoint().y < areaToChange.getHeight() - this.resizeRegionY) {
                areaToChange.setCursor(this.handCursor);
                isResizeable = false;
                e.consume();
                return;
            }
        }

        private void moveDrag(FrameArea baseFrameArea, MouseEvent e) {
            int currX = this._frameArea.getX();
            int currWidth = this._frameArea.getWidth();
            int nextSmaller = CalendarView.this.findNextSmallerVerticalLine(currX + 5);
            int nextGreater = CalendarView.this.findNextGreaterVerticalLine(currX + 5);
            int gap2left = currX - nextSmaller;
            int gap2right = nextGreater - currX - currWidth;
            baseFrameArea.setIsMoving(true);
            Integer newXPos = null;
            if (e.getPoint().x < 0) {
                if (gap2left + e.getPoint().x < 0) {
                    newXPos = CalendarView.this.findNextSmallerVerticalLine(baseFrameArea.getX() - 5);
                }
            } else if (e.getPoint().x > currWidth && e.getPoint().x > currWidth + gap2right) {
                newXPos = CalendarView.this.findNextGreaterVerticalLine(baseFrameArea.getX());
            }
            if (newXPos != null && newXPos <= CalendarView.this.calPanel.getX() + CalendarView.this.calPanel.getWidth()) {
                int y = baseFrameArea.getY();
                int width = baseFrameArea.getWidth();
                int height = baseFrameArea.getHeight();
                baseFrameArea.setBounds(newXPos, y, width, height);
                if (baseFrameArea.getChildren() != null && baseFrameArea.getChildren().size() > 0) {
                    int countX = 1;
                    for (FrameArea ac : baseFrameArea.getChildren()) {
                        int acNewX = baseFrameArea.getX();
                        int i = 0;
                        while (i < countX) {
                            acNewX = CalendarView.this.findNextGreaterVerticalLine(acNewX);
                            ++i;
                        }
                        ++countX;
                        ac.setBounds(acNewX, ac.getY(), width, ac.getHeight());
                    }
                }
            } else {
                int maus_y = e.getPoint().y;
                int diffPoint = this._startDrag.y - maus_y;
                if (Math.abs(diffPoint) > CalendarView.this.getTimeSlotHeight() || this._shiftKey) {
                    int mov;
                    if (this._shiftKey) {
                        mov = Math.abs(diffPoint);
                    } else {
                        mov = 0;
                        int sy = 0;
                        int gy = 0;
                        int lastLy = 0;
                        for (JLabel l : CalendarView.this.hLines) {
                            if (Integer.valueOf(l.getY()) > baseFrameArea.getY() - diffPoint) {
                                sy = lastLy;
                                gy = l.getY();
                                break;
                            }
                            lastLy = l.getY();
                        }
                        if (diffPoint < maus_y) {
                            baseFrameArea.setBounds(baseFrameArea.getX(), sy, baseFrameArea.getWidth(), baseFrameArea.getHeight());
                        }
                        if (diffPoint > maus_y) {
                            baseFrameArea.setBounds(baseFrameArea.getX(), gy, baseFrameArea.getWidth(), baseFrameArea.getHeight());
                        }
                    }
                    if (this._startDrag.y > maus_y) {
                        mov *= -1;
                    }
                    if (baseFrameArea.getY() + mov >= CalendarView.this.calPanel.getY()) {
                        baseFrameArea.setBounds(baseFrameArea.getX(), baseFrameArea.getY() + mov, baseFrameArea.getWidth(), baseFrameArea.getHeight());
                        FrameArea lastArea = CalendarView.this.findLastFrameArea(baseFrameArea);
                        if (baseFrameArea.getChildren() != null && baseFrameArea.getChildren().size() > 0) {
                            baseFrameArea.setBounds(baseFrameArea.getX(), baseFrameArea.getY(), baseFrameArea.getWidth(), CalendarView.this.calPanel.getHeight() - baseFrameArea.getY());
                        }
                        if (lastArea != null) {
                            lastArea.setBounds(lastArea.getX(), lastArea.getY(), lastArea.getWidth(), lastArea.getHeight() + mov);
                        }
                        if (!this._frameArea.equals(baseFrameArea)) {
                            this.mousePressed(e);
                        }
                    }
                }
            }
            try {
                this._frameArea.setMovingTimeString(CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY()), CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY() + this._frameArea.getHeight()));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        private void resizeDrag(FrameArea baseFrameArea, MouseEvent e) {
            int currX = this._frameArea.getX();
            int currY = this._frameArea.getY();
            int currWidth = this._frameArea.getWidth();
            int nextSmaller = CalendarView.this.findNextSmallerVerticalLine(currX + 5);
            int nextGreater = CalendarView.this.findNextGreaterVerticalLine(currX + 5);
            int gap2leftColumn = currX - nextSmaller;
            int gap2rightColumn = nextGreater - currX - currWidth;
            baseFrameArea.setIsMoving(true);
            FrameArea currentArea = this._frameArea;
            Point currentPoint = e.getPoint();
            if (baseFrameArea.getChildren() != null && baseFrameArea.getChildren().size() > 0) {
                currentArea = baseFrameArea.getChildren().get(baseFrameArea.getChildren().size() - 1);
                currentPoint = CalendarView.convertPoint(e.getPoint(), this._frameArea, currentArea);
            } else if (!this._frameArea.isVisible()) {
                currentArea = baseFrameArea;
                currentPoint = CalendarView.convertPoint(e.getPoint(), this._frameArea, currentArea);
            }
            currX = currentArea.getX();
            currY = currentArea.getY();
            currWidth = currentArea.getWidth();
            gap2leftColumn = currX - CalendarView.this.findNextSmallerVerticalLine(currX + 5);
            gap2rightColumn = CalendarView.this.findNextGreaterVerticalLine(currX + 5) - currX - currWidth;
            if (currentArea.getHeight() + currentPoint.y < CalendarView.this.desc.getMinimumTimeSlotHeight() || currentArea.getHeight() + currentPoint.y < CalendarView.this.getTimeSlotHeight()) {
                return;
            }
            if (gap2leftColumn + currentPoint.x < 0 || currentPoint.x > currWidth + gap2rightColumn) {
                if (gap2leftColumn + currentPoint.x < 0) {
                    if (baseFrameArea.getChildren() != null) {
                        ArrayList<FrameArea> deleteAreas = new ArrayList<FrameArea>();
                        for (FrameArea fa : baseFrameArea.getChildren()) {
                            if (fa.getX() <= CalendarView.this.findNextSmallerVerticalLine(currX + currentPoint.x)) continue;
                            fa.setVisible(false);
                            deleteAreas.add(fa);
                            this.deletedFrameAreas.add(fa);
                        }
                        baseFrameArea.getChildren().removeAll(deleteAreas);
                    }
                } else {
                    int crossPoint = 0;
                    crossPoint = currentPoint.x;
                    if (crossPoint > currWidth + gap2rightColumn) {
                        List newLines = null;
                        newLines = CalendarView.this.findUndrawnLines(currX + this.mouseXold, currX + currentPoint.x, baseFrameArea.getX());
                        if (newLines != null && newLines.size() > 0) {
                            currentArea.setBounds(currentArea.getX(), 0, currWidth, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                            for (Integer i : newLines) {
                                if (this.additionalFrames.containsKey(i)) {
                                    FrameArea afa = this.additionalFrames.get(i);
                                    if (afa.isVisible()) {
                                        this.lastCreatedFrameArea = afa;
                                        continue;
                                    }
                                    if (!baseFrameArea.getChildren().contains(afa)) {
                                        baseFrameArea.addChild(afa);
                                        if (this.deletedFrameAreas.contains(afa)) {
                                            this.deletedFrameAreas.remove(afa);
                                        }
                                    }
                                    afa.setVisible(true);
                                    afa.setBounds(afa.getX(), 0, currWidth, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                                    this.lastCreatedFrameArea = afa;
                                    continue;
                                }
                                FrameArea fa = new FrameArea();
                                fa.setBounds(i, 0, currWidth, CalendarView.this.findNextGreaterHorizontalLinePos(currY + currentPoint.y));
                                fa.setEvent(this._event);
                                CalendarView.this.calPanel.add((Component)fa, (Object)3);
                                CalendarView.this.calPanel.validate();
                                CalendarView.this.calPanel.updateUI();
                                fa.setVisible(true);
                                this.additionalFrames.put(i, fa);
                                baseFrameArea.addChild(fa);
                                if (this.lastCreatedFrameArea != null) {
                                    this.lastCreatedFrameArea.setBounds(this.lastCreatedFrameArea.getX(), 0, currWidth, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                                }
                                this.lastCreatedFrameArea = fa;
                                currentPoint = CalendarView.convertPoint(currentPoint, currentArea, fa);
                                currentArea = fa;
                            }
                        }
                    }
                }
            } else {
                int newHeight = 0;
                newHeight = this._shiftKey ? currentPoint.y : CalendarView.this.findNextGreaterHorizontalLinePos(currentPoint.y);
                currentArea.setBounds(currX, currY, currWidth, newHeight);
            }
            try {
                this._frameArea.setMovingTimeString(CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY()), CalendarView.this.getDate(this._frameArea.getX(), this._frameArea.getY() + this._frameArea.getHeight()));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    protected class ThisKeyListener
    extends KeyAdapter {
        private int SHIFT = 16;
        private int CTRL = 17;

        protected ThisKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == this.SHIFT) {
                CalendarView.this.getComponent().setCursor(new Cursor(1));
            }
            try {
                if (event.isControlDown() && event.getKeyCode() == 67) {
                    CalendarView.this.copy();
                }
                if (event.isControlDown() && event.getKeyCode() == 86 && CalendarView.this.listener != null) {
                    CalendarView.this.listener.paste(null, CalendarView.this.getSelectionDate());
                }
            }
            catch (Exception exc) {
                throw BizcalException.create(exc);
            }
        }

        public void keyReleased(KeyEvent event) {
            try {
                if (event.getKeyCode() == this.SHIFT || event.getKeyCode() == this.CTRL) {
                    CalendarView.this.getComponent().setCursor(null);
                }
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }
    }

    protected class ThisMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point _startDrag;
        private boolean _dragging = false;
        private boolean _lasso = true;
        private Object _dragCalId = null;
        private int currPos = 0;
        private HashMap<Integer, FrameArea> additionalFrames = new HashMap();
        private FrameArea lastCreatedFrameArea = null;
        private Integer lastCreatedKey = null;
        private int mouseXold = -1;
        private int startDragMouseY = -1;

        protected ThisMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            } else {
                try {
                    if (e.getClickCount() < 2) {
                        int lx = CalendarView.this.findNextSmallerVerticalLine(e.getX());
                        int ly = CalendarView.this.findNextSmallerHorizontalLinePos(e.getY());
                        int lwidth = CalendarView.this.findNextGreaterVerticalLine(e.getX()) - lx;
                        int lheight = CalendarView.this.getTimeSlotHeight();
                        CalendarView.this._lassoArea.setBounds(lx, ly, lwidth, lheight);
                        CalendarView.this.setSelectionDate(lx + lwidth / 2, ly);
                        CalendarView.this._lassoArea.setVisible(true);
                    } else {
                        int newY = CalendarView.this.findNextSmallerHorizontalLinePos(e.getPoint().y);
                        Date date = CalendarView.this.getDate(e.getPoint().x, newY);
                        Object id = CalendarView.this.getCalendarId(e.getPoint().x, e.getPoint().y);
                        if (CalendarView.this.listener == null) {
                            return;
                        }
                        if (!CalendarView.this.getModel().isInsertable(id, date)) {
                            return;
                        }
                        CalendarView.this.listener.newEvent(id, date);
                    }
                }
                catch (Exception exc) {
                    ErrorHandler.handleError(exc);
                }
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    Object id = CalendarView.this.getCalendarId(e.getPoint().x, e.getPoint().y);
                    CalendarView.this.showEmptyPopup(e, id);
                }
            }
            catch (Exception exc) {
                throw BizcalException.create(exc);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            } else {
                try {
                    CalendarView.this.deselect();
                    this._startDrag = e.getPoint();
                    this._dragCalId = CalendarView.this.getCalendarId(e.getPoint().x, e.getPoint().y);
                    this._lasso = (e.getModifiersEx() & 0x40) != 0;
                }
                catch (Exception exc) {
                    throw BizcalException.create(exc);
                }
                this.startDragMouseY = CalendarView.this.findNextSmallerHorizontalLinePos(e.getPoint().y);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && draggingEnabled) {
                this.maybeShowPopup(e);
            } else {
                CalendarView.this.isCreating = false;
                try {
                    this._dragging = false;
                    if (CalendarView.this._dragArea == null) {
                        return;
                    }
                    Object calendarId = null;
                    try {
                        calendarId = CalendarView.this.getCalendarId(e.getPoint().x, e.getPoint().y);
                    }
                    catch (Exception e1) {
                        return;
                    }
                    Date date1 = CalendarView.this.getDate(CalendarView.this._dragArea.getX() + 5, CalendarView.this._dragArea.getY());
                    Date date2 = null;
                    if (this.additionalFrames != null && this.additionalFrames.size() > 0) {
                        ArrayList<Integer> keys = new ArrayList<Integer>(this.additionalFrames.keySet());
                        Collections.sort(keys);
                        FrameArea lastArea = this.additionalFrames.get(keys.get(keys.size() - 1));
                        date2 = CalendarView.this.getDate(lastArea.getX() + 2, lastArea.getY() + lastArea.getHeight());
                    } else {
                        date2 = CalendarView.this.getDate(CalendarView.this._dragArea.getX() + 10, CalendarView.this._dragArea.getY() + CalendarView.this._dragArea.getHeight());
                    }
                    if (this._lasso) {
                        int rightLowerCornerX = CalendarView.this._dragArea.getX() + CalendarView.this._dragArea.getWidth();
                        int rightLowerCornerY = CalendarView.this._dragArea.getY() + CalendarView.this._dragArea.getHeight();
                        Date lowerRightDate = CalendarView.this.getDate(rightLowerCornerX, rightLowerCornerY);
                        CalendarView.this.lasso(calendarId, date1, lowerRightDate);
                    }
                    if (!this._lasso && CalendarView.this.listener != null) {
                        if (CalendarView.this.selectedCalendar.getId() != null) {
                            CalendarView.this.listener.newEvent((Object)CalendarView.this.selectedCalendar.getId(), new DateInterval(date1, date2));
                        } else {
                            CalendarView.this.listener.newEvent(this._dragCalId, new DateInterval(date1, date2));
                        }
                    }
                    CalendarView.this._dragArea.setVisible(false);
                    if (this.additionalFrames != null && this.additionalFrames.values() != null) {
                        for (FrameArea a : this.additionalFrames.values()) {
                            a.setVisible(false);
                        }
                    }
                    CalendarView.this._dragArea.setCursor(new Cursor(0));
                    this._lasso = false;
                    CalendarView.this._dragArea = null;
                    this._dragCalId = null;
                }
                catch (Exception exc) {
                    throw BizcalException.create(exc);
                }
                draggingEnabled = true;
            }
        }

        public void mouseDragged(MouseEvent e) {
            try {
                int gap;
                CalendarView.this.isCreating = true;
                if (!this._dragging) {
                    Date date;
                    this._dragging = true;
                    Object id = CalendarView.this.getCalendarId(e.getPoint().x, e.getPoint().y);
                    if (!CalendarView.this.broker.isInsertable(id, date = CalendarView.this.getDate(e.getPoint().x, e.getPoint().y))) {
                        return;
                    }
                    if (this._lasso) {
                        CalendarView.this._dragArea = CalendarView.this._lassoArea;
                    } else {
                        CalendarView.this._dragArea = CalendarView.this._newEventArea;
                    }
                    CalendarView.this._dragArea.setVisible(true);
                    CalendarView.this._dragArea.setBounds(e.getPoint().x, e.getPoint().y, 1, CalendarView.this.getTimeSlotHeight());
                    CalendarView.this.getComponent().revalidate();
                }
                if (CalendarView.this._dragArea == null) {
                    return;
                }
                Object calId = null;
                try {
                    calId = CalendarView.this.getCalendarId(e.getPoint().x, e.getPoint().y);
                }
                catch (Exception et) {
                    return;
                }
                if (!calId.equals(this._dragCalId)) {
                    e.consume();
                    return;
                }
                int y = this.startDragMouseY;
                int pX = e.getPoint().x;
                int pY = CalendarView.this.findNextGreaterHorizontalLinePos(e.getPoint().y);
                Integer offset = null;
                if (draggingEnabled) {
                    CalendarView.this._dragArea.setCursor(new Cursor(9));
                    if (pX >= this._startDrag.x) {
                        if (pX < CalendarView.this.findSmallestLine().getX()) {
                            this.currPos = 0;
                        } else {
                            for (JLabel l : CalendarView.this.vLines) {
                                Integer xpos = l.getX();
                                if (pX < xpos) continue;
                                if (offset == null) {
                                    offset = pX - xpos;
                                    this.currPos = xpos;
                                    continue;
                                }
                                if (offset <= pX - xpos) continue;
                                offset = pX - xpos;
                                this.currPos = xpos;
                            }
                        }
                    }
                    if (CalendarView.this._dragArea instanceof FrameArea) {
                        ((FrameArea)CalendarView.this._dragArea).setStartTime(CalendarView.this.getDate(this.currPos, this.startDragMouseY));
                    }
                }
                try {
                    gap = ((JLabel)CalendarView.this.vLines.get(0)).getX();
                }
                catch (Exception ec) {
                    gap = CalendarView.this.calPanel.getWidth();
                }
                if (pX >= this.currPos) {
                    if (pX <= this.currPos || pX >= this.currPos + gap) {
                        List newLines;
                        if (this._lasso) {
                            newLines = CalendarView.this.findUndrawnLines(this.mouseXold, e.getPoint().x, this.currPos);
                            int dx = CalendarView.this._dragArea.getX();
                            Integer max = dx;
                            try {
                                max = (Integer)Collections.max(newLines);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int dy = CalendarView.this._dragArea.getY();
                            int dw = max - dx + CalendarView.this.getColumnWidth();
                            CalendarView.this._dragArea.setBounds(dx, dy, dw, CalendarView.this.findNextGreaterHorizontalLinePos(e.getPoint().y) - dy);
                            CalendarView.this.getComponent().revalidate();
                            return;
                        }
                        if (this.lastCreatedFrameArea != null && pX <= this.lastCreatedFrameArea.getX()) {
                            this.additionalFrames.values().remove(this.lastCreatedFrameArea);
                            this.lastCreatedFrameArea.setVisible(false);
                            CalendarView.this.calPanel.remove(this.lastCreatedFrameArea);
                            this.additionalFrames.remove(this.lastCreatedKey);
                            Integer biggest = 0;
                            for (Integer k : this.additionalFrames.keySet()) {
                                if (k <= biggest) continue;
                                biggest = k;
                            }
                            this.lastCreatedFrameArea = this.additionalFrames.get(biggest);
                            this.lastCreatedKey = biggest;
                        }
                        newLines = null;
                        newLines = this.lastCreatedKey == null ? CalendarView.this.findUndrawnLines(this.mouseXold, e.getPoint().x, this.currPos) : CalendarView.this.findUndrawnLines(this.mouseXold, e.getPoint().x, this.lastCreatedKey);
                        if (newLines != null && newLines.size() > 0) {
                            for (Integer i : newLines) {
                                if (this.additionalFrames.containsKey(i)) continue;
                                FrameArea fa = new FrameArea();
                                fa.setBounds(i, 0, gap, pY);
                                CalendarView.this.calPanel.add((Component)fa, (Object)3);
                                fa.setVisible(true);
                                this.additionalFrames.put(i, fa);
                                if (this.lastCreatedFrameArea != null) {
                                    this.lastCreatedFrameArea.setBounds(this.lastCreatedFrameArea.getX(), 0, gap, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                                }
                                this.lastCreatedFrameArea = fa;
                                this.lastCreatedKey = i;
                            }
                            CalendarView.this._dragArea.setBounds(this.currPos, y, gap, ((CalendarView)CalendarView.this).calPanel.getMaximumSize().height);
                        }
                        try {
                            this.lastCreatedFrameArea.setBounds(this.lastCreatedFrameArea.getX(), 0, gap, CalendarView.this.findNextGreaterHorizontalLinePos(e.getPoint().y));
                            this.lastCreatedFrameArea.setEndTime(CalendarView.this.getDate(this.currPos, this.lastCreatedFrameArea.getY() + this.lastCreatedFrameArea.getHeight()));
                        }
                        catch (Exception exception) {}
                    } else {
                        for (Integer k : this.additionalFrames.keySet()) {
                            this.additionalFrames.get(k).setVisible(false);
                            CalendarView.this.calPanel.remove(this.additionalFrames.get(k));
                        }
                        this.additionalFrames.clear();
                        this.lastCreatedFrameArea = null;
                        this.lastCreatedKey = null;
                        CalendarView.this._dragArea.setBounds(this.currPos, y, gap, CalendarView.this.findNextGreaterHorizontalLinePos(e.getPoint().y) - y);
                        if (CalendarView.this._dragArea instanceof FrameArea) {
                            ((FrameArea)CalendarView.this._dragArea).setEndTime(CalendarView.this.getDate(this.currPos, CalendarView.this._dragArea.getY() + CalendarView.this._dragArea.getHeight()));
                        }
                    }
                }
                if (CalendarView.this._dragArea.getHeight() < CalendarView.this.getTimeSlotHeight()) {
                    CalendarView.this._dragArea.setBounds(CalendarView.this._dragArea.getX(), CalendarView.this._dragArea.getY(), CalendarView.this._dragArea.getWidth(), CalendarView.this.getTimeSlotHeight());
                }
                CalendarView.this.getComponent().revalidate();
                draggingEnabled = false;
                this.mouseXold = e.getPoint().x;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw BizcalException.create(exc);
            }
        }

        public void mouseMoved(MouseEvent e) {
            CalendarView.this.getComponent().requestFocusInWindow();
        }
    }
}

