/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.TimeLabelPanel;
import bizcal.swing.util.FrameArea;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import bizcal.util.Tuple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayView
extends CalendarView {
    public static int PIXELS_PER_HOUR = 80;
    private static final int CAPTION_ROW_HEIGHT0 = 20;
    public static final int PREFERRED_DAY_WIDTH = 10;
    public static final Integer GRID_LEVEL = 1;
    private List<List<FrameArea>> frameAreaCols = new ArrayList<List<FrameArea>>();
    private List<List<Event>> eventColList = new ArrayList<List<Event>>();
    private List<Date> _dateList = new ArrayList<Date>();
    private Map<Tuple, JLabel> timeLines = new HashMap<Tuple, JLabel>();
    private HashMap<Date, Integer> linePositionMap = new HashMap();
    private Map<Integer, Date> minuteMapping = Collections.synchronizedMap(new HashMap());
    private List<JLabel> vLines = new ArrayList<JLabel>();
    private List<JPanel> calBackgrounds = new ArrayList<JPanel>();
    private ColumnHeaderPanel columnHeader;
    private TimeLabelPanel rowHeader;
    private int dayCount;
    private JScrollPane scrollPane;
    private JLayeredPane calPanel;
    private boolean firstRefresh = true;
    private DayViewConfig config;
    private List<JLabel> dateFooters = new ArrayList<JLabel>();
    private Collection<NamedCalendar> activeCalendars = null;
    private Layout layout;
    private NamedCalendar selectedCalendar;
    private JLabel currentTimeLineLabel = new JLabel();
    private JLabel currentTimeLine = new JLabel();
    private JLabel currentTimeLineShadow = new JLabel();
    public final DateFormat timeFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());

    public DayView(DayViewConfig desc) throws Exception {
        this(desc, null);
    }

    public DayView(DayViewConfig desc, Component upperLeftCornerComponent) throws Exception {
        this(desc, upperLeftCornerComponent, 0);
    }

    public DayView(DayViewConfig desc, Component upperLeftCornerComponent, Integer calendarViewLayout) throws Exception {
        super(desc);
        this.config = desc;
        this.calPanel = new JLayeredPane();
        this.layout = new Layout(calendarViewLayout);
        this.calPanel.setLayout(this.layout);
        CalendarView.ThisMouseListener mouseListener = new CalendarView.ThisMouseListener();
        CalendarView.ThisKeyListener keyListener = new CalendarView.ThisKeyListener();
        this.calPanel.addMouseListener(mouseListener);
        this.calPanel.addMouseMotionListener(mouseListener);
        this.calPanel.addKeyListener(keyListener);
        this.scrollPane = new JScrollPane(this.calPanel, 20, 30);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        if (upperLeftCornerComponent == null) {
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.createCorner(true, true));
        } else {
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", upperLeftCornerComponent);
        }
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.createCorner(true, false));
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner(false, true));
        this.columnHeader = new ColumnHeaderPanel(desc);
        this.columnHeader.setShowExtraDateHeaders(desc.isShowExtraDateHeaders());
        this.scrollPane.setColumnHeaderView(this.columnHeader.getComponent());
        this.rowHeader = new TimeLabelPanel(desc, new TimeOfDay(this.config.getDayStartHour(), 0), new TimeOfDay(this.config.getDayEndHour(), 0), this.config.getNumberOfTimeSlots());
        this.rowHeader.setFooterHeight(this.getFooterHeight());
        this.scrollPane.setRowHeaderView(this.rowHeader.getComponent());
    }

    @Override
    public void refresh0() throws Exception {
        if (this.calPanel == null || this.getModel() == null) {
            return;
        }
        this.dayCount = (int)(this.getModel().getInterval().getDuration() / 86400000L);
        this.calPanel.removeAll();
        this.calPanel.setBackground(Color.WHITE);
        this.rowHeader.setStartEnd(new TimeOfDay(this.config.getDayStartHour(), 0), new TimeOfDay(this.config.getDayEndHour(), 0), this.config.getNumberOfTimeSlots());
        this.rowHeader.setFooterHeight(this.getFooterHeight());
        this.rowHeader.getComponent().revalidate();
        this.frameAreaCols.clear();
        this.eventColList.clear();
        this.timeLines.clear();
        this.linePositionMap.clear();
        this.minuteMapping.clear();
        this.calBackgrounds.clear();
        this.vLines.clear();
        this.dateFooters.clear();
        this.addDraggingComponents(this.calPanel);
        Font hourFont = this.getDayViewConfig().getFont().deriveFont(12.0f);
        hourFont = hourFont.deriveFont(1);
        Color color = this.getDayViewConfig().getLineColor();
        Color hlineColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.getDayViewConfig().getGridAlpha());
        long pos = this.getFirstInterval().getStartDate().getTime();
        while (pos < this.getFirstInterval().getEndDate().getTime()) {
            Date currentHour = new Date(pos);
            int timeSlots = this.config.getNumberOfTimeSlots();
            int i = 1;
            while (i <= timeSlots) {
                JLabel line = new JLabel();
                line.setOpaque(true);
                line.setBackground(hlineColor);
                this.calPanel.add((Component)line, GRID_LEVEL);
                this.timeLines.put(new Tuple(currentHour, (Object)("" + 60 / timeSlots * i)), line);
                this.addHorizontalLine(line);
                ++i;
            }
            pos += 3600000L;
        }
        if (this.config.isShowDateFooter()) {
            JLabel line = new JLabel();
            line.setBackground(this.getDayViewConfig().getLineColor());
            line.setOpaque(true);
            this.calPanel.add((Component)line, GRID_LEVEL);
            this.timeLines.put(new Tuple(new Date(pos), (Object)"00"), line);
        }
        this.createColumns();
        for (Object obj : this.getSelectedCalendars()) {
            bizcal.common.Calendar cal = (bizcal.common.Calendar)obj;
            JPanel calBackground = new JPanel();
            calBackground.setBackground(cal.getColor());
            this.calBackgrounds.add(calBackground);
            this.calPanel.add(calBackground);
        }
        this.columnHeader.setModel(this.getModel());
        this.columnHeader.setPopupMenuCallback(this.popupMenuCallback);
        this.columnHeader.refresh();
        if (this.firstRefresh) {
            this.initScroll();
        }
        this.firstRefresh = false;
        EventModel dayModel = (EventModel)this.getModel();
        Date currentDate = new Date();
        if (dayModel.getInterval().isDayIn(currentDate)) {
            Color colorTimeLine = new Color(111, 236, 82);
            Color colorTimeLineLight = new Color(111, 236, 82, this.getDayViewConfig().getGridAlpha());
            this.currentTimeLineLabel.setOpaque(true);
            this.currentTimeLineLabel.setBackground(colorTimeLine);
            this.currentTimeLine.setOpaque(true);
            this.currentTimeLine.setBackground(colorTimeLine);
            this.currentTimeLineShadow.setOpaque(true);
            this.currentTimeLineShadow.setBackground(colorTimeLineLight);
            this.calPanel.add((Component)this.currentTimeLineLabel, GRID_LEVEL);
            this.calPanel.add((Component)this.currentTimeLine, GRID_LEVEL);
            this.calPanel.add((Component)this.currentTimeLineShadow, GRID_LEVEL);
        }
        this.scrollPane.repaint();
        this.rowHeader.getComponent().updateUI();
    }

    private int getColCount() throws Exception {
        return this.dayCount * this.getSelectedCalendars().size();
    }

    private DateInterval getFirstInterval() throws Exception {
        Date start = this.getInterval().getStartDate();
        return new DateInterval(DateUtil.round2Hour(start, this.config.getDayStartHour()), DateUtil.round2Hour(start, this.config.getDayEndHour()));
    }

    private void createColumns() throws Exception {
        DateInterval interval = this.getFirstInterval();
        int cols = this.getColCount();
        this.frameAreaHash.clear();
        List<Event> events = null;
        DateInterval interval2 = null;
        int it = 0;
        while (it < cols) {
            int iCal = it / this.dayCount;
            bizcal.common.Calendar cal = (bizcal.common.Calendar)this.getSelectedCalendars().get(iCal);
            Object calId = cal.getId();
            events = this.broker.getEvents(calId);
            Collections.sort(events);
            if (it % this.dayCount == 0) {
                interval2 = new DateInterval(interval);
            }
            if (interval2 != null) {
                this._dateList.add(interval2.getStartDate());
            }
            Calendar startdate = DateUtil.newCalendar();
            startdate.setTime(interval2.getStartDate());
            Color vlColor = this.getDayViewConfig().getLineColor();
            int vlAlpha = this.getDayViewConfig().getGridAlpha() + 50;
            if (vlAlpha > 255) {
                vlAlpha = 255;
            }
            Color vlAlphaColor = new Color(vlColor.getRed(), vlColor.getGreen(), vlColor.getBlue(), vlAlpha);
            if (it > 0) {
                JLabel verticalLine = new JLabel();
                verticalLine.setOpaque(true);
                verticalLine.setBackground(vlAlphaColor);
                if (startdate.get(7) == startdate.getFirstDayOfWeek()) {
                    verticalLine.setBackground(this.getDescriptor().getLineColor2());
                }
                if (this.getSelectedCalendars().size() > 1 && it % this.dayCount == 0) {
                    verticalLine.setBackground(this.getDescriptor().getLineColor3());
                }
                this.calPanel.add((Component)verticalLine, GRID_LEVEL);
                this.vLines.add(verticalLine);
            }
            ArrayList<FrameArea> frameAreas = new ArrayList<FrameArea>();
            this.frameAreaCols.add(frameAreas);
            if (calId != null) {
                DateInterval currDayInterval = this.getInterval(it % this.dayCount);
                ArrayList<Event> colEvents = new ArrayList<Event>();
                this.eventColList.add(colEvents);
                int iEvent = 0;
                if (events == null) {
                    events = new ArrayList<Event>();
                }
                for (Event event : events) {
                    DateInterval eventInterv = new DateInterval(event.getStart(), event.getEnd());
                    if (!currDayInterval.overlap(eventInterv)) continue;
                    FrameArea area = this.createFrameArea(calId, event);
                    area.setBackground(this.config.getPrimaryColor());
                    frameAreas.add(area);
                    colEvents.add(event);
                    this.calPanel.add((Component)area, (Object)event.getLevel());
                    ++iEvent;
                    if (!this.frameAreaHash.containsKey(event)) {
                        this.frameAreaHash.put(event, area);
                        continue;
                    }
                    ((FrameArea)this.frameAreaHash.get(event)).addChild(area);
                }
                if (this.config.isShowDateFooter()) {
                    JLabel footer = new JLabel(this.broker.getDateFooter(cal.getId(), interval2.getStartDate(), colEvents));
                    footer.setHorizontalAlignment(0);
                    this.dateFooters.add(footer);
                    this.calPanel.add(footer);
                }
                if (this.dayCount > 1) {
                    interval2 = this.incDay(interval2);
                }
            }
            ++it;
        }
    }

    private int getYPos(Date aDate, int dayNo) throws Exception {
        long time = aDate.getTime();
        return this.getYPos(time, dayNo);
    }

    private int getYPos(long time, int dayNo) throws Exception {
        DateInterval interval = this.getInterval(dayNo);
        if (DateUtil.isDaylightSavingDay(interval.getStartDate())) {
            Date currDay = new Date(time);
            if (DateUtil.isAfterDSTChange(currDay)) {
                currDay = DateUtil.moveByMinute(currDay, 60);
                time = currDay.getTime();
                time -= interval.getStartDate().getTime();
            }
        } else {
            time -= interval.getStartDate().getTime();
        }
        double viewPortHeight = this.getHeight() - this.getCaptionRowHeight() - this.getFooterHeight();
        double timeSpan = this.config.getHours() * 3600 * 1000;
        double dblTime = time;
        int ypos = (int)(dblTime / timeSpan * viewPortHeight);
        return ypos += this.getCaptionRowHeight();
    }

    @Override
    protected synchronized Date getDate(int xPos, int yPos) throws Exception {
        int colNo = this.getColumn(xPos);
        int dayNo = 0;
        if (this.dayCount != 0) {
            dayNo = colNo % this.dayCount;
        }
        DateInterval interval = this.getInterval(dayNo);
        yPos -= this.getCaptionRowHeight();
        Date foundDate = null;
        if (this.minuteMapping == null || this.minuteMapping.size() == 0) {
            foundDate = new Date();
        }
        while (foundDate == null) {
            foundDate = this.minuteMapping.get(yPos);
            if (++yPos < 0) break;
            if (yPos < this.getHeight()) continue;
            yPos = this.getHeight();
        }
        if (foundDate != null) {
            TimeOfDay td = DateUtil.getTimeOfDay(foundDate);
            Date d = td.getDate(interval.getStartDate());
            return d;
        }
        return null;
    }

    private DateInterval getInterval(int dayNo) throws Exception {
        DateInterval interval = this.getFirstInterval();
        int i = 0;
        while (i < dayNo) {
            interval = this.incDay(interval);
            ++i;
        }
        return interval;
    }

    private int getColumn(int xPos) throws Exception {
        int width = this.getWidth() - this.getXOffset();
        double ratio = (double)(xPos -= this.getXOffset()) / (double)width;
        return (int)(ratio * (double)this.getColCount());
    }

    private Object getCalendarId(int colNo) throws Exception {
        int pos = 0;
        if (this.dayCount != 0) {
            pos = colNo / this.dayCount;
        }
        bizcal.common.Calendar cal = (bizcal.common.Calendar)this.getSelectedCalendars().get(pos);
        return cal.getId();
    }

    @Override
    protected int getXOffset() {
        return 0;
    }

    private int getXPos(int colno) throws Exception {
        double x = this.getWidth();
        double ratio = (double)colno / (double)this.getColCount();
        return (int)((x -= (double)this.getXOffset()) * ratio) + this.getXOffset();
    }

    private int getWidth() {
        return this.calPanel.getWidth();
    }

    private int getHeight() {
        return this.calPanel.getHeight();
    }

    private int getTimeHeight() throws Exception {
        return this.getHeight() - this.getCaptionRowHeight() - this.getFooterHeight();
    }

    private int getFooterHeight() {
        if (this.config.isShowDateFooter()) {
            return PIXELS_PER_HOUR / 2;
        }
        return 0;
    }

    private int findSmallestFrameArea(FrameArea fa) {
        if (fa.getChildren() == null || fa.getChildren().size() < 1) {
            return fa.getWidth();
        }
        int smallest = fa.getWidth();
        for (FrameArea child : fa.getChildren()) {
            if (child.getWidth() >= smallest) continue;
            smallest = child.getWidth();
        }
        return smallest;
    }

    @Override
    protected Object getCalendarId(int x, int y) throws Exception {
        return this.getCalendarId(this.getColumn(x));
    }

    private DayViewConfig getDayViewConfig() throws Exception {
        DayViewConfig result = (DayViewConfig)this.getDescriptor();
        if (result == null) {
            result = new DayViewConfig();
            this.setDescriptor(result);
        }
        return result;
    }

    @Override
    protected int getInitYPos() throws Exception {
        double viewStart = this.getModel().getViewStart().getValue();
        double ratio = viewStart / 8.64E7;
        return (int)(ratio * (double)this.config.getHours() * (double)PIXELS_PER_HOUR);
    }

    private int getPreferredHeight() {
        return this.config.getHours() * PIXELS_PER_HOUR + this.getFooterHeight();
    }

    @Override
    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void initScroll() throws Exception {
        this.scrollPane.getViewport().setViewPosition(new Point(0, this.getInitYPos()));
    }

    @Override
    public void addListener(CalendarListener listener) {
        super.addListener(listener);
        this.columnHeader.addCalendarListener(listener);
    }

    public void setActiveCalendars(Collection<NamedCalendar> calendars) {
        this.activeCalendars = calendars;
        try {
            this.deselect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSelectedCalendar(NamedCalendar selectedCalendar) {
        this.selectedCalendar = selectedCalendar;
        if (this.calPanel != null) {
            this.setSelectedCalendarInCV(selectedCalendar);
        }
    }

    public Integer getLayoutMode() {
        return this.layout.getLayoutMode();
    }

    public void setLayoutMode(Integer layoutMode) {
        this.layout.setLayoutMode(layoutMode);
    }

    public void setCurrentTimeLine() {
        EventModel dayModel = (EventModel)this.getModel();
        Date currentDate = new Date();
        if (!dayModel.getInterval().isDayIn(currentDate)) {
            return;
        }
        double currentDayStarttime = DateUtil.round2Hour(new Date(), this.config.getDayStartHour()).getTime();
        double currentTime = currentDate.getTime();
        double viewPortHeight = this.getHeight() - this.getCaptionRowHeight() - this.getFooterHeight();
        double timeSpan = this.config.getHours() * 3600 * 1000;
        int dayModelDays = dayModel.getDays();
        int y = (int)((currentTime -= currentDayStarttime) / timeSpan * viewPortHeight);
        int x = this.getWidth() / dayModelDays;
        try {
            Date weekStart = dayModel.getInterval().getStartDate();
            int currentDay = DateUtil.getDiffDay(DateUtil.getDayOfWeek(weekStart), DateUtil.getDayOfWeek(currentDate));
            this.currentTimeLine.setBounds(0 + --currentDay * x, y - 1, x, 1);
            this.currentTimeLineShadow.setBounds(0 + currentDay * x, y - 6, x, 11);
            this.currentTimeLineLabel.setText(this.timeFormat.format(currentDate));
            this.currentTimeLineLabel.setFont(new Font("Arial", 1, 9));
            this.currentTimeLineLabel.setBounds(x / 2 - 10 + currentDay * x, y - 5, 23, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Layout
    implements LayoutManager {
        public static final int DAY_COLUMN_NORMAL = 0;
        public static final int DAY_COLUMN_SEPARATED_BY_CALENDAR = 1;
        public static final int DAY_COLUMN_SEPARATED_BY_MAX_NUMBER_OF_CALENDAR = 2;
        private Integer layoutMode = 0;

        public Layout() {
            this(0);
        }

        public Layout(Integer layoutMode) {
            this.layoutMode = layoutMode;
        }

        public void setLayoutMode(Integer layoutMode) {
            this.layoutMode = layoutMode;
        }

        public Integer getLayoutMode() {
            return this.layoutMode;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            try {
                int width = DayView.this.dayCount * DayView.this.getModel().getSelectedCalendars().size() * 10;
                return new Dimension(width, DayView.this.getPreferredHeight());
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(50, 100);
        }

        public void layoutContainer(Container parent) {
            if (DayView.this.activeCalendars == null) {
                return;
            }
            if (this.layoutMode == 1) {
                this.layoutContainerDayColumnSeparatedByCalendar(parent);
                return;
            }
            if (this.layoutMode == 2) {
                this.layoutContainerDayColumnSeparatedByMaxNumberCalendar(parent);
                return;
            }
            try {
                DayView.this.resetVerticalLines();
                int width = DayView.this.getWidth();
                int height = DayView.this.getHeight();
                DateInterval day = DayView.this.getFirstInterval();
                int numberOfCols = DayView.this.getColCount();
                if (numberOfCols == 0) {
                    numberOfCols = 1;
                }
                int i = 0;
                while (i < DayView.this.eventColList.size()) {
                    Event event;
                    int dayNo = i % DayView.this.dayCount;
                    int xpos = DayView.this.getXPos(i);
                    int captionYOffset = DayView.this.getCaptionRowHeight() - 20;
                    int colWidth = DayView.this.getXPos(i + 1) - DayView.this.getXPos(i);
                    int vLineTop = captionYOffset + 20 + 2;
                    if (dayNo == 0 && DayView.this.getSelectedCalendars().size() > 1) {
                        vLineTop = 0;
                        day = DayView.this.getFirstInterval();
                    }
                    if (i > 0) {
                        JLabel verticalLine = (JLabel)DayView.this.vLines.get(i - 1);
                        int vLineHeight = height - vLineTop;
                        verticalLine.setBounds(xpos, vLineTop, 1, vLineHeight);
                        DayView.this.addVerticalLine(verticalLine);
                    }
                    if (DayView.this.config.isShowDateFooter()) {
                        JLabel dayFooter = (JLabel)DayView.this.dateFooters.get(i);
                        dayFooter.setBounds(xpos, DayView.this.getTimeHeight(), colWidth, DayView.this.getFooterHeight());
                    }
                    DateInterval currIntervall = DayView.this.getInterval(dayNo);
                    JComponent previousArea = null;
                    int overlapCol = 0;
                    int overlapColCount = 0;
                    List events = (List)DayView.this.eventColList.get(i);
                    List areas = (List)DayView.this.frameAreaCols.get(i);
                    int[] overlapCols = new int[events.size()];
                    int j = 0;
                    while (j < events.size()) {
                        int y1;
                        Date endTime;
                        FrameArea area = (FrameArea)areas.get(j);
                        event = (Event)events.get(j);
                        Date startTime = event.getStart();
                        if (startTime.before(currIntervall.getStartDate())) {
                            startTime = currIntervall.getStartDate();
                        }
                        if ((endTime = event.getEnd()).after(currIntervall.getEndDate())) {
                            endTime = currIntervall.getEndDate();
                        }
                        if ((y1 = DayView.this.getYPos(startTime, dayNo)) < DayView.this.getCaptionRowHeight()) {
                            y1 = DayView.this.getCaptionRowHeight();
                        }
                        int y2 = DayView.this.getYPos(endTime, dayNo);
                        int dHeight = y2 - y1;
                        int x1 = xpos;
                        area.setBounds(x1, y1, colWidth, dHeight);
                        if (!event.isBackground()) {
                            if (previousArea != null) {
                                int previousY2 = previousArea.getY() + previousArea.getHeight();
                                if (previousY2 > y1) {
                                    ++overlapCol;
                                    if (previousY2 < y2) {
                                        previousArea = area;
                                    }
                                } else {
                                    overlapCol = 0;
                                    previousArea = area;
                                }
                            } else {
                                previousArea = area;
                            }
                            overlapCols[j] = overlapCol;
                            if (overlapCol > overlapColCount) {
                                overlapColCount = overlapCol;
                            }
                        } else {
                            overlapCols[j] = -1;
                        }
                        ++j;
                    }
                    if (overlapColCount > 0) {
                        int currWidth = colWidth;
                        int k = 0;
                        while (k < areas.size()) {
                            event = (Event)events.get(k);
                            if (!event.isBackground()) {
                                FrameArea area = (FrameArea)areas.get(k);
                                int overlapIndex = overlapCols[k];
                                if (overlapIndex == 0) {
                                    currWidth = colWidth;
                                }
                                try {
                                    int kOffset = 1;
                                    while (((Event)events.get(k + kOffset)).isBackground()) {
                                        ++kOffset;
                                    }
                                    if (overlapCols[k + kOffset] > 0) {
                                        int curr = overlapIndex;
                                        int a = k + 1;
                                        while (a < areas.size()) {
                                            if (overlapCols[a] != 0 && overlapCols[a] > curr) {
                                                curr = overlapCols[a];
                                            }
                                            ++a;
                                        }
                                        currWidth = colWidth / (curr + 1);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                area.setBounds(area.getX() + overlapIndex * currWidth, area.getY(), currWidth, area.getHeight());
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                for (List fAreas : DayView.this.frameAreaCols) {
                    if (fAreas == null) continue;
                    int countFrontLayer = 0;
                    int countBackLayer = 0;
                    for (FrameArea fa : fAreas) {
                        int baseFAWidth;
                        int sw = DayView.this.findSmallestFrameArea(fa);
                        try {
                            baseFAWidth = DayView.this.getBaseFrameArea(fa.getEvent()).getWidth();
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (sw > baseFAWidth) {
                            sw = baseFAWidth;
                        }
                        fa.setBounds(fa.getX(), fa.getY(), sw, fa.getHeight());
                        if (fa.getEvent().get("calendarId") != null) {
                            if (((Boolean)fa.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(fa, DayView.this.calPanel.getComponents().length - 4 - countBackLayer);
                                ++countBackLayer;
                            }
                            if (fa.getEvent().isBackground() && !((Boolean)fa.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(fa, DayView.this.calPanel.getComponents().length / 2 - countBackLayer);
                                ++countBackLayer;
                            }
                            if (fa.getEvent().isBackground()) continue;
                            DayView.this.calPanel.setComponentZOrder(fa, fAreas.size() - countFrontLayer);
                            ++countFrontLayer;
                            continue;
                        }
                        DayView.this.calPanel.setComponentZOrder(fa, DayView.this.calPanel.getComponents().length - 4);
                    }
                }
                if (DayView.this.dayCount > 1) {
                    day = DayView.this.incDay(day);
                }
                for (Tuple key : DayView.this.timeLines.keySet()) {
                    Date date = (Date)key.elementAt(0);
                    int minutes = Integer.parseInt((String)key.elementAt(1));
                    JLabel line = (JLabel)DayView.this.timeLines.get(key);
                    Date date1 = new Date(date.getTime() + (long)minutes * 60L * 1000L);
                    int y1 = DayView.this.getYPos(date1, 0);
                    DayView.this.linePositionMap.put(date1, y1);
                    int x1 = 0;
                    int lineheight = 1;
                    if (minutes > 0) {
                        lineheight = 1;
                    }
                    line.setBounds(x1, y1, width, lineheight);
                }
                ArrayList lines = new ArrayList(DayView.this.linePositionMap.keySet());
                DayView.this.linePositionMap.put(DayView.this.getFirstInterval().getStartDate(), 0);
                Collections.sort(lines);
                int linesPerHour = DayView.this.config.getNumberOfTimeSlots();
                int i2 = 0;
                while (i2 < lines.size()) {
                    Date currDate = (Date)lines.get(i2);
                    int currPos = (Integer)DayView.this.linePositionMap.get(currDate);
                    int nextPos = 0;
                    if (i2 + 1 < lines.size()) {
                        Date nextDate = (Date)lines.get(i2 + 1);
                        nextPos = (Integer)DayView.this.linePositionMap.get(nextDate);
                    } else {
                        nextPos = DayView.this.getTimeHeight();
                    }
                    int slotHeight = nextPos - currPos;
                    int numberOfMinutesPerSlot = 60 / linesPerHour;
                    int pixelsPerMinute = slotHeight / numberOfMinutesPerSlot;
                    DayView.this.minuteMapping.put(currPos, currDate);
                    int startMinute = DateUtil.getMinuteOfHour(currDate);
                    boolean isDSTDay = DateUtil.isDaylightSavingDay(currDate);
                    int k = 1;
                    while (k < numberOfMinutesPerSlot) {
                        Date pixelDate = DateUtil.round2Minute(currDate, startMinute + k);
                        if (isDSTDay) {
                            DateUtil.isAfterDSTChange(pixelDate);
                        }
                        DayView.this.minuteMapping.put(currPos + k * pixelsPerMinute, pixelDate);
                        ++k;
                    }
                    ++i2;
                }
                int iCal = 0;
                while (iCal < DayView.this.calBackgrounds.size()) {
                    int x1 = DayView.this.getXPos(iCal * DayView.this.dayCount);
                    int x2 = DayView.this.getXPos((iCal + 1) * DayView.this.dayCount);
                    JPanel calBackground = (JPanel)DayView.this.calBackgrounds.get(iCal);
                    calBackground.setBounds(x1, DayView.this.getCaptionRowHeight(), x2 - x1, DayView.this.getHeight());
                    ++iCal;
                }
                DayView.this.setCurrentTimeLine();
                for (JLabel l : DayView.this.timeLines.values()) {
                    try {
                        DayView.this.calPanel.setComponentZOrder(l, DayView.this.calPanel.getComponents().length - 2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void layoutContainerDayColumnSeparatedByCalendar(Container parent) {
            try {
                DayView.this.resetVerticalLines();
                int width = DayView.this.getWidth();
                int height = DayView.this.getHeight();
                DateInterval day = DayView.this.getFirstInterval();
                int numberOfCols = DayView.this.getColCount();
                if (numberOfCols == 0) {
                    numberOfCols = 1;
                }
                int i = 0;
                while (i < DayView.this.eventColList.size()) {
                    Event event;
                    int dayNo = i % DayView.this.dayCount;
                    int xpos = DayView.this.getXPos(i);
                    int captionYOffset = DayView.this.getCaptionRowHeight() - 20;
                    int colWidth = DayView.this.getXPos(i + 1) - DayView.this.getXPos(i);
                    int vLineTop = captionYOffset + 20 + 2;
                    if (dayNo == 0 && DayView.this.getSelectedCalendars().size() > 1) {
                        vLineTop = 0;
                        day = DayView.this.getFirstInterval();
                    }
                    if (i > 0) {
                        JLabel verticalLine = (JLabel)DayView.this.vLines.get(i - 1);
                        int vLineHeight = height - vLineTop;
                        verticalLine.setBounds(xpos, vLineTop, 1, vLineHeight);
                        DayView.this.addVerticalLine(verticalLine);
                    }
                    if (DayView.this.config.isShowDateFooter()) {
                        JLabel dayFooter = (JLabel)DayView.this.dateFooters.get(i);
                        dayFooter.setBounds(xpos, DayView.this.getTimeHeight(), colWidth, DayView.this.getFooterHeight());
                    }
                    DateInterval currIntervall = DayView.this.getInterval(dayNo);
                    int overlapColCount = 0;
                    List events = (List)DayView.this.eventColList.get(i);
                    List areas = (List)DayView.this.frameAreaCols.get(i);
                    int[] overlapCols = new int[events.size()];
                    HashSet<Object> calendersOfEventsPerColumn = new HashSet<Object>();
                    int j = 0;
                    while (j < events.size()) {
                        Event event2 = (Event)events.get(j);
                        if (event2.get("calendarId") != null && !((Boolean)event2.get("calendarIsBackground")).booleanValue()) {
                            calendersOfEventsPerColumn.add(event2.get("calendarId"));
                        }
                        ++j;
                    }
                    Integer calendarCount = calendersOfEventsPerColumn.size();
                    Integer[] calendersOfEventsPerColumnSort = new Integer[calendarCount.intValue()];
                    int ci = 0;
                    for (NamedCalendar calendar : DayView.this.activeCalendars) {
                        for (Integer n : calendersOfEventsPerColumn) {
                            if (calendar.getId() != n) continue;
                            calendersOfEventsPerColumnSort[ci] = calendar.getId();
                            ++ci;
                        }
                    }
                    int j2 = 0;
                    while (j2 < events.size()) {
                        void var24_62;
                        int y1;
                        Date endTime;
                        FrameArea area = (FrameArea)areas.get(j2);
                        event = (Event)events.get(j2);
                        Date date = event.getStart();
                        if (date.before(currIntervall.getStartDate())) {
                            Date date2 = currIntervall.getStartDate();
                        }
                        if ((endTime = event.getEnd()).after(currIntervall.getEndDate())) {
                            endTime = currIntervall.getEndDate();
                        }
                        if ((y1 = DayView.this.getYPos((Date)var24_62, dayNo)) < DayView.this.getCaptionRowHeight()) {
                            y1 = DayView.this.getCaptionRowHeight();
                        }
                        int y2 = DayView.this.getYPos(endTime, dayNo);
                        int dHeight = y2 - y1;
                        int x1 = xpos;
                        int c = 0;
                        while (c < calendarCount) {
                            if (event.get("calendarId") == calendersOfEventsPerColumnSort[c]) {
                                x1 += c * (colWidth / calendarCount);
                            }
                            ++c;
                        }
                        if (event.get("calendarId") != null && !((Boolean)event.get("calendarIsBackground")).booleanValue()) {
                            area.setBounds(x1, y1, colWidth / calendarCount, dHeight);
                        } else {
                            area.setBounds(xpos, y1, colWidth, dHeight);
                        }
                        overlapCols[j2] = -1;
                        ++j2;
                    }
                    if (overlapColCount > 0) {
                        int currWidth = colWidth;
                        int k = 0;
                        while (k < areas.size()) {
                            event = (Event)events.get(k);
                            if (!event.isBackground()) {
                                FrameArea frameArea = (FrameArea)areas.get(k);
                                int overlapIndex = overlapCols[k];
                                if (overlapIndex == 0) {
                                    currWidth = colWidth;
                                }
                                try {
                                    int kOffset = 1;
                                    while (((Event)events.get(k + kOffset)).isBackground()) {
                                        ++kOffset;
                                    }
                                    if (overlapCols[k + kOffset] > 0) {
                                        int curr = overlapIndex;
                                        int a = k + 1;
                                        while (a < areas.size()) {
                                            if (overlapCols[a] != 0 && overlapCols[a] > curr) {
                                                curr = overlapCols[a];
                                            }
                                            ++a;
                                        }
                                        currWidth = colWidth / (curr + 1);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                frameArea.setBounds(frameArea.getX() + overlapIndex * currWidth, frameArea.getY(), currWidth, frameArea.getHeight());
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                for (List fAreas : DayView.this.frameAreaCols) {
                    if (fAreas == null) continue;
                    int countFrontLayer = 0;
                    int countBackLayer = 0;
                    for (FrameArea fa : fAreas) {
                        int baseFAWidth;
                        int sw = DayView.this.findSmallestFrameArea(fa);
                        try {
                            baseFAWidth = DayView.this.getBaseFrameArea(fa.getEvent()).getWidth();
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (sw > baseFAWidth) {
                            sw = baseFAWidth;
                        }
                        fa.setBounds(fa.getX(), fa.getY(), sw, fa.getHeight());
                        if (fa.getEvent().get("calendarId") != null) {
                            if (((Boolean)fa.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(fa, DayView.this.calPanel.getComponents().length - 5 - countBackLayer);
                                ++countBackLayer;
                            }
                            if (fa.getEvent().isBackground() && !((Boolean)fa.getEvent().get("calendarIsBackground")).booleanValue()) {
                                DayView.this.calPanel.setComponentZOrder(fa, DayView.this.calPanel.getComponents().length / 2 - countBackLayer);
                                ++countBackLayer;
                            }
                            if (fa.getEvent().isBackground()) continue;
                            DayView.this.calPanel.setComponentZOrder(fa, fAreas.size() - countFrontLayer);
                            ++countFrontLayer;
                            continue;
                        }
                        DayView.this.calPanel.setComponentZOrder(fa, DayView.this.calPanel.getComponents().length - 4);
                    }
                }
                if (DayView.this.dayCount > 1) {
                    day = DayView.this.incDay(day);
                }
                for (Tuple key : DayView.this.timeLines.keySet()) {
                    Date date = (Date)key.elementAt(0);
                    int minutes = Integer.parseInt((String)key.elementAt(1));
                    JLabel line = (JLabel)DayView.this.timeLines.get(key);
                    Date date1 = new Date(date.getTime() + (long)minutes * 60L * 1000L);
                    int y1 = DayView.this.getYPos(date1, 0);
                    DayView.this.linePositionMap.put(date1, y1);
                    int x1 = 0;
                    int lineheight = 1;
                    if (minutes > 0) {
                        lineheight = 1;
                    }
                    line.setBounds(x1, y1, width, lineheight);
                }
                ArrayList lines = new ArrayList(DayView.this.linePositionMap.keySet());
                DayView.this.linePositionMap.put(DayView.this.getFirstInterval().getStartDate(), 0);
                Collections.sort(lines);
                int linesPerHour = DayView.this.config.getNumberOfTimeSlots();
                int i2 = 0;
                while (i2 < lines.size()) {
                    Date currDate = (Date)lines.get(i2);
                    int currPos = (Integer)DayView.this.linePositionMap.get(currDate);
                    int nextPos = 0;
                    if (i2 + 1 < lines.size()) {
                        Date nextDate = (Date)lines.get(i2 + 1);
                        nextPos = (Integer)DayView.this.linePositionMap.get(nextDate);
                    } else {
                        nextPos = DayView.this.getTimeHeight();
                    }
                    int slotHeight = nextPos - currPos;
                    int numberOfMinutesPerSlot = 60 / linesPerHour;
                    int pixelsPerMinute = slotHeight / numberOfMinutesPerSlot;
                    DayView.this.minuteMapping.put(currPos, currDate);
                    int startMinute = DateUtil.getMinuteOfHour(currDate);
                    boolean isDSTDay = DateUtil.isDaylightSavingDay(currDate);
                    int k = 1;
                    while (k < numberOfMinutesPerSlot) {
                        Date pixelDate = DateUtil.round2Minute(currDate, startMinute + k);
                        if (isDSTDay) {
                            DateUtil.isAfterDSTChange(pixelDate);
                        }
                        ++k;
                    }
                    ++i2;
                }
                int iCal = 0;
                while (iCal < DayView.this.calBackgrounds.size()) {
                    int x1 = DayView.this.getXPos(iCal * DayView.this.dayCount);
                    int x2 = DayView.this.getXPos((iCal + 1) * DayView.this.dayCount);
                    JPanel calBackground = (JPanel)DayView.this.calBackgrounds.get(iCal);
                    calBackground.setBounds(x1, DayView.this.getCaptionRowHeight(), x2 - x1, DayView.this.getHeight());
                    ++iCal;
                }
                DayView.this.setCurrentTimeLine();
                for (JLabel l : DayView.this.timeLines.values()) {
                    try {
                        DayView.this.calPanel.setComponentZOrder(l, DayView.this.calPanel.getComponents().length - 2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public void layoutContainerDayColumnSeparatedByMaxNumberCalendar(Container parent) {
        }
    }
}

