/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarViewConfig;
import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.CalendarView;
import bizcal.swing.ColumnHeaderPanel;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.FrameArea;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonthView
extends CalendarView {
    private ColumnHeaderPanel columnHeader;
    private List<List> cells = new ArrayList<List>();
    private List hLines = new ArrayList();
    private List vLines = new ArrayList();
    private JScrollPane scrollPane;
    private JPanel calPanel = new JPanel();

    public MonthView(CalendarViewConfig desc) throws Exception {
        super(desc);
        this.calPanel.setLayout(new Layout());
        this.scrollPane = new JScrollPane(this.calPanel, 20, 30);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(15);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.createCorner(true, true));
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.createCorner(true, false));
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.createCorner(false, true));
        this.columnHeader = new ColumnHeaderPanel(desc, 7);
        this.columnHeader.setShowExtraDateHeaders(true);
        this.columnHeader.setMonthView(true);
        this.scrollPane.setColumnHeaderView(this.columnHeader.getComponent());
    }

    @Override
    public void refresh0() throws Exception {
        this.calPanel.removeAll();
        this.cells.clear();
        this.hLines.clear();
        this.vLines.clear();
        java.util.Calendar cal = DateUtil.newCalendar();
        cal.setTime(this.getInterval().getStartDate());
        cal.add(6, 15);
        int month = cal.get(2);
        int lastDayOfWeek = cal.getFirstDayOfWeek();
        if (--lastDayOfWeek < 1) {
            lastDayOfWeek += 7;
        }
        block0: for (Calendar calInfo : this.getModel().getSelectedCalendars()) {
            cal.setTime(this.getInterval().getStartDate());
            cal.set(5, 1);
            cal.set(7, cal.getFirstDayOfWeek());
            Map<Date, List<Event>> eventMap = this.createEventsPerDay(calInfo.getId());
            int rowno = 0;
            while (true) {
                List<JComponent> row;
                if (this.cells.size() <= rowno) {
                    row = new ArrayList();
                    this.cells.add(row);
                } else {
                    row = this.cells.get(rowno);
                }
                JComponent cell = this.createDayCell(cal, eventMap, month, calInfo.getId());
                this.calPanel.add(cell);
                row.add(cell);
                if (cal.get(7) == lastDayOfWeek) {
                    if (cal.get(2) != month) continue block0;
                    ++rowno;
                }
                cal.add(5, 1);
            }
        }
        int colCount = this.getModel().getSelectedCalendars().size() * 7;
        int i = 0;
        while (i < colCount - 1) {
            JLabel line = new JLabel();
            line.setBackground(Color.LIGHT_GRAY);
            line.setOpaque(true);
            if ((i + 1) % 7 == 0) {
                line.setBackground(this.getDescriptor().getLineColor3());
            }
            this.calPanel.add(line);
            this.vLines.add(line);
            ++i;
        }
        int rowCount = this.cells.size() - 1;
        int i2 = 0;
        while (i2 < rowCount) {
            JLabel line = new JLabel();
            line.setBackground(Color.LIGHT_GRAY);
            line.setOpaque(true);
            this.calPanel.add(line);
            this.hLines.add(line);
            ++i2;
        }
        this.columnHeader.setModel(this.getModel());
        this.columnHeader.setPopupMenuCallback(this.popupMenuCallback);
        this.columnHeader.refresh();
    }

    private JComponent createDayCell(java.util.Calendar cal, Map<Date, List<Event>> eventMap, int month, Object calId) throws Exception {
        Font eventFont = this.font;
        TableLayoutPanel panel = new TableLayoutPanel();
        if (cal.get(2) == month) {
            panel.setBackground(Color.WHITE);
        } else {
            panel.setBackground(new Color(230, 230, 230));
        }
        panel.createColumn(-1.0);
        int dayno = cal.get(5);
        String text = "" + dayno;
        TableLayoutPanel.Row row = panel.createRow();
        JLabel label = new JLabel(text);
        label.setFont(this.font.deriveFont(1));
        row.createCell(label);
        panel.createRow(-1.0);
        DateFormat format = DateFormat.getTimeInstance(3, Locale.getDefault());
        List<Event> events = eventMap.get(DateUtil.round2Day(cal.getTime()));
        if (events != null) {
            for (Event event : events) {
                row = panel.createRow();
                String time = format.format(event.getStart());
                String summary = "";
                if (event.getSummary() != null) {
                    summary = event.getSummary();
                }
                JLabel eventLabel = new JLabel(String.valueOf(time) + " " + summary);
                eventLabel.setFont(eventFont);
                time = String.valueOf(time) + "-" + format.format(event.getEnd());
                eventLabel.setToolTipText(String.valueOf(time) + " " + summary);
                eventLabel.setOpaque(true);
                eventLabel.setBackground(event.getColor());
                eventLabel.setForeground(FrameArea.computeForeground(event.getColor()));
                eventLabel.setCursor(new Cursor(12));
                if (event.getIcon() != null) {
                    eventLabel.setIcon(event.getIcon());
                }
                eventLabel.addMouseListener(new EventMouseListener(event, calId));
                row.createCell(eventLabel, 0, 2);
            }
        }
        panel.addMouseListener(new DayMouseListener(calId, cal.getTime()));
        JScrollPane scrollPanel = new JScrollPane(panel, 20, 31);
        scrollPanel.setPreferredSize(new Dimension(100, 100));
        return panel;
    }

    @Override
    protected Date getDate(int xPos, int yPos) throws Exception {
        return null;
    }

    public long getTimeInterval() throws Exception {
        return -1702967296L;
    }

    protected String getHeaderText() throws Exception {
        java.util.Calendar cal = DateUtil.newCalendar();
        cal.setTime(this.getInterval().getStartDate());
        SimpleDateFormat format = new SimpleDateFormat("MMMM yyyy", Locale.getDefault());
        return TextUtil.formatCase(format.format(cal.getTime()));
    }

    @Override
    protected boolean supportsDrag() {
        return false;
    }

    private int getPreferredHeight() {
        return this.cells.size() * 40;
    }

    @Override
    public JComponent getComponent() {
        return this.scrollPane;
    }

    @Override
    public void addListener(CalendarListener listener) {
        super.addListener(listener);
        this.columnHeader.addCalendarListener(listener);
    }

    private class DayMouseListener
    extends MouseAdapter {
        private Object calId;
        private Date date;

        public DayMouseListener(Object calId, Date date) {
            this.calId = calId;
            this.date = date;
        }

        public void mouseEntered(MouseEvent e) {
            JPanel label = (JPanel)e.getSource();
            label.setCursor(new Cursor(12));
            label.setBackground(label.getBackground().darker());
            label.setForeground(Color.LIGHT_GRAY);
        }

        public void mouseExited(MouseEvent e) {
            JPanel label = (JPanel)e.getSource();
            label.setCursor(new Cursor(0));
            label.setBackground(label.getBackground().brighter());
            label.setForeground(Color.BLACK);
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (MonthView.this.listener == null) {
                    return;
                }
                if (e.getClickCount() < 2) {
                    MonthView.this.listener.dateSelected(this.date);
                    return;
                }
                if (!MonthView.this.getModel().isInsertable(this.calId, this.date)) {
                    return;
                }
                MonthView.this.listener.newEvent(this.calId, this.date);
            }
            catch (Exception exc) {
                ErrorHandler.handleError(exc);
            }
        }
    }

    private class EventMouseListener
    extends MouseAdapter {
        private Event event;
        private Object calId;

        public EventMouseListener(Event event, Object calId) {
            this.calId = calId;
            this.event = event;
        }

        public void mouseClicked(MouseEvent mevent) {
            try {
                if (mevent.getClickCount() == 2) {
                    MonthView.this.listener.showEvent(this.calId, this.event);
                }
            }
            catch (Exception e) {
                ErrorHandler.handleError(e);
            }
        }
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            try {
                int width = 7 * MonthView.this.getModel().getSelectedCalendars().size() * 10;
                return new Dimension(width, MonthView.this.getPreferredHeight());
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(50, 100);
        }

        public void layoutContainer(Container parent) {
            try {
                double width = parent.getWidth();
                width /= (double)MonthView.this.getModel().getSelectedCalendars().size();
                width /= 7.0;
                double height = parent.getHeight();
                height /= (double)MonthView.this.cells.size();
                int row = 0;
                while (row < MonthView.this.cells.size()) {
                    List rowList = (List)MonthView.this.cells.get(row);
                    int col = 0;
                    while (col < rowList.size()) {
                        JComponent cell = (JComponent)rowList.get(col);
                        cell.setBounds((int)((double)col * width + 1.0), (int)((double)row * height + 1.0), (int)width - 1, (int)height - 1);
                        ++col;
                    }
                    ++row;
                }
                int colCount = MonthView.this.getModel().getSelectedCalendars().size() * 7;
                int i = 0;
                while (i < colCount - 1) {
                    try {
                        JLabel line = (JLabel)MonthView.this.vLines.get(i);
                        line.setBounds((int)((double)(i + 1) * width), 0, 1, parent.getHeight());
                    }
                    catch (Exception line) {
                        // empty catch block
                    }
                    ++i;
                }
                int rowCount = MonthView.this.cells.size() - 1;
                int i2 = 0;
                while (i2 < rowCount) {
                    try {
                        JLabel line = (JLabel)MonthView.this.hLines.get(i2);
                        line.setBounds(0, (int)((double)(i2 + 1) * height), parent.getWidth(), 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                throw BizcalException.create(e);
            }
        }
    }
}

