/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Bundle;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.LocaleBroker;
import bizcal.util.StreamCopier;
import bizcal.util.TextUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WeekStepper {
    private TableLayoutPanel panel;
    private Calendar cal;
    private JComboBox yearCombo;
    private JComboBox weekCombo;
    private JLabel textLabel;
    private List listeners = new ArrayList();
    private String fastRewindArrow = "/bizcal/res/go_fb.gif";
    private String prevArrow = "/bizcal/res/go_back.gif";
    private String nextArrow = "/bizcal/res/go_forward.gif";
    private String fastForwardArrow = "/bizcal/res/go_ff.gif";

    public WeekStepper() throws Exception {
        this.cal = Calendar.getInstance(LocaleBroker.getLocale());
        this.cal.setTime(DateUtil.round2Week(new Date()));
        this.panel = new TableLayoutPanel();
        this.panel.createColumn();
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn(-1.0);
        this.panel.createColumn();
        this.panel.createColumn();
        TableLayoutPanel.Row row = this.panel.createRow();
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    WeekStepper.this.previousYear();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.fastRewindArrow, listener));
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    WeekStepper.this.previous();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.prevArrow, listener));
        row.createCell();
        this.initYearCombo();
        this.initWeekCombo();
        this.textLabel = new JLabel();
        this.setCombos();
        row.createCell(this.yearCombo);
        row.createCell();
        row.createCell(this.weekCombo);
        row.createCell();
        row.createCell(this.textLabel);
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    WeekStepper.this.next();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.nextArrow, listener));
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    WeekStepper.this.nextYear();
                }
                catch (Exception e) {
                    ErrorHandler.handleError(e);
                }
            }
        };
        row.createCell(this.createButton(this.fastForwardArrow, listener));
    }

    private void initYearCombo() throws Exception {
        this.yearCombo = new JComboBox();
        int year = this.cal.get(1);
        int i = year - 1;
        while (i < year + 4) {
            this.yearCombo.addItem(i);
            ++i;
        }
        this.yearCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int year = (Integer)WeekStepper.this.yearCombo.getSelectedItem();
                    WeekStepper.this.cal.set(1, year);
                    WeekStepper.this.refreshWeekCombo();
                    WeekStepper.this.setLabel();
                }
                catch (Exception e) {
                    throw BizcalException.create(e);
                }
            }
        });
    }

    private void initWeekCombo() throws Exception {
        this.weekCombo = new JComboBox();
        int currWeek = this.cal.get(3);
        this.refreshWeekCombo();
        this.weekCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    Integer selectedItem = (Integer)WeekStepper.this.weekCombo.getSelectedItem();
                    if (selectedItem == null) {
                        return;
                    }
                    int week = (Integer)WeekStepper.this.weekCombo.getSelectedItem();
                    WeekStepper.this.cal.set(3, week);
                    WeekStepper.this.setLabel();
                }
                catch (Exception e) {
                    throw BizcalException.create(e);
                }
            }
        });
        this.cal.set(3, currWeek);
    }

    private void setCombos() throws Exception {
        int year = this.cal.get(1);
        this.yearCombo.setSelectedItem(year);
        int week = this.cal.get(3);
        if (this.weekCombo.getItemCount() < week) {
            week = this.weekCombo.getItemCount();
        }
        this.weekCombo.setSelectedIndex(week - 1);
        this.setLabel();
    }

    private void setLabel() throws Exception {
        this.textLabel.setText(this.getText());
    }

    private void refreshWeekCombo() {
        int currWeek = this.cal.get(3);
        this.weekCombo.removeAllItems();
        int maxWeekNo = this.cal.getActualMaximum(3);
        int i = 1;
        while (i <= maxWeekNo) {
            this.weekCombo.addItem(i);
            ++i;
        }
        this.cal.set(3, currWeek);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    private void next() throws Exception {
        this.cal.add(3, 1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void previous() throws Exception {
        this.cal.add(3, -1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void nextYear() throws Exception {
        this.cal.add(1, 1);
        this.cal.set(7, this.cal.getFirstDayOfWeek());
        this.setCombos();
        this.fireStateChanged();
    }

    private void previousYear() throws Exception {
        this.cal.add(1, -1);
        this.cal.set(7, this.cal.getFirstDayOfWeek());
        this.setCombos();
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireStateChanged() throws Exception {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(event);
        }
    }

    private Icon getIcon(String filename) throws Exception {
        byte[] bytes = StreamCopier.copyToByteArray(this.getClass().getResourceAsStream(filename));
        return new ImageIcon(bytes);
    }

    private JComponent createButton(String filename, ActionListener listener) throws Exception {
        JButton button = new JButton(this.getIcon(filename));
        button.addActionListener(listener);
        return button;
    }

    public void setDate(Date date) throws Exception {
        this.cal.setTime(DateUtil.round2Week(date));
        this.setCombos();
        this.fireStateChanged();
    }

    private String getText() throws Exception {
        StringBuffer str = new StringBuffer();
        str.append(String.valueOf(Bundle.translate("Week")) + " " + this.cal.get(3) + ": ");
        Calendar cal2 = Calendar.getInstance(LocaleBroker.getLocale());
        int currYear = cal2.get(1);
        int year = this.cal.get(1);
        if (currYear != year) {
            str.append(String.valueOf(year) + " ");
        }
        int month = this.cal.get(2);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MMM");
        str.append(String.valueOf(TextUtil.formatCase(monthFormat.format(this.cal.getTime()))) + " ");
        int day = this.cal.get(5);
        str.append(day);
        str.append(" - ");
        cal2.setTime(this.cal.getTime());
        cal2.add(7, 6);
        int month2 = cal2.get(2);
        if (month != month2) {
            str.append(String.valueOf(TextUtil.formatCase(monthFormat.format(cal2.getTime()))) + " ");
        }
        day = cal2.get(5);
        str.append(day);
        return str.toString();
    }
}

