/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import bizcal.common.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ErrorHandler {
    public static void handleError(Throwable e) {
        ErrorHandler.handleError(e, null);
    }

    public static void handleError(Throwable e, Component comp) {
        try {
            e.printStackTrace();
            ErrorHandler.showError(comp, Bundle.translate("Technical error"), Bundle.translate("Technical error"), e);
        }
        catch (Exception exc) {
            ErrorHandler.showError(comp, "Error message", "Error message", exc);
        }
    }

    public static void showError(Component comp, String title, String msg, Throwable t) {
        if (t != null) {
            Window win = null;
            if (comp != null) {
                win = comp instanceof Window ? (Window)comp : SwingUtilities.getWindowAncestor(comp);
            }
            DetailsDialog dd = null;
            dd = win instanceof Frame ? new DetailsDialog((Frame)win, title, 0) : (win instanceof Dialog ? new DetailsDialog((Dialog)win, title, 0) : new DetailsDialog(title, 0));
            if (msg == null || msg.length() == 0) {
                dd.setMsgText(t.getMessage());
            } else {
                dd.setMsgText(msg);
            }
            dd.setDetailsText(ErrorHandler.getStackTrace(t));
            dd.setLocationRelativeTo(comp);
            dd.setVisible(true);
            dd.requestFocus();
        } else {
            ErrorHandler.showError(comp, title, msg);
        }
    }

    public static void showError(Component comp, String title, String msg) {
        JOptionPane.showMessageDialog(comp, msg, title, 0);
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    private static Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private static String translate(String key) {
        try {
            return Bundle.translate(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    private static class DetailsDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private JLabel msg;
        private JTextArea details;

        public DetailsDialog(String title, int icon_type) {
            super((Frame)null, title, false);
            this.setup(icon_type);
        }

        public DetailsDialog(Frame owner, String title, int icon_type) {
            super(owner, title, true);
            this.setup(icon_type);
        }

        public DetailsDialog(Dialog owner, String title, int icon_type) {
            super(owner, title, true);
            this.setup(icon_type);
        }

        private void setup(int icon_type) {
            this.setModal(true);
            this.msg = new JLabel();
            this.msg.setIcon(ErrorHandler.getIconForType(icon_type));
            this.details = new JTextArea();
            this.details.setLineWrap(false);
            this.details.setWrapStyleWord(false);
            final JScrollPane dpane = new JScrollPane(this.details);
            dpane.setVisible(false);
            JButton ok = new JButton(ErrorHandler.translate("OK"));
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DetailsDialog.this.dispose();
                }
            });
            final String showDetails = ErrorHandler.translate("Show details");
            final String hideDetails = ErrorHandler.translate("Hide details");
            final JButton dbutton = new JButton(showDetails);
            dbutton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (dpane.isVisible()) {
                        dpane.setVisible(false);
                        dbutton.setText(showDetails);
                        DetailsDialog.this.doSizePack();
                    } else {
                        dpane.setVisible(true);
                        dbutton.setText(hideDetails);
                        DetailsDialog.this.doSizePack();
                    }
                }
            });
            JPanel bpan = new JPanel(new FlowLayout(1, 5, 0));
            bpan.add(dbutton);
            bpan.add(ok);
            JPanel cont = new JPanel(new BorderLayout(5, 5));
            cont.add((Component)this.msg, "North");
            cont.add((Component)dpane, "Center");
            cont.add((Component)bpan, "South");
            cont.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setContentPane(cont);
            this.doSizePack();
        }

        public void setMsgText(String txt) {
            this.msg.setText(txt);
            this.doSizePack();
        }

        public void setDetailsText(String txt) {
            this.details.setText(txt);
            this.doSizePack();
        }

        private void doSizePack() {
            this.pack();
            Dimension screenSize = this.getToolkit().getScreenSize();
            Dimension size = this.getSize();
            Point parentLoc = this.getParent().getLocation();
            this.setLocation(parentLoc.x + 25, parentLoc.y + 25);
            Point location = this.getLocation();
            int width = -1;
            int height = -1;
            if (size.height + location.y > screenSize.height) {
                height = screenSize.height - location.y - 30;
            }
            if (size.width + location.x > screenSize.width) {
                width = screenSize.width - location.x;
            }
            if (size.width < 300) {
                width = 300;
            }
            if (size.width > 640) {
                width = 750;
            }
            if (size.height > 480) {
                height = 550;
            }
            if (width != -1 || height != -1) {
                this.setSize(new Dimension(width == -1 ? size.width : width, height == -1 ? size.height : height));
                this.doLayout();
            }
        }
    }
}

